/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.Intpair;
import savilerow.model.Sat;

public class NumberConstant
extends ASTNode {
    public static final long serialVersionUID = 1L;
    long num;

    public NumberConstant(long l) {
        this.num = l;
    }

    @Override
    public ASTNode copy() {
        return new NumberConstant(this.num);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof NumberConstant)) {
            return false;
        }
        return this.num == ((NumberConstant)object).num;
    }

    @Override
    public int hashCode() {
        if (this.hashCache == Integer.MIN_VALUE) {
            int n;
            this.hashCache = n = new Long(this.num).hashCode();
            return n;
        }
        return this.hashCache;
    }

    @Override
    public String toString() {
        return String.valueOf(this.num);
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public boolean isRelation() {
        return false;
    }

    @Override
    public long getValue() {
        return this.num;
    }

    @Override
    public ArrayList<Intpair> getIntervalSet() {
        ArrayList<Intpair> arrayList = new ArrayList<Intpair>();
        arrayList.add(new Intpair(this.num, this.num));
        return arrayList;
    }

    @Override
    public long directEncode(Sat sat, long l) {
        return l == this.num ? sat.getTrue() : -sat.getTrue();
    }

    @Override
    public long orderEncode(Sat sat, long l) {
        if (this.num <= l) {
            return sat.getTrue();
        }
        return -sat.getTrue();
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(this.num);
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append(this.num);
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        assert (!bl);
        stringBuilder.append(this.num);
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        assert (!bl);
        stringBuilder.append(this.num);
    }

    @Override
    public void toJSON(StringBuilder stringBuilder) {
        stringBuilder.append(this.num + "\n");
    }
}

