/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.Intpair;
import savilerow.expression.Max;
import savilerow.expression.Min;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.WeightedSum;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class Times
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public Times(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    public Times(ArrayList<ASTNode> arrayList) {
        super(arrayList);
    }

    @Override
    public ASTNode copy() {
        return new Times(this.getChildren());
    }

    @Override
    public ASTNode simplify() {
        ArrayList<ASTNode> arrayList = this.getChildren();
        boolean bl = false;
        long l = 1L;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i).isConstant()) {
                if (l != 1L) {
                    bl = true;
                }
                l = Times.multiply(l, arrayList.get(i).getValue());
                arrayList.remove(i);
                --i;
                continue;
            }
            if (CmdFlags.getOutputReady() || !(arrayList.get(i) instanceof Times)) continue;
            bl = true;
            arrayList.addAll(arrayList.get(i).getChildren());
            arrayList.remove(i);
            --i;
        }
        if (l == 0L) {
            return new NumberConstant(0L);
        }
        if (arrayList.size() == 0) {
            return new NumberConstant(l);
        }
        if (arrayList.size() == 1) {
            if (l == 1L) {
                return arrayList.get(0);
            }
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            arrayList2.add(l);
            return new WeightedSum(arrayList, arrayList2);
        }
        if (l != 1L) {
            arrayList.add(new NumberConstant(l));
        }
        if (bl) {
            return new Times(arrayList);
        }
        return this;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!this.getChild(i).typecheck(symbolTable)) {
                return false;
            }
            if (this.getChild(i).getDimension() > 0) {
                CmdFlags.println("ERROR: Unexpected matrix in product: " + this);
                return false;
            }
            if (!this.getChild(i).isSet()) continue;
            CmdFlags.println("ERROR: Unexpected set in product: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode normalise() {
        ArrayList<ASTNode> arrayList = this.getChildren();
        boolean bl = Times.sortByHashcode(arrayList);
        if (bl) {
            return new Times(arrayList);
        }
        return this;
    }

    @Override
    public long getValue() {
        long l = 1L;
        for (int i = 0; i < this.numChildren(); ++i) {
            assert (this.getChild(i).isConstant());
            l = Times.multiply(l, this.getChild(i).getValue());
        }
        return l;
    }

    static long multiply(long l, long l2) {
        return Intpair.BigIntegerToLong(BigInteger.valueOf(l).multiply(BigInteger.valueOf(l2)));
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        for (int i = 1; i < this.numChildren(); ++i) {
            Intpair intpair2 = this.getChild(i).getBounds();
            long l = Times.multiply(intpair.lower, intpair2.lower);
            long l2 = Times.multiply(intpair.upper, intpair2.lower);
            long l3 = Times.multiply(intpair.lower, intpair2.upper);
            long l4 = Times.multiply(intpair.upper, intpair2.upper);
            intpair.lower = Math.min(l, Math.min(l2, Math.min(l3, l4)));
            intpair.upper = Math.max(l, Math.max(l2, Math.max(l3, l4)));
        }
        return this.lookupBounds(intpair);
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(0).getBoundsAST();
        for (int i = 1; i < this.numChildren(); ++i) {
            PairASTNode pairASTNode2 = this.getChild(i).getBoundsAST();
            Times times = new Times(pairASTNode.e1, pairASTNode2.e1);
            Times times2 = new Times(pairASTNode.e2, pairASTNode2.e1);
            Times times3 = new Times(pairASTNode.e1, pairASTNode2.e2);
            Times times4 = new Times(pairASTNode.e2, pairASTNode2.e2);
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            arrayList.add(times);
            arrayList.add(times2);
            arrayList.add(times3);
            arrayList.add(times4);
            pairASTNode.e1 = new Min(arrayList);
            pairASTNode.e2 = new Max(arrayList);
        }
        return pairASTNode;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public boolean isCommAssoc() {
        return true;
    }

    @Override
    public String toString() {
        String string = "(";
        for (int i = 0; i < this.numChildren(); ++i) {
            string = string + this.getChild(i);
            if (i >= this.numChildren() - 1) continue;
            string = string + " * ";
        }
        return string + ")";
    }

    @Override
    public void toMinionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        assert (this.numChildren() == 2);
        stringBuilder.append("product(");
        this.getChild(0).toMinion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toMinion(stringBuilder, false);
        stringBuilder.append(", ");
        aSTNode.toMinion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        assert (this.numChildren() == 2);
        stringBuilder.append("Product(");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(",");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        assert (this.numChildren() == 2);
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("product(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        aSTNode.toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toFlatzincWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        assert (this.numChildren() == 2);
        stringBuilder.append("constraint int_times(");
        this.getChild(0).toFlatzinc(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toFlatzinc(stringBuilder, false);
        stringBuilder.append(", ");
        aSTNode.toFlatzinc(stringBuilder, false);
        stringBuilder.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        assert (this.numChildren() == 2);
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append("*");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toSATWithAuxVar(Sat sat, ASTNode aSTNode) throws IOException {
        sat.ternaryEncoding(this, aSTNode);
    }

    @Override
    public boolean test(long l, long l2, long l3) {
        return this.func(l, l2) == l3;
    }

    @Override
    public long func(long l, long l2) {
        return Times.multiply(l, l2);
    }

    @Override
    public boolean childrenAreSymmetric() {
        return true;
    }
}

