/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.Intpair;
import savilerow.expression.Max;
import savilerow.expression.Min;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.Times;
import savilerow.expression.Unary;
import savilerow.expression.WeightedSum;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class UnaryMinus
extends Unary {
    public static final long serialVersionUID = 1L;

    public UnaryMinus(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new UnaryMinus(this.getChild(0));
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof UnaryMinus) {
            return this.getChild(0).getChild(0);
        }
        if (this.getChild(0).isConstant()) {
            return new NumberConstant(-this.getChild(0).getValue());
        }
        if (this.getChild(0) instanceof WeightedSum) {
            ArrayList<Long> arrayList = ((WeightedSum)this.getChild(0)).getWeights();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.set(i, -arrayList.get(i).longValue());
            }
            return new WeightedSum(this.getChild(0).getChildren(), arrayList);
        }
        if (this.getChild(0) instanceof Times) {
            ArrayList<ASTNode> arrayList = this.getChild(0).getChildren();
            arrayList.set(0, new UnaryMinus(arrayList.get(0)));
            return new Times(arrayList);
        }
        if (this.getChild(0) instanceof Max || this.getChild(0) instanceof Min) {
            ArrayList<ASTNode> arrayList = this.getChild(0).getChildren();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.set(i, new UnaryMinus(arrayList.get(i)));
            }
            if (this.getChild(0) instanceof Max) {
                return new Min(arrayList);
            }
            return new Max(arrayList);
        }
        return this;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() > 0) {
            CmdFlags.println("ERROR: Unexpected matrix in unary minus: " + this);
            return false;
        }
        if (this.getChild(0).isSet()) {
            CmdFlags.println("ERROR: Unexpected set in unary minus: " + this);
            return false;
        }
        return true;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return !CmdFlags.getClasstrans();
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public void toMinionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append("minuseq(");
        aSTNode.toMinion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(0).toMinion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toFlatzincWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append("constraint int_negate(");
        this.getChild(0).toFlatzinc(stringBuilder, false);
        stringBuilder.append(",");
        aSTNode.toFlatzinc(stringBuilder, false);
        stringBuilder.append(");");
    }

    @Override
    public String toString() {
        return "(-" + this.getChild(0) + ")";
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("neg(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("(-");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        if (intpair.lower == Long.MIN_VALUE) {
            ++intpair.lower;
        }
        long l = -intpair.lower;
        intpair.lower = -intpair.upper;
        intpair.upper = l;
        return this.lookupBounds(intpair);
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(0).getBoundsAST();
        UnaryMinus unaryMinus = new UnaryMinus(pairASTNode.e2);
        UnaryMinus unaryMinus2 = new UnaryMinus(pairASTNode.e1);
        pairASTNode.e1 = unaryMinus;
        pairASTNode.e2 = unaryMinus2;
        return pairASTNode;
    }

    @Override
    public void toSATWithAuxVar(Sat sat, ASTNode aSTNode) throws IOException {
        sat.supportEncodingBinary(this, this.getChild(0), aSTNode);
    }

    @Override
    public boolean test(long l, long l2) {
        return l == -l2;
    }
}

