/*
 * Decompiled with CFR 0.152.
 */
package savilerow.solver;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.expression.ASTNode;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.Minimising;
import savilerow.expression.Solution;
import savilerow.model.Model;
import savilerow.model.NumberMap;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;
import savilerow.solver.Solver;
import savilerow.solver.Stats;

public abstract class SATSolver
extends Solver {
    static int solutionNumber = 1;
    private ArrayList<String> stdout_lines = new ArrayList();
    Model m;

    public SATSolver(Model model) {
        this.m = model;
    }

    @Override
    public void findSolutions(String string, String string2, Model model) throws IOException, InterruptedException {
        if (model.objective != null) {
            this.findObjective(string, string2, model);
        } else if (CmdFlags.getFindAllSolutions() || CmdFlags.getFindNumSolutions() > -1L) {
            this.findMultipleSolutions(string, string2, model);
        } else {
            this.findOneSolution(string, string2, model);
        }
    }

    public abstract Pair<ArrayList<String>, Stats> runSatSolver(String var1, String var2, Model var3, Stats var4) throws IOException, InterruptedException;

    public void findMultipleSolutions(String string, String string2, Model model) {
        double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
        int n = 6;
        try {
            long l = 0L;
            Stats stats = null;
            while (CmdFlags.getFindAllSolutions() || l < CmdFlags.getFindNumSolutions()) {
                Pair<ArrayList<String>, Stats> pair = this.runSatSolver(string, string2, model, null);
                ArrayList<String> arrayList = pair.getFirst();
                Stats stats2 = pair.getSecond();
                stats = stats == null ? stats2 : stats.add(stats2);
                if (arrayList == null) break;
                Solution solution = this.solverSolToAST(arrayList, model.global_symbols);
                String string3 = String.format("%0" + n + "d", l + 1L);
                this.createSolutionFile(solution, CmdFlags.solutionfile + "." + string3);
                ++l;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (arrayList.get(i).contains("-")) {
                        arrayList.set(i, arrayList.get(i).split("-")[1]);
                    } else {
                        arrayList.set(i, "-" + arrayList.get(i));
                    }
                    stringBuilder.append(arrayList.get(i));
                    stringBuilder.append(" ");
                }
                model.satModel.addClauseAfterFinalise(stringBuilder.toString());
            }
            stats.putValue("SavileRowTotalTime", String.valueOf(d));
            this.writeToFileSolutionStats(stats);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void findObjective(String string, String string2, Model model) {
        double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
        Identifier identifier = (Identifier)model.objective.getChild(0);
        ArrayList<Intpair> arrayList = identifier.global_symbols.getDomain(identifier.getName()).getIntervalSet();
        ArrayList<String> arrayList2 = null;
        int n = 0;
        Stats stats = null;
        try {
            Object object;
            while (true) {
                String string3;
                long l;
                if (((Pair)(object = this.runSatSolver(string, string2, model, stats))).getFirst() != null) {
                    arrayList2 = ((Pair)object).getFirst();
                }
                Stats stats2 = ((Pair)object).getSecond();
                stats = stats == null ? stats2 : stats.add(stats2);
                if (((Pair)object).getFirst() == null) break;
                HashMap<String, Long> hashMap = this.readAllAssignments(arrayList2, model.global_symbols);
                Long l2 = hashMap.get(model.objective.getChild(0).toString());
                System.out.println("While optimising, found value: " + l2);
                if (model.objective instanceof Minimising) {
                    l = model.satModel.getOrderVariable(identifier.getName(), l2 - 1L);
                    string3 = String.valueOf(l);
                } else {
                    l = model.satModel.getOrderVariable(identifier.getName(), l2);
                    string3 = String.valueOf(-l);
                }
                model.satModel.addClauseAfterFinalise(string3);
                ++n;
            }
            if (n > 0) {
                object = this.solverSolToAST(arrayList2, model.global_symbols);
                this.createSolutionFile((ASTNode)object, CmdFlags.solutionfile);
            } else if (model.incumbentSolution != null) {
                this.createSolutionFile(model.incumbentSolution, CmdFlags.solutionfile);
            }
            stats.putValue("SavileRowTotalTime", String.valueOf(d));
            this.writeToFileSolutionStats(stats);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void findOneSolution(String string, String string2, Model model) {
        double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
        try {
            Pair<ArrayList<String>, Stats> pair = this.runSatSolver(string, string2, model, null);
            ArrayList<String> arrayList = pair.getFirst();
            Stats stats = pair.getSecond();
            stats.putValue("SavileRowTotalTime", String.valueOf(d));
            this.writeToFileSolutionStats(stats);
            if (arrayList != null) {
                Solution solution = this.solverSolToAST(arrayList, model.global_symbols);
                this.createSolutionFile(solution, CmdFlags.solutionfile);
            } else if (model.incumbentSolution != null) {
                this.createSolutionFile(model.incumbentSolution, CmdFlags.solutionfile);
            } else {
                System.out.println("No solution found.");
            }
            CmdFlags.rmTempFiles();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    Solution parseOneSolverSolution(SymbolTable symbolTable, BufferedReader bufferedReader) {
        return null;
    }

    @Override
    Solution parseLastSolverSolution(SymbolTable symbolTable, BufferedReader bufferedReader) {
        return null;
    }

    private void writeToFileSolutionStats(Stats stats) {
        stats.putValue("SATVars", String.valueOf(this.m.satModel.getNumVars()));
        stats.putValue("SATClauses", String.valueOf(this.m.satModel.getNumClauses()));
        if (stats != null) {
            stats.makeInfoFiles();
        }
    }

    @Override
    HashMap<String, Long> readAllAssignments(ArrayList<String> arrayList, SymbolTable symbolTable) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        Sat sat = symbolTable.m.satModel;
        long l = 0L;
        for (int i = 0; i < arrayList.size(); ++i) {
            long l2 = Long.valueOf(arrayList.get(i));
            NumberMap numberMap = sat.getDimacsMapping(l2);
            if (numberMap != null) {
                hashMap.put(numberMap.getVariable(), numberMap.getValue());
                l = l2;
                continue;
            }
            if (l2 > 0L && (numberMap = sat.orderMappingMin.get(l2)) != null) {
                hashMap.put(numberMap.getVariable(), numberMap.getValue());
                l = l2;
                continue;
            }
            if (l2 > 0L && l < 0L && (numberMap = sat.orderMappingMid.get(l2)) != null) {
                hashMap.put(numberMap.getVariable(), numberMap.getValue());
                l = l2;
                continue;
            }
            if (l2 < 0L && (numberMap = sat.orderMappingMax.get(l2)) != null) {
                hashMap.put(numberMap.getVariable(), numberMap.getValue());
                l = l2;
                continue;
            }
            l = l2;
        }
        if (CmdFlags.getTestSolutions()) {
            this.checkSolution(hashMap);
        }
        return hashMap;
    }
}

