/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.File;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Random;
import savilerow.HelpText;
import savilerow.SolEnum;
import savilerow.model.Model;

public final class CmdFlags {
    private static boolean verbose = false;
    private static String minionpath = "minion";
    private static String gecodepath = "fzn-gecode";
    private static String chuffedpath = "fzn-chuffed";
    private static String maxsatpath = "open-wbo";
    private static String symdetectpath = "symmetry_detect";
    private static String satsolverpath = null;
    private static String glucosepath = "glucose";
    private static String satfamily = "glucose";
    private static boolean runsolver = false;
    private static SolEnum soltype = SolEnum.DEFAULT;
    private static boolean use_mappers = true;
    private static boolean use_minionmappers = false;
    private static boolean use_cse = true;
    private static boolean use_ac_cse = false;
    private static boolean use_active_ac_cse = false;
    private static boolean use_active_ac_cse2 = false;
    private static boolean use_active_cse = true;
    private static boolean use_ac_cse_alt = false;
    private static boolean use_sat_decomp_cse = false;
    private static boolean use_sat_alt = false;
    private static boolean use_sat_pb_mdd = false;
    public static boolean use_commander = true;
    private static boolean use_mzn_lns = false;
    private static boolean make_tables = false;
    public static ArrayList<Integer> make_tables_scope;
    public static boolean verbose_make_short;
    public static int table_squash;
    public static int make_short_tab;
    public static boolean short_tab_sat_extra;
    private static boolean use_var_symmetry_breaking;
    private static boolean use_eliminate_vars;
    private static boolean graph_col_sym_break;
    public static int accse_heuristic;
    public static boolean dryruns;
    private static boolean use_delete_vars;
    private static boolean use_propagate;
    private static boolean use_propagate_extend;
    private static boolean use_propagate_extend2;
    private static boolean remove_redundant_vars;
    private static boolean aux_non_functional;
    private static boolean opt_warm_start;
    private static String opt_strategy;
    private static boolean find_all_solutions;
    private static long find_num_solutions;
    private static boolean solutions_to_stdout_one_line;
    private static boolean solutions_to_stdout;
    private static boolean solutions_to_null;
    private static boolean use_boundvars;
    private static boolean use_aggregate;
    private static boolean test_solutions;
    private static boolean param_to_json;
    private static boolean expand_short_tab;
    private static boolean warn_undef;
    private static boolean save_symbols;
    private static boolean output_ready;
    private static boolean after_aggregate;
    public static final int Normal = 1;
    public static final int ReadSolution = 2;
    public static final int Multi = 3;
    public static boolean multistage;
    private static int seed;
    private static Random randomGen;
    private static int mode;
    public static String version;
    private static ArrayList<String> solverflags;
    private static String tempFileSuffix;
    private static String minionStatsTempFile;
    private static String minionSolsTempFile;
    public static volatile long startTime;
    public static String preprocess;
    public static int preproc_time_limit;
    public static String eprimefile;
    public static String paramfile;
    public static String paramstring;
    public static String solutionfile;
    public static String minionsolfile;
    public static String infofile;
    public static String minionfile;
    public static String dominionfile;
    public static String fznfile;
    public static String minizincfile;
    public static String satfile;
    public static String auxfile;
    public static long timelimit;
    public static long cnflimit;
    public static volatile boolean runningSolver;
    public static LinkedHashMap<String, Integer> stats;
    public static Model checkSolModel;
    public static Model currentModel;
    private static int ctnum;

    public static Random getRandomGen() {
        if (randomGen == null) {
            randomGen = new Random(seed);
        }
        return randomGen;
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    public static void setMinion(String string) {
        minionpath = string;
    }

    public static String getMinion() {
        return minionpath;
    }

    public static void setGecode(String string) {
        gecodepath = string;
    }

    public static String getGecode() {
        return gecodepath;
    }

    public static void setChuffed(String string) {
        chuffedpath = string;
    }

    public static String getChuffed() {
        return chuffedpath;
    }

    public static void setSymDetect(String string) {
        symdetectpath = string;
    }

    public static String getSymDetect() {
        return symdetectpath;
    }

    public static void setSatSolver(String string) {
        satsolverpath = string;
    }

    public static String getSatSolver() {
        return satsolverpath;
    }

    public static void setSatFamily(String string) {
        satfamily = string;
    }

    public static String getSatFamily() {
        return satfamily;
    }

    public static boolean getRunSolver() {
        return runsolver;
    }

    public static void setRunSolver() {
        runsolver = true;
    }

    public static String getPreprocess() {
        return preprocess;
    }

    public static void setPreprocess(String string) {
        preprocess = string;
    }

    public static int getPreprocTimeLimit() {
        return preproc_time_limit;
    }

    public static long getTimeLimit() {
        return timelimit;
    }

    public static void setTimeLimit(long l) {
        timelimit = l;
    }

    public static long getCNFLimit() {
        return cnflimit;
    }

    public static void setCNFLimit(long l) {
        cnflimit = l;
    }

    public static void setEprimeFile(String string) {
        eprimefile = string;
    }

    public static void setParamFile(String string) {
        paramfile = string;
    }

    public static void setParamString(String string) {
        paramstring = string;
    }

    public static void setMinionFile(String string) {
        minionfile = string;
    }

    public static void setSatFile(String string) {
        satfile = string;
    }

    public static void setMinionSolutionFile(String string) {
        minionsolfile = string;
    }

    public static void setSolutionFile(String string) {
        solutionfile = string;
    }

    public static void setInfoFile(String string) {
        infofile = string;
    }

    public static void setAuxFile(String string) {
        auxfile = string;
    }

    public static void setDominionFile(String string) {
        dominionfile = string;
    }

    public static void setFznFile(String string) {
        fznfile = string;
    }

    public static void setMinizincFile(String string) {
        minizincfile = string;
    }

    public static void printlnIfVerbose(Object object) {
        if (verbose) {
            System.out.println(object);
        }
    }

    public static String getMinionStatsTempFile() {
        return minionStatsTempFile;
    }

    public static String getMinionSolsTempFile() {
        return minionSolsTempFile;
    }

    public static void rmTempFiles() {
        File file = new File(CmdFlags.getMinionStatsTempFile());
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File(CmdFlags.getMinionSolsTempFile())).exists()) {
            file.delete();
        }
    }

    public static void createTempFiles() {
        try {
            new PrintWriter(CmdFlags.getMinionStatsTempFile()).close();
            new PrintWriter(CmdFlags.getMinionSolsTempFile()).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setSolverExtraFlags(ArrayList<String> arrayList) {
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals("")) continue;
            iterator.remove();
        }
        solverflags = arrayList;
    }

    public static ArrayList<String> getSolverExtraFlags() {
        if (solverflags == null) {
            return new ArrayList<String>();
        }
        return solverflags;
    }

    public static boolean getDominiontrans() {
        return soltype == SolEnum.DOMINION;
    }

    public static void setUseDeleteVars(boolean bl) {
        use_delete_vars = bl;
    }

    public static boolean getUseDeleteVars() {
        return use_delete_vars;
    }

    public static void setUseEliminateVars(boolean bl) {
        use_eliminate_vars = bl;
    }

    public static boolean getUseEliminateVars() {
        return use_eliminate_vars;
    }

    public static void setParamToJSON() {
        param_to_json = true;
    }

    public static boolean getParamToJSON() {
        return param_to_json;
    }

    public static boolean getWarnUndef() {
        return warn_undef;
    }

    public static void setOutputReady(boolean bl) {
        output_ready = bl;
    }

    public static boolean getOutputReady() {
        return output_ready;
    }

    public static void setAfterAggregate(boolean bl) {
        after_aggregate = bl;
    }

    public static boolean getAfterAggregate() {
        return after_aggregate;
    }

    public static void setUsePropagate(boolean bl) {
        use_propagate = bl;
    }

    public static boolean getUsePropagate() {
        return use_propagate;
    }

    public static void useMznLNS() {
        use_mzn_lns = true;
    }

    public static boolean getMznLNS() {
        return use_mzn_lns;
    }

    public static void setUsePropagateExtend(boolean bl) {
        use_propagate_extend = bl;
        if (!bl) {
            use_propagate_extend2 = false;
        }
    }

    public static boolean getUsePropagateExtend() {
        return use_propagate_extend;
    }

    public static void setUsePropagateExtend2(boolean bl) {
        use_propagate_extend2 = bl;
    }

    public static boolean getUsePropagateExtend2() {
        return use_propagate_extend2;
    }

    public static void setRemoveRedundantVars(boolean bl) {
        remove_redundant_vars = bl;
    }

    public static boolean getRemoveRedundantVars() {
        return remove_redundant_vars;
    }

    public static void setAuxNonFunctional(boolean bl) {
        aux_non_functional = bl;
    }

    public static boolean getAuxNonFunctional() {
        return aux_non_functional;
    }

    public static void setUseAggregate(boolean bl) {
        use_aggregate = bl;
    }

    public static boolean getUseAggregate() {
        return use_aggregate;
    }

    public static void setUseVarSymBreaking(boolean bl) {
        use_var_symmetry_breaking = bl;
    }

    public static boolean getUseVarSymBreaking() {
        return use_var_symmetry_breaking;
    }

    public static boolean getExpandShortTab() {
        return expand_short_tab;
    }

    public static void setFindAllSolutions(boolean bl) {
        find_all_solutions = bl;
        find_num_solutions = -1L;
    }

    public static boolean getFindAllSolutions() {
        return find_all_solutions;
    }

    public static boolean getSolutionsToStdoutOneLine() {
        return solutions_to_stdout_one_line;
    }

    public static void setSolutionsToStdoutOneLine(boolean bl) {
        solutions_to_stdout_one_line = bl;
    }

    public static void setSolutionsToStdout(boolean bl) {
        solutions_to_stdout = bl;
    }

    public static boolean getSolutionsToStdout() {
        return solutions_to_stdout;
    }

    public static void setSolutionsToNull(boolean bl) {
        solutions_to_null = bl;
    }

    public static boolean getSolutionsToNull() {
        return solutions_to_null;
    }

    public static void setFindNumSolutions(long l) {
        find_num_solutions = l;
        find_all_solutions = false;
    }

    public static long getFindNumSolutions() {
        return find_num_solutions;
    }

    public static void setUseBoundVars(boolean bl) {
        use_boundvars = bl;
    }

    public static boolean getUseBoundVars() {
        return use_boundvars;
    }

    public static boolean getGecodetrans() {
        return soltype == SolEnum.GECODE;
    }

    public static boolean getChuffedtrans() {
        return soltype == SolEnum.CHUFFED;
    }

    public static boolean getMiniontrans() {
        return soltype == SolEnum.MINION || soltype == SolEnum.MINIONSNS;
    }

    public static boolean getMinionSNStrans() {
        return soltype == SolEnum.MINIONSNS;
    }

    public static boolean getMinizinctrans() {
        return soltype == SolEnum.MINIZINC;
    }

    public static boolean getSattrans() {
        return soltype == SolEnum.SAT || soltype == SolEnum.MAXSAT;
    }

    public static boolean getMaxsattrans() {
        return soltype == SolEnum.MAXSAT;
    }

    public static void setSatAlt() {
        use_sat_alt = true;
    }

    public static boolean getSatAlt() {
        return use_sat_alt;
    }

    public static boolean getSatMDD() {
        return use_sat_pb_mdd;
    }

    public static void setSatDecompCSE(boolean bl) {
        use_sat_decomp_cse = bl;
    }

    public static boolean getSatDecompCSE() {
        return use_sat_decomp_cse;
    }

    public static void setUseMappers(boolean bl) {
        use_mappers = bl;
    }

    public static boolean getUseMappers() {
        return use_mappers;
    }

    public static void setUseMinionMappers(boolean bl) {
        use_minionmappers = bl;
    }

    public static boolean getUseMinionMappers() {
        return use_minionmappers;
    }

    public static void setUseCSE(boolean bl) {
        use_cse = bl;
    }

    public static boolean getUseCSE() {
        return use_cse;
    }

    public static void setUseACCSE(boolean bl) {
        use_ac_cse = bl;
    }

    public static boolean getUseACCSE() {
        return use_ac_cse;
    }

    public static void setUseActiveACCSE2(boolean bl) {
        use_active_ac_cse2 = bl;
        if (bl) {
            use_ac_cse = true;
        }
    }

    public static boolean getUseActiveACCSE2() {
        return use_active_ac_cse2;
    }

    public static void setUseActiveACCSE(boolean bl) {
        use_active_ac_cse = bl;
        if (bl) {
            use_ac_cse = true;
        }
    }

    public static boolean getUseActiveACCSE() {
        return use_active_ac_cse;
    }

    public static void setUseActiveCSE(boolean bl) {
        use_active_cse = bl;
    }

    public static boolean getUseActiveCSE() {
        return use_active_cse;
    }

    public static void setUseACCSEAlt(boolean bl) {
        use_ac_cse_alt = bl;
    }

    public static boolean getUseACCSEAlt() {
        return use_ac_cse_alt;
    }

    public static int getMode() {
        return mode;
    }

    public static void setMode(int n) {
        mode = n;
    }

    public static boolean getTestSolutions() {
        return test_solutions;
    }

    public static boolean getMakeTables() {
        return make_tables;
    }

    public static boolean getOptWarmStart() {
        return opt_warm_start;
    }

    public static String getOptStrategy() {
        return opt_strategy;
    }

    public static boolean getGraphColSymBreak() {
        return graph_col_sym_break;
    }

    public static void setSaveSymbols() {
        save_symbols = true;
    }

    public static boolean getSaveSymbols() {
        return save_symbols;
    }

    public static void println(Object object) {
        System.out.println(object);
    }

    public static void errorExit(String string) {
        System.err.println("ERROR: " + string);
        CmdFlags.exit();
    }

    public static void errorExit(String string, String string2) {
        System.err.println("ERROR: " + string);
        System.err.println("ERROR: " + string2);
        CmdFlags.exit();
    }

    public static void errorExit(String string, String string2, String string3) {
        System.err.println("ERROR: " + string);
        System.err.println("ERROR: " + string2);
        System.err.println("ERROR: " + string3);
        CmdFlags.exit();
    }

    public static void warning(String string) {
        System.err.println("WARNING: " + string);
    }

    public static void cmdLineExit(String string) {
        System.err.println("ERROR: " + string);
        System.err.println("For command line help, use the -help flag.");
        CmdFlags.exit();
    }

    public static void typeError(String string) {
        System.err.println("ERROR: " + string);
    }

    public static void exit() {
        CmdFlags.rmTempFiles();
        System.exit(1);
    }

    public static String getCtName() {
        return "con" + ++ctnum;
    }

    public static void parseArguments(String[] stringArray) {
        String string;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-O2");
        arrayList.add("-S1");
        arrayList.addAll(Arrays.asList(stringArray));
        for (n = 0; n < arrayList.size(); ++n) {
            string = (String)arrayList.get(n);
            if (!string.equals("-O0") && !string.equals("-O1") && !string.equals("-O2") && !string.equals("-O3")) continue;
            arrayList.remove(n);
            --n;
            if (string.equals("-O0")) {
                CmdFlags.setUseCSE(false);
                CmdFlags.setUseActiveCSE(false);
                CmdFlags.setUseACCSE(false);
                CmdFlags.setSatDecompCSE(false);
                CmdFlags.setUseACCSEAlt(false);
                CmdFlags.setUseDeleteVars(false);
                CmdFlags.setUsePropagate(false);
                CmdFlags.setUsePropagateExtend(false);
                CmdFlags.setUseAggregate(false);
                make_short_tab = 2;
                continue;
            }
            if (string.equals("-O1")) {
                CmdFlags.setUseCSE(true);
                CmdFlags.setUseActiveCSE(true);
                CmdFlags.setUseACCSE(false);
                CmdFlags.setSatDecompCSE(false);
                CmdFlags.setUseACCSEAlt(false);
                CmdFlags.setUseDeleteVars(true);
                CmdFlags.setUsePropagate(false);
                CmdFlags.setUsePropagateExtend(false);
                CmdFlags.setUseAggregate(false);
                make_short_tab = 2;
                continue;
            }
            if (string.equals("-O2")) {
                CmdFlags.setUseCSE(true);
                CmdFlags.setUseActiveCSE(true);
                CmdFlags.setUseACCSE(false);
                CmdFlags.setSatDecompCSE(false);
                CmdFlags.setUseACCSEAlt(false);
                CmdFlags.setUseDeleteVars(true);
                CmdFlags.setUsePropagate(true);
                CmdFlags.setUsePropagateExtend(false);
                CmdFlags.setUseAggregate(true);
                make_short_tab = 2;
                continue;
            }
            if (!string.equals("-O3")) continue;
            CmdFlags.setUseCSE(true);
            CmdFlags.setUseActiveCSE(true);
            CmdFlags.setUseACCSE(true);
            CmdFlags.setSatDecompCSE(true);
            CmdFlags.setUseACCSEAlt(false);
            CmdFlags.setUseDeleteVars(true);
            CmdFlags.setUsePropagate(true);
            CmdFlags.setUsePropagateExtend(false);
            CmdFlags.setUseAggregate(true);
            make_short_tab = 3;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            string = (String)arrayList.get(n);
            if (!string.equals("-S0") && !string.equals("-S1") && !string.equals("-S2")) continue;
            arrayList.remove(n);
            --n;
            if (string.equals("-S0")) {
                CmdFlags.setRemoveRedundantVars(false);
                CmdFlags.setAuxNonFunctional(false);
                CmdFlags.setUseVarSymBreaking(false);
                continue;
            }
            if (string.equals("-S1")) {
                CmdFlags.setRemoveRedundantVars(true);
                CmdFlags.setAuxNonFunctional(true);
                CmdFlags.setUseVarSymBreaking(false);
                continue;
            }
            if (!string.equals("-S2")) continue;
            CmdFlags.setRemoveRedundantVars(true);
            CmdFlags.setAuxNonFunctional(true);
            CmdFlags.setUseVarSymBreaking(true);
        }
        while (arrayList.size() > 0) {
            int n2;
            String string2 = (String)arrayList.get(0);
            arrayList.remove(0);
            if (string2.equals("-help")) {
                HelpText.printHelp();
                System.exit(0);
                continue;
            }
            if (string2.equals("-v")) {
                CmdFlags.setVerbose(true);
                verbose_make_short = true;
                continue;
            }
            if (string2.equals("-nomappers")) {
                CmdFlags.setUseMappers(false);
                continue;
            }
            if (string2.equals("-minionmappers")) {
                CmdFlags.setUseMappers(false);
                CmdFlags.setUseMinionMappers(true);
                continue;
            }
            if (string2.equals("-no-cse")) {
                CmdFlags.setUseCSE(false);
                CmdFlags.setUseActiveCSE(false);
                CmdFlags.setUseACCSE(false);
                CmdFlags.setSatDecompCSE(false);
                CmdFlags.setUseACCSEAlt(false);
                continue;
            }
            if (string2.equals("-identical-cse")) {
                CmdFlags.setUseCSE(true);
                continue;
            }
            if (string2.equals("-active-cse")) {
                CmdFlags.setUseActiveCSE(true);
                continue;
            }
            if (string2.equals("-ac-cse")) {
                CmdFlags.setUseACCSE(true);
                CmdFlags.setSatDecompCSE(true);
                continue;
            }
            if (string2.equals("-active-ac-cse")) {
                CmdFlags.setUseActiveACCSE(true);
                continue;
            }
            if (string2.equals("-active-ac-cse2")) {
                CmdFlags.setUseActiveACCSE2(true);
                continue;
            }
            if (string2.equals("-ac-cse-heuristic")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("AC-CSE heuristic integer missing");
                }
                accse_heuristic = Integer.parseInt((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-ac-cse-alt")) {
                CmdFlags.setUseACCSEAlt(true);
                continue;
            }
            if (string2.equals("-deletevars")) {
                CmdFlags.setUseDeleteVars(true);
                continue;
            }
            if (string2.equals("-aggregate")) {
                CmdFlags.setUseAggregate(true);
                continue;
            }
            if (string2.equals("-varelim")) {
                CmdFlags.setUseEliminateVars(true);
                continue;
            }
            if (string2.equals("-reduce-domains")) {
                CmdFlags.setUsePropagate(true);
                continue;
            }
            if (string2.equals("-reduce-domains-extend")) {
                CmdFlags.setUsePropagate(true);
                CmdFlags.setUsePropagateExtend(true);
                continue;
            }
            if (string2.equals("-reduce-domains-extend2")) {
                CmdFlags.setUsePropagateExtend2(true);
                continue;
            }
            if (string2.equals("-remove-redundant-vars")) {
                CmdFlags.setRemoveRedundantVars(true);
                continue;
            }
            if (string2.equals("-aux-non-functional")) {
                CmdFlags.setAuxNonFunctional(true);
                continue;
            }
            if (string2.equals("-graph-col-sym-break")) {
                graph_col_sym_break = true;
                continue;
            }
            if (string2.equals("-opt-warm-start")) {
                opt_warm_start = true;
                continue;
            }
            if (string2.equals("-opt-strategy")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Optimisation strategy missing after -opt-strategy flag");
                }
                opt_strategy = (String)arrayList.get(0);
                arrayList.remove(0);
                if (opt_strategy.equals("linear") || opt_strategy.equals("unsat") || opt_strategy.equals("bisect")) continue;
                CmdFlags.cmdLineExit("Optimisation strategy must be linear, unsat or bisect.");
                continue;
            }
            if (string2.equals("-make-tables")) {
                make_tables = true;
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("-make-tables expects integer arguments specifying the scope.");
                }
                int n3 = Integer.parseInt((String)arrayList.get(0));
                arrayList.remove(0);
                make_tables_scope = new ArrayList();
                for (n2 = 0; n2 < n3; ++n2) {
                    if (arrayList.size() == 0) {
                        CmdFlags.cmdLineExit("-make-tables expects arguments specifying the scope.");
                    }
                    make_tables_scope.add(Integer.parseInt((String)arrayList.get(0)));
                    arrayList.remove(0);
                }
                continue;
            }
            if (string2.equals("-table-squash")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("-table-squash expects an argument");
                }
                table_squash = Integer.parseInt((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-v-make-short")) {
                verbose_make_short = true;
                continue;
            }
            if (string2.equals("-preprocess")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("-preprocess expects an argument. Options are: None, GAC, SAC, SSAC, SACBounds, SSACBounds");
                }
                CmdFlags.setPreprocess((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-preproc-time-limit")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("-preproc-time-limit expects an integer argument in seconds, or 0 for no limit.");
                }
                if ((preproc_time_limit = Integer.parseInt((String)arrayList.get(0))) < 0) {
                    CmdFlags.cmdLineExit("-preproc-time-limit expects an integer argument in seconds, or 0 for no limit.");
                }
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-timelimit")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("-timelimit expects an argument in milliseconds.");
                }
                CmdFlags.setTimeLimit(Integer.parseInt((String)arrayList.get(0)));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-cnflimit")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("-cnflimit expects an integer argument.");
                }
                CmdFlags.setCNFLimit(Integer.parseInt((String)arrayList.get(0)));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-dryruns")) {
                dryruns = true;
                continue;
            }
            if (string2.equals("-test-solutions")) {
                test_solutions = true;
                continue;
            }
            if (string2.equals("-run-solver")) {
                CmdFlags.setRunSolver();
                continue;
            }
            if (string2.equals("-all-solutions")) {
                CmdFlags.setFindAllSolutions(true);
                continue;
            }
            if (string2.equals("-num-solutions")) {
                long l;
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("-num-solutions expects an argument: the number of solutions required.");
                }
                if ((l = Long.parseLong((String)arrayList.get(0))) <= 0L) {
                    CmdFlags.cmdLineExit("Argument to -num-solutions is less than one.");
                }
                CmdFlags.setFindNumSolutions(l);
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-solutions-to-stdout-one-line")) {
                CmdFlags.setSolutionsToStdoutOneLine(true);
                continue;
            }
            if (string2.equals("-solutions-to-stdout")) {
                CmdFlags.setSolutionsToStdout(true);
                continue;
            }
            if (string2.equals("-solutions-to-null")) {
                CmdFlags.setSolutionsToNull(true);
                continue;
            }
            if (string2.equals("-no-bound-vars")) {
                CmdFlags.setUseBoundVars(false);
                continue;
            }
            if (string2.equals("-var-sym-breaking")) {
                CmdFlags.setUseVarSymBreaking(true);
                continue;
            }
            if (string2.equals("-expand-short-tab")) {
                expand_short_tab = true;
                continue;
            }
            if (string2.equals("-make-short-tab")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Missing short-table mode after -make-short-tab");
                }
                make_short_tab = Integer.valueOf((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-short-tab-sat-extra")) {
                short_tab_sat_extra = true;
                continue;
            }
            if (string2.equals("-tabulate")) {
                make_short_tab = 3;
                continue;
            }
            if (string2.equals("-Wundef")) {
                warn_undef = true;
                continue;
            }
            if (string2.equals("-minion")) {
                if (soltype != SolEnum.DEFAULT) {
                    CmdFlags.cmdLineExit("Two backend solvers specified on command line.");
                }
                soltype = SolEnum.MINION;
                continue;
            }
            if (string2.equals("-gecode")) {
                if (soltype != SolEnum.DEFAULT) {
                    CmdFlags.cmdLineExit("Two backend solvers specified on command line.");
                }
                soltype = SolEnum.GECODE;
                continue;
            }
            if (string2.equals("-chuffed")) {
                if (soltype != SolEnum.DEFAULT) {
                    CmdFlags.cmdLineExit("Two backend solvers specified on command line.");
                }
                soltype = SolEnum.CHUFFED;
                continue;
            }
            if (string2.equals("-minizinc")) {
                if (soltype != SolEnum.DEFAULT) {
                    CmdFlags.cmdLineExit("Two backend solvers specified on command line.");
                }
                soltype = SolEnum.MINIZINC;
                continue;
            }
            if (string2.equals("-mznlns")) {
                CmdFlags.useMznLNS();
                continue;
            }
            if (string2.equals("-dominion")) {
                if (soltype != SolEnum.DEFAULT) {
                    CmdFlags.cmdLineExit("Two backend solvers specified on command line.");
                }
                soltype = SolEnum.DOMINION;
                continue;
            }
            if (string2.equals("-sat")) {
                if (soltype != SolEnum.DEFAULT) {
                    CmdFlags.cmdLineExit("Two backend solvers specified on command line.");
                }
                soltype = SolEnum.SAT;
                continue;
            }
            if (string2.equals("-maxsat")) {
                if (soltype != SolEnum.DEFAULT) {
                    CmdFlags.cmdLineExit("Two backend solvers specified on command line.");
                }
                soltype = SolEnum.MAXSAT;
                continue;
            }
            if (string2.equals("-sns")) {
                if (soltype != SolEnum.DEFAULT) {
                    CmdFlags.cmdLineExit("Two backend solvers specified on command line.");
                }
                soltype = SolEnum.MINIONSNS;
                continue;
            }
            if (string2.equals("-sat-alt")) {
                CmdFlags.setSatAlt();
                continue;
            }
            if (string2.equals("-sat-pb-mdd")) {
                use_sat_pb_mdd = true;
                continue;
            }
            if (string2.equals("-sat-decomp-cse")) {
                CmdFlags.setSatDecompCSE(true);
                continue;
            }
            if (string2.equals("-minion-bin")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Missing Minion executable file name following -minion-bin");
                }
                CmdFlags.setMinion((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-satsolver-bin")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Missing SAT solver executable file name following -satsolver-bin");
                }
                CmdFlags.setSatSolver((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-glucose-bin")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Missing SAT solver executable file name following -glucose-bin");
                }
                glucosepath = (String)arrayList.get(0);
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-sat-family")) {
                String string3;
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Missing SAT family name following -sat-family");
                }
                if (!((string3 = (String)arrayList.get(0)).equals("minisat") || string3.equals("lingeling") || string3.equals("glucose") || string3.equals("nbc_minisat_all") || string3.equals("bc_minisat_all"))) {
                    CmdFlags.cmdLineExit("SAT family " + string3 + " not supported.");
                }
                if (string3.equals("nbc_minisat_all") || string3.equals("bc_minisat_all")) {
                    CmdFlags.setFindAllSolutions(true);
                }
                CmdFlags.setSatFamily((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-solver-options")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Missing solver options string");
                }
                ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(((String)arrayList.get(0)).split(" ")));
                for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                    if (!arrayList2.get(n2).equals("")) continue;
                    arrayList2.remove(n2);
                    --n2;
                }
                CmdFlags.setSolverExtraFlags(arrayList2);
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-gecode-bin")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Missing Gecode executable file name");
                }
                CmdFlags.setGecode((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-chuffed-bin")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Missing Chuffed executable file name");
                }
                CmdFlags.setChuffed((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-symdetect-bin")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Missing symmetry_detect executable file name");
                }
                CmdFlags.setSymDetect((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-in-eprime")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Essence Prime model file name missing after -in-eprime");
                }
                CmdFlags.setEprimeFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-in-param")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Essence Prime parameter file missing after -in-param");
                }
                CmdFlags.setParamFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-params")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Parameter string missing after -params");
                }
                CmdFlags.setParamString((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-out-minion")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Minion output file name missing after -out-minion");
                }
                CmdFlags.setMinionFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-out-sat")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("SAT output file name missing after -out-sat");
                }
                CmdFlags.setSatFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-out-minizinc")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Minizinc output file name missing after -out-minizinc");
                }
                CmdFlags.setMinizincFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-out-solution")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Solution file name missing following -out-solution");
                }
                CmdFlags.setSolutionFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-out-info")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Statistics file name missing following -out-info");
                }
                CmdFlags.setInfoFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-out-aux")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Aux file name missing after -out-aux");
                }
                CmdFlags.setAuxFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-minion-sol-file")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Missing Minion solution file name after -minion-sol-file");
                }
                CmdFlags.setMinionSolutionFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-out-dominion")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Missing Dominion output file name after -out-dominion");
                }
                CmdFlags.setDominionFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-out-gecode")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Missing Gecode output file name after -out-gecode");
                }
                CmdFlags.setFznFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-out-chuffed")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Missing Chuffed output file name after -out-chuffed");
                }
                CmdFlags.setFznFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-seed")) {
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Missing value for seed");
                }
                seed = Integer.parseInt((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string2.equals("-param-to-json")) {
                CmdFlags.setParamToJSON();
                continue;
            }
            if (string2.equals("-save-symbols")) {
                CmdFlags.setSaveSymbols();
                continue;
            }
            if (string2.equals("-mode")) {
                String string4;
                if (arrayList.size() == 0) {
                    CmdFlags.cmdLineExit("Missing mode argument");
                }
                if ((string4 = (String)arrayList.get(0)).equals("Normal")) {
                    CmdFlags.setMode(1);
                } else if (string4.equals("ReadSolution")) {
                    CmdFlags.setMode(2);
                } else if (string4.equals("Multi")) {
                    CmdFlags.setMode(3);
                } else {
                    CmdFlags.cmdLineExit("-mode argument not followed by Normal, ReadSolution or Multi.");
                }
                arrayList.remove(0);
                continue;
            }
            if (string2.length() >= 7 && string2.substring(string2.length() - 7, string2.length()).equals(".eprime") && eprimefile == null) {
                eprimefile = string2;
                continue;
            }
            if (string2.length() >= 6 && string2.substring(string2.length() - 6, string2.length()).equals(".param") && paramfile == null) {
                paramfile = string2;
                continue;
            }
            if (string2.length() >= 13 && string2.substring(string2.length() - 13, string2.length()).equals(".eprime-param") && paramfile == null) {
                paramfile = string2;
                continue;
            }
            CmdFlags.cmdLineExit("Failed to parse the following argument: " + string2);
        }
        if (CmdFlags.getMode() == 1 || CmdFlags.getMode() == 3) {
            if (eprimefile == null) {
                CmdFlags.cmdLineExit("Not given Essence Prime model file.");
            }
            if (soltype == SolEnum.DEFAULT) {
                soltype = SolEnum.MINION;
            }
            if (dominionfile == null) {
                String string5 = eprimefile;
                if (string5.substring(string5.length() - 7, string5.length()).equals(".eprime")) {
                    string5 = string5.substring(0, string5.length() - 7);
                }
                dominionfile = string5 + ".dominion";
            }
            if (minionfile == null) {
                minionfile = paramfile != null ? paramfile + ".minion" : eprimefile + ".minion";
            }
            if (satfile == null) {
                satfile = paramfile != null ? paramfile + ".dimacs" : eprimefile + ".dimacs";
            }
            if (auxfile == null) {
                auxfile = paramfile != null ? paramfile + ".aux" : eprimefile + ".aux";
            }
            if (fznfile == null) {
                fznfile = paramfile != null ? paramfile + ".fzn" : eprimefile + ".fzn";
            }
            if (solutionfile == null) {
                solutionfile = paramfile != null ? paramfile + ".solution" : eprimefile + ".solution";
            }
            if (infofile == null) {
                infofile = paramfile != null ? paramfile + ".info" : eprimefile + ".info";
            }
            if (minizincfile == null) {
                minizincfile = paramfile != null ? paramfile + ".mzn" : eprimefile + ".mzn";
            }
            if (satsolverpath == null) {
                if (CmdFlags.getMaxsattrans()) {
                    satsolverpath = maxsatpath;
                } else if (satfamily.equals("minisat") || satfamily.equals("lingeling")) {
                    satsolverpath = satfamily;
                } else if (satfamily.equals("glucose")) {
                    satsolverpath = glucosepath;
                } else if (satfamily.equals("nbc_minisat_all")) {
                    satsolverpath = "nbc_minisat_all_release";
                } else if (satfamily.equals("bc_minisat_all")) {
                    satsolverpath = "bc_minisat_all_release";
                }
            }
        } else if (CmdFlags.getMode() == 2) {
            if (auxfile == null) {
                CmdFlags.cmdLineExit("When using ReadSolution mode, -out-aux must be used to specify the .aux file.");
            }
            if (solutionfile == null) {
                CmdFlags.cmdLineExit("When using ReadSolution mode, -out-solution must be used to specify the name for the Essence Prime solution file(s).");
            }
            if (minionsolfile == null) {
                CmdFlags.cmdLineExit("When using ReadSolution mode, -minion-sol-file must be used to specify the name of the Minion solution table file.");
            }
        } else assert (false) : "Mode not recognised";
    }

    public static String getPid() {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        return string.split("@")[0];
    }

    static {
        verbose_make_short = false;
        table_squash = 0;
        make_short_tab = 2;
        short_tab_sat_extra = false;
        use_var_symmetry_breaking = false;
        use_eliminate_vars = false;
        graph_col_sym_break = false;
        accse_heuristic = 1;
        dryruns = false;
        use_delete_vars = true;
        use_propagate = true;
        use_propagate_extend = false;
        use_propagate_extend2 = false;
        remove_redundant_vars = false;
        aux_non_functional = false;
        opt_warm_start = false;
        opt_strategy = "bisect";
        find_all_solutions = false;
        find_num_solutions = -1L;
        solutions_to_stdout_one_line = false;
        solutions_to_stdout = false;
        solutions_to_null = false;
        use_boundvars = true;
        use_aggregate = true;
        test_solutions = false;
        param_to_json = false;
        expand_short_tab = false;
        warn_undef = false;
        save_symbols = false;
        output_ready = false;
        after_aggregate = false;
        multistage = false;
        seed = 1234;
        randomGen = null;
        mode = 1;
        version = "1.7.0";
        tempFileSuffix = "_" + System.currentTimeMillis() + "_" + CmdFlags.getPid();
        minionStatsTempFile = ".MINIONSTATS" + tempFileSuffix;
        minionSolsTempFile = ".MINIONSOLS" + tempFileSuffix;
        startTime = System.currentTimeMillis();
        preprocess = null;
        preproc_time_limit = 60;
        eprimefile = null;
        paramfile = null;
        paramstring = null;
        solutionfile = null;
        minionsolfile = null;
        infofile = null;
        minionfile = null;
        dominionfile = null;
        fznfile = null;
        minizincfile = null;
        satfile = null;
        auxfile = null;
        timelimit = 0L;
        cnflimit = 0L;
        runningSolver = false;
        stats = new LinkedHashMap();
        ctnum = 0;
    }
}

