/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.eprimeparser.EPrimeReader;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.NumberConstant;
import savilerow.model.Model;
import savilerow.model.ModelContainer;
import savilerow.solver.MinionSolver;

public final class SRWorkThread
extends Thread {
    @Override
    public void run() {
        Object object;
        if (CmdFlags.getMode() == 2) {
            MinionSolver minionSolver = new MinionSolver();
            minionSolver.parseSolutionMode();
            return;
        }
        EPrimeReader ePrimeReader = new EPrimeReader(CmdFlags.eprimefile, true);
        Model model = ePrimeReader.readModel();
        assert (model.constraints != null);
        ArrayList<ASTNode> arrayList = new ArrayList();
        if (CmdFlags.paramfile != null) {
            object = new EPrimeReader(CmdFlags.paramfile, true);
            arrayList = ((EPrimeReader)object).readParameterFile(model);
        }
        if (CmdFlags.paramstring != null) {
            object = new EPrimeReader(CmdFlags.paramstring, false);
            arrayList = ((EPrimeReader)object).readParameterFile(model);
        }
        object = new ModelContainer(model, new ArrayList<ASTNode>(arrayList));
        if (CmdFlags.getParamToJSON()) {
            this.paramToJSON(arrayList);
            System.exit(0);
        }
        if (CmdFlags.dryruns) {
            ModelContainer modelContainer = ((ModelContainer)object).copy();
            modelContainer.dryrun();
            CmdFlags.startTime = System.currentTimeMillis();
            CmdFlags.currentModel = null;
            modelContainer = ((ModelContainer)object).copy();
            modelContainer.dryrun();
            CmdFlags.startTime = System.currentTimeMillis();
            CmdFlags.currentModel = null;
            modelContainer = ((ModelContainer)object).copy();
            modelContainer.dryrun();
            CmdFlags.startTime = System.currentTimeMillis();
            CmdFlags.currentModel = null;
        }
        CmdFlags.startTime = System.currentTimeMillis();
        ((ModelContainer)object).process();
        System.exit(0);
    }

    public void paramToJSON(ArrayList<ASTNode> arrayList) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(CmdFlags.paramfile + ".json"));
            bufferedWriter.write("{\n");
            for (int i = 0; i < arrayList.size(); ++i) {
                bufferedWriter.write("\"");
                bufferedWriter.write(arrayList.get(i).getChild(0).toString());
                bufferedWriter.write("\" : ");
                ASTNode aSTNode = arrayList.get(i).getChild(1);
                if (aSTNode instanceof BooleanConstant || aSTNode instanceof NumberConstant) {
                    bufferedWriter.write(aSTNode.toString());
                } else if (aSTNode instanceof EmptyMatrix) {
                    bufferedWriter.write("[ ]");
                } else {
                    bufferedWriter.write(((CompoundMatrix)aSTNode).toStringSimpleMatrix());
                }
                if (i < arrayList.size() - 1) {
                    bufferedWriter.write(",");
                }
                bufferedWriter.write("\n");
            }
            bufferedWriter.write("}\n");
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

