/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.Or;
import savilerow.model.Model;
import savilerow.model.categoryentry;
import savilerow.treetransformer.ReplaceASTNode;
import savilerow.treetransformer.TransformSimplify;
import savilerow.treetransformer.TreeTransformerBottomUpNoWrapper;

public class VarElim {
    private HashMap<ASTNode, ArrayList<ASTNode>> exp;
    Model m;
    int increase;
    int scale;
    boolean nooverlap;

    public VarElim(Model model) {
        this.m = model;
        this.increase = 0;
        this.scale = 1;
    }

    public VarElim(Model model, int n) {
        this.m = model;
        this.increase = n;
        this.scale = 1;
        this.nooverlap = false;
    }

    public VarElim(Model model, int n, int n2) {
        this.m = model;
        this.increase = n;
        this.scale = n2;
        this.nooverlap = false;
    }

    public VarElim(Model model, boolean bl) {
        this.m = model;
        this.increase = 1;
        this.scale = 1;
        this.nooverlap = bl;
    }

    public void eliminateVariables() {
        ASTNode aSTNode = this.m.objective;
        if (aSTNode != null) {
            aSTNode = aSTNode.getChild(0);
        }
        assert (aSTNode == null || aSTNode instanceof Identifier);
        boolean bl = true;
        bl = false;
        this.exp = new HashMap();
        this.populate_exp(this.m.constraints, this.exp);
        categoryentry categoryentry2 = this.m.global_symbols.getCategoryFirst();
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3 || categoryentry2.cat == 10) {
                Object object;
                String string = categoryentry2.name;
                Identifier identifier = new Identifier(this.m, string);
                if (aSTNode != null && ((ASTNode)identifier).equals(aSTNode)) continue;
                ArrayList<ASTNode> arrayList = this.exp.get(identifier);
                if (arrayList != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (!arrayList.get(i).isDetached()) continue;
                        arrayList.remove(i);
                        --i;
                    }
                }
                if (arrayList == null || arrayList.size() == 0) {
                    CmdFlags.warning("Variable " + string + " is not in the scope of any constraint.");
                    object = ((ASTNode)identifier).getBounds();
                    assert (((Intpair)object).upper >= ((Intpair)object).lower);
                    if (((ASTNode)identifier).isRelation()) {
                        this.m.global_symbols.assignVariable(identifier, new BooleanConstant(((Intpair)object).lower != 0L));
                    } else {
                        this.m.global_symbols.assignVariable(identifier, NumberConstant.make(((Intpair)object).lower));
                    }
                } else {
                    TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper;
                    Serializable serializable;
                    object = new HashSet();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        serializable = arrayList.get(i);
                        while (!((ASTNode)serializable).getParent().inTopAnd()) {
                            serializable = ((ASTNode)serializable).getParent();
                        }
                        ((HashSet)object).add(serializable);
                    }
                    And and = new And(new ArrayList<ASTNode>((Collection<ASTNode>)object));
                    serializable = this.m.global_symbols.getDomain(string).getValueSet();
                    ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
                    for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                        treeTransformerBottomUpNoWrapper = new ReplaceASTNode(identifier, NumberConstant.make((Long)((ArrayList)serializable).get(i)));
                        arrayList2.add(treeTransformerBottomUpNoWrapper.transform(((ASTNode)and).copy()));
                    }
                    ASTNode aSTNode2 = new Or(arrayList2);
                    treeTransformerBottomUpNoWrapper = new TransformSimplify();
                    aSTNode2 = treeTransformerBottomUpNoWrapper.transform(aSTNode2);
                    aSTNode2.setParent(null);
                    if (this.heuristic(aSTNode2, and)) {
                        System.out.println("Nuking variable :" + string);
                        ASTNode aSTNode3 = null;
                        for (int i = 0; i < arrayList.size(); ++i) {
                            ASTNode aSTNode4 = arrayList.get(i);
                            while (!aSTNode4.getParent().inTopAnd()) {
                                aSTNode4 = aSTNode4.getParent();
                            }
                            BooleanConstant booleanConstant = new BooleanConstant(true);
                            aSTNode4.getParent().setChild(aSTNode4.getChildNo(), booleanConstant);
                            aSTNode3 = booleanConstant;
                        }
                        this.populate_exp(aSTNode2, this.exp);
                        assert (aSTNode2.getParent() == null);
                        aSTNode3.getParent().setChild(aSTNode3.getChildNo(), aSTNode2);
                        Intpair intpair = ((ASTNode)identifier).getBounds();
                        assert (intpair.upper >= intpair.lower);
                        if (((ASTNode)identifier).isRelation()) {
                            this.m.global_symbols.assignVariable(identifier, new BooleanConstant(intpair.lower != 0L));
                        } else {
                            this.m.global_symbols.assignVariable(identifier, NumberConstant.make(intpair.lower));
                        }
                        bl = true;
                    }
                }
            }
            categoryentry2 = categoryentry2.next;
        }
        if (bl) {
            this.m.simplify();
        }
    }

    private boolean heuristic(ASTNode aSTNode, ASTNode aSTNode2) {
        if (!this.nooverlap) {
            return aSTNode.treesize() <= this.scale * aSTNode2.treesize() + this.increase;
        }
        if (!(aSTNode instanceof Or)) {
            return true;
        }
        ArrayList<ASTNode> arrayList = aSTNode.getChildren();
        ArrayList<HashMap<ASTNode, ArrayList<ASTNode>>> arrayList2 = new ArrayList<HashMap<ASTNode, ArrayList<ASTNode>>>();
        for (int i = 0; i < arrayList.size(); ++i) {
            HashMap<ASTNode, ArrayList<ASTNode>> hashMap = new HashMap<ASTNode, ArrayList<ASTNode>>();
            this.populate_exp(arrayList.get(i), hashMap);
            arrayList2.add(hashMap);
        }
        HashSet hashSet = new HashSet(((HashMap)arrayList2.get(0)).keySet());
        boolean bl = false;
        for (int i = 1; i < arrayList.size(); ++i) {
            HashSet hashSet2 = new HashSet(hashSet);
            hashSet2.retainAll(((HashMap)arrayList2.get(i)).keySet());
            if (hashSet2.size() > 0) {
                bl = true;
                break;
            }
            hashSet.addAll(((HashMap)arrayList2.get(i)).keySet());
        }
        return !bl;
    }

    private void populate_exp(ASTNode aSTNode, HashMap<ASTNode, ArrayList<ASTNode>> hashMap) {
        if (aSTNode instanceof Identifier && aSTNode.getCategory() == 3) {
            if (hashMap.containsKey(aSTNode)) {
                hashMap.get(aSTNode).add(aSTNode);
            } else {
                ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
                arrayList.add(aSTNode);
                hashMap.put(aSTNode, arrayList);
            }
        }
        for (int i = 0; i < aSTNode.numChildren(); ++i) {
            this.populate_exp(aSTNode.getChild(i), hashMap);
        }
    }
}

