/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Identifier;
import savilerow.expression.MultiStage;
import savilerow.expression.Negate;
import savilerow.expression.Or;
import savilerow.expression.Top;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class And
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public And(ArrayList<ASTNode> arrayList) {
        super(arrayList);
    }

    public And(ASTNode[] aSTNodeArray) {
        super(aSTNodeArray);
    }

    public And(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new And(this.getChildrenArray());
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).strongProp()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        HashSet<ASTNode> hashSet;
        int n;
        boolean bl = false;
        ArrayList<ASTNode> arrayList = this.getChildren();
        for (n = 0; n < arrayList.size(); ++n) {
            if (!(arrayList.get(n) instanceof And)) continue;
            bl = true;
            ASTNode aSTNode = arrayList.remove(n);
            --n;
            arrayList.addAll(aSTNode.getChildren());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (!arrayList.get(n).isConstant()) continue;
            long l = arrayList.get(n).getValue();
            if (l == 1L) {
                bl = true;
                arrayList.remove(n);
                --n;
                continue;
            }
            if (CmdFlags.multistage) {
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    if (i == n || arrayList.get(i) instanceof MultiStage) continue;
                    arrayList.remove(i);
                    bl = true;
                }
                break;
            }
            return new BooleanConstant(false);
        }
        if ((hashSet = new HashSet<ASTNode>(arrayList)).size() < arrayList.size()) {
            bl = true;
            arrayList.clear();
            arrayList.addAll(hashSet);
        }
        if (arrayList.size() == 0) {
            return new BooleanConstant(true);
        }
        if (arrayList.size() == 1) {
            arrayList.get(0).setParent(null);
            return arrayList.get(0);
        }
        if (bl) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).setParent(null);
            }
            return new And(arrayList);
        }
        return null;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (int i = 0; i < this.numChildren(); ++i) {
            arrayList.add(new Negate(this.getChild(i)));
        }
        return new Or(arrayList);
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (ASTNode aSTNode : this.getChildren()) {
            if (!aSTNode.typecheck(symbolTable)) {
                return false;
            }
            if (aSTNode.isRelation()) continue;
            System.out.println("ERROR: 'And' contains something other than a relation:" + aSTNode);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode normalise() {
        if (this.getParent() instanceof Top) {
            return this;
        }
        this.normaliseInPlace();
        return this;
    }

    @Override
    public ASTNode normaliseAlpha() {
        if (this.getParent() instanceof Top) {
            return null;
        }
        this.normaliseInPlaceAlpha();
        return null;
    }

    @Override
    public boolean isCommAssoc() {
        return true;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        if (this.getParent() instanceof Top) {
            for (int i = 0; i < this.numChildren(); ++i) {
                this.getChild(i).toMinion(bufferedWriter, true);
                bufferedWriter.append("\n");
            }
        } else {
            bufferedWriter.append("watched-and({");
            for (int i = 0; i < this.numChildren(); ++i) {
                this.getChild(i).toMinion(bufferedWriter, true);
                if (i >= this.numChildren() - 1) continue;
                bufferedWriter.append(",");
            }
            bufferedWriter.append("})");
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getParent() instanceof Top) {
            for (int i = 0; i < this.numChildren(); ++i) {
                stringBuilder.append(this.getChild(i).toString());
                if (i >= this.numChildren() - 1) continue;
                stringBuilder.append(",\n");
            }
        } else {
            stringBuilder.append("(");
            for (int i = 0; i < this.numChildren(); ++i) {
                stringBuilder.append(this.getChild(i).toString());
                if (i >= this.numChildren() - 1) continue;
                stringBuilder.append(" /\\ ");
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        if (this.getParent() instanceof Top) {
            for (int i = 0; i < this.numChildren(); ++i) {
                this.getChild(i).toDominion(stringBuilder, true);
                stringBuilder.append("\n");
            }
        } else {
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append("and([");
            for (int i = 0; i < this.numChildren(); ++i) {
                this.getChild(i).toDominion(stringBuilder, true);
                if (i >= this.numChildren() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("])");
        }
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("And([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toDominionParam(stringBuilder);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("])");
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (this.inTopConjunction());
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i) instanceof Identifier) {
                bufferedWriter.append("constraint bool_eq(");
                this.getChild(i).toFlatzinc(bufferedWriter, true);
                bufferedWriter.append(",true);\n");
                continue;
            }
            this.getChild(i).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append("\n");
        }
    }

    @Override
    public boolean inTopConjunction() {
        return this.getParent().inTopConjunction();
    }

    @Override
    public boolean inTopAnd() {
        return this.getParent().inTopAnd();
    }

    @Override
    public void toFlatzincWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        bufferedWriter.append("constraint array_bool_and([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toFlatzinc(bufferedWriter, true);
            if (i >= this.numChildren() - 1) continue;
            bufferedWriter.append(",");
        }
        bufferedWriter.append("],");
        aSTNode.toFlatzinc(bufferedWriter, true);
        bufferedWriter.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        assert (bl);
        if (this.inTopConjunction()) {
            for (int i = 0; i < this.numChildren(); ++i) {
                if (this.getChild(i) instanceof Identifier) {
                    stringBuilder.append("constraint ");
                    this.getChild(i).toMinizinc(stringBuilder, true);
                    stringBuilder.append(" <-> true;\n");
                    continue;
                }
                stringBuilder.append("constraint ");
                this.getChild(i).toMinizinc(stringBuilder, true);
                stringBuilder.append(";\n");
            }
        } else {
            stringBuilder.append("(");
            for (int i = 0; i < this.numChildren(); ++i) {
                this.getChild(i).toMinizinc(stringBuilder, true);
                if (i >= this.numChildren() - 1) continue;
                stringBuilder.append(" /\\ ");
            }
            stringBuilder.append(")");
        }
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        for (int i = 0; i < this.numChildren(); ++i) {
            ASTNode aSTNode = this.getChild(i);
            sat.addComment(String.valueOf(aSTNode).replaceAll("\n", " "));
            if (aSTNode instanceof Negate) {
                sat.addClause(aSTNode.getChild(0).directEncode(sat, 0L));
                continue;
            }
            if (aSTNode instanceof Identifier) {
                sat.addClause(aSTNode.directEncode(sat, 1L));
                continue;
            }
            aSTNode.toSAT(sat);
        }
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        ArrayList<Long> arrayList = new ArrayList<Long>(this.numChildren());
        for (int i = 0; i < this.numChildren(); ++i) {
            arrayList.add(this.getChild(i).directEncode(sat, 0L));
        }
        sat.addClauseReified(arrayList, -l);
    }

    @Override
    public boolean childrenAreSymmetric() {
        return true;
    }
}

