/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.And;
import savilerow.expression.BinOp;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.GlobalCard;
import savilerow.expression.LessEqual;
import savilerow.expression.NumberConstant;
import savilerow.model.SymbolTable;

public class AtLeast
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public AtLeast(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        super(aSTNode, aSTNode2, aSTNode3);
    }

    @Override
    public ASTNode copy() {
        return new AtLeast(this.getChild(0), this.getChild(1), this.getChild(2));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < 3; ++i) {
            if (!this.getChild(i).typecheck(symbolTable)) {
                return false;
            }
            if (this.getChild(i).getDimension() == 1) continue;
            CmdFlags.println("ERROR: Expected one-dimensional matrix for each argument of atleast constraint: " + this);
            return false;
        }
        if (this.getChild(1).getCategory() > 2 || this.getChild(2).getCategory() > 2) {
            CmdFlags.println("ERROR: Atleast functions do not allow decision variables in the second or third arguments: " + this);
            return false;
        }
        if ((this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix) && (this.getChild(2) instanceof CompoundMatrix || this.getChild(2) instanceof EmptyMatrix) && this.getChild(1).numChildren() != this.getChild(2).numChildren()) {
            CmdFlags.println("ERROR: Atleast function expects second and third arguments to be the same length: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        ASTNode aSTNode2 = this.getChildConst(1);
        ASTNode aSTNode3 = this.getChildConst(2);
        if (aSTNode2 instanceof EmptyMatrix) {
            assert (aSTNode3 instanceof EmptyMatrix);
            return new BooleanConstant(true);
        }
        if (aSTNode instanceof CompoundMatrix && aSTNode2 instanceof CompoundMatrix && aSTNode3 instanceof CompoundMatrix) {
            for (int i = 1; i < aSTNode2.numChildren(); ++i) {
                if (!aSTNode2.getChild(i).isConstant()) continue;
                if (aSTNode2.getChild(i).getValue() <= 0L) {
                    ArrayList<ASTNode> arrayList = aSTNode2.getChildren(1);
                    arrayList.remove(i - 1);
                    for (int j = 0; j < arrayList.size(); ++j) {
                        arrayList.get(j).setParent(null);
                    }
                    ArrayList<ASTNode> arrayList2 = aSTNode3.getChildren(1);
                    arrayList2.remove(i - 1);
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        arrayList2.get(j).setParent(null);
                    }
                    this.getChild(0).setParent(null);
                    return new AtLeast(this.getChild(0), CompoundMatrix.make(arrayList), CompoundMatrix.make(arrayList2));
                }
                if (aSTNode2.getChild(i).getValue() <= (long)(aSTNode.numChildren() - 1)) continue;
                return new BooleanConstant(false);
            }
        }
        if (aSTNode instanceof EmptyMatrix && (aSTNode2 instanceof CompoundMatrix || aSTNode2 instanceof EmptyMatrix)) {
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            for (int i = 1; i < aSTNode2.numChildren(); ++i) {
                if (aSTNode2 == this.getChild(1)) {
                    aSTNode2.getChild(i).setParent(null);
                }
                arrayList.add(new LessEqual(aSTNode2.getChild(i), NumberConstant.make(0L)));
            }
            return new And(arrayList);
        }
        if (aSTNode instanceof CompoundMatrix && aSTNode2.getCategory() == 0 && aSTNode3.getCategory() == 0) {
            int n;
            ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
            ArrayList<ASTNode> arrayList3 = aSTNode2.getChildren(1);
            boolean bl = false;
            for (n = arrayList.size() - 1; n >= 0; --n) {
                if (!arrayList.get(n).isConstant()) continue;
                for (int i = 0; i < aSTNode3.numChildren() - 1; ++i) {
                    if (!aSTNode3.getChild(i + 1).equals(arrayList.get(n))) continue;
                    arrayList3.set(i, BinOp.makeBinOp("-", arrayList3.get(i), NumberConstant.make(1L)));
                }
                arrayList.remove(n);
                bl = true;
            }
            if (bl) {
                this.getChild(2).setParent(null);
                if (aSTNode == this.getChild(0)) {
                    for (n = 0; n < arrayList.size(); ++n) {
                        arrayList.get(n).setParent(null);
                    }
                }
                if (aSTNode2 == this.getChild(1)) {
                    for (n = 0; n < arrayList3.size(); ++n) {
                        arrayList3.get(n).setParent(null);
                    }
                }
                return new AtLeast(CompoundMatrix.make(arrayList), CompoundMatrix.make(arrayList3), this.getChild(2));
            }
        }
        return null;
    }

    @Override
    public ASTNode normalise() {
        if (!(this.getChild(0) instanceof CompoundMatrix)) {
            return this;
        }
        ArrayList<ASTNode> arrayList = this.getChild(0).getChildren(1);
        boolean bl = AtLeast.sortByHashcode(arrayList);
        if (bl) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).setParent(null);
            }
            this.getChild(1).setParent(null);
            this.getChild(2).setParent(null);
            return new AtLeast(new CompoundMatrix(arrayList), this.getChild(1), this.getChild(2));
        }
        return this;
    }

    @Override
    public ASTNode normaliseAlpha() {
        if (!(this.getChild(0) instanceof CompoundMatrix)) {
            return null;
        }
        ArrayList<ASTNode> arrayList = this.getChild(0).getChildren(1);
        boolean bl = AtLeast.sortByAlpha(arrayList);
        if (bl) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).setParent(null);
            }
            this.getChild(1).setParent(null);
            this.getChild(2).setParent(null);
            return new AtLeast(new CompoundMatrix(arrayList), this.getChild(1), this.getChild(2));
        }
        return null;
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        return false;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (this.getChild(2).getCategory() == 0);
        assert (bl);
        assert (this.getChild(1) instanceof CompoundMatrix && this.getChild(1).numChildren() == 2);
        assert (this.getChild(2) instanceof CompoundMatrix && this.getChild(2).numChildren() == 2);
        bufferedWriter.append("occurrencegeq(");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(2).getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(1).getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        assert (this.getChild(2).getCategory() == 0);
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("occurrencegeq(flatten(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("), ");
        this.getChild(2).getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("constraint at_least_int(");
        this.getChild(1).getChild(1).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(2).getChild(1).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(");");
    }

    @Override
    public String toString() {
        return "atleast(" + this.getChild(0) + "," + this.getChild(1) + "," + this.getChild(2) + ")";
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("at_least(");
        this.getChild(1).getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(2).getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toJSON(StringBuilder stringBuilder) {
        GlobalCard.toAlternateJSON(this, stringBuilder);
    }

    @Override
    public boolean isChildSymmetric(int n) {
        return n == 0;
    }
}

