/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Identifier;
import savilerow.model.SymbolTable;

public class Concatenate
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Concatenate(ArrayList<ASTNode> arrayList) {
        super(arrayList);
    }

    public Concatenate(ASTNode[] aSTNodeArray) {
        super(aSTNodeArray);
    }

    @Override
    public ASTNode copy() {
        return new Concatenate(this.getChildrenArray());
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!this.getChild(i).typecheck(symbolTable)) {
                return false;
            }
            if (this.getChild(i).getDimension() >= 1) continue;
            System.out.println("ERROR: Expected 1-dimensional or greater matrix inside concatenate: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i) instanceof CompoundMatrix || this.getChild(i) instanceof EmptyMatrix || this.getChild(i) instanceof Identifier && this.getChild(i).getCategory() == 0) continue;
            return null;
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (int i = 0; i < this.numChildren(); ++i) {
            ASTNode aSTNode = this.getChildConst(i);
            if (this.getChild(i) == aSTNode) {
                aSTNode.detachChildren();
            }
            arrayList.addAll(aSTNode.getChildren(1));
        }
        return CompoundMatrix.make(arrayList);
    }

    @Override
    public int getDimension() {
        if (this.numChildren() == 0) {
            return 1;
        }
        return this.getChild(0).getDimension();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("flatten([");
        for (int i = 0; i < this.numChildren(); ++i) {
            stringBuilder.append(this.getChild(i));
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("],1)");
        return stringBuilder.toString();
    }
}

