/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.AllDifferent;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Equals;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class Cumulative
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Cumulative(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, ASTNode aSTNode4) {
        super(aSTNode, aSTNode2, aSTNode3, aSTNode4);
    }

    @Override
    public ASTNode copy() {
        return new Cumulative(this.getChild(0), this.getChild(1), this.getChild(2), this.getChild(3));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < 4; ++i) {
            if (this.getChild(i).typecheck(symbolTable)) continue;
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in first argument of cumulative: " + this);
            return false;
        }
        if (this.getChild(1).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in second argument of cumulative: " + this);
            return false;
        }
        if (this.getChild(2).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in third argument of cumulative: " + this);
            return false;
        }
        if (this.getChild(3).getDimension() != 0) {
            CmdFlags.println("ERROR: Expected scalar in fourth argument of cumulative: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        return null;
    }

    @Override
    public boolean isNegatable() {
        return this.getChild(0) instanceof CompoundMatrix && this.getChild(0).numChildren() == 3;
    }

    @Override
    public ASTNode negation() {
        assert (this.getChild(0) instanceof CompoundMatrix && this.getChild(0).numChildren() == 3);
        return new Equals(this.getChild(0).getChild(1), this.getChild(0).getChild(2));
    }

    @Override
    public ASTNode normalise() {
        if (!(this.getChild(0) instanceof CompoundMatrix)) {
            return this;
        }
        ArrayList<ASTNode> arrayList = this.getChild(0).getChildren(1);
        boolean bl = Cumulative.sortByHashcode(arrayList);
        if (bl) {
            return new AllDifferent(new CompoundMatrix(arrayList));
        }
        return this;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        assert (this.numChildren() == 1);
        ASTNode aSTNode = this.getChild(0);
        if (aSTNode instanceof CompoundMatrix && aSTNode.numChildren() == 3) {
            bufferedWriter.append("diseq(");
            aSTNode.getChild(1).toMinion(bufferedWriter, false);
            bufferedWriter.append(",");
            aSTNode.getChild(2).toMinion(bufferedWriter, false);
            bufferedWriter.append(")");
        } else {
            String string = "gacalldiff";
            if (aSTNode instanceof CompoundMatrix) {
                for (int i = 1; i < aSTNode.numChildren(); ++i) {
                    if (!CmdFlags.getUseBoundVars() || !aSTNode.getChild(i).exceedsBoundThreshold()) continue;
                    string = "alldiff";
                    break;
                }
            }
            bufferedWriter.append(string);
            bufferedWriter.append("(");
            this.getChild(0).toMinion(bufferedWriter, false);
            bufferedWriter.append(")");
        }
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        assert (this.getChild(0) instanceof CompoundMatrix);
        assert (this.getChild(0).numChildren() == 3);
        stringBuilder.append("(");
        this.getChild(0).getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append("!=");
        this.getChild(0).getChild(2).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        if (this.getCategory() <= 2) {
            this.toDominionParam(stringBuilder);
            return;
        }
        assert (this.numChildren() == 1);
        ASTNode aSTNode = this.getChild(0);
        stringBuilder.append(CmdFlags.getCtName() + " ");
        if (aSTNode instanceof CompoundMatrix && aSTNode.numChildren() == 3) {
            stringBuilder.append("noteq(");
            aSTNode.getChild(1).toDominion(stringBuilder, false);
            stringBuilder.append(",");
            aSTNode.getChild(2).toDominion(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            stringBuilder.append("alldiff(flatten(");
            this.getChild(0).toDominion(stringBuilder, false);
            stringBuilder.append("))");
        }
    }

    @Override
    public String toString() {
        if (this.getChild(0) instanceof CompoundMatrix && this.getChild(0).numChildren() == 3) {
            return "(" + this.getChild(0).getChild(1) + " != " + this.getChild(0).getChild(2) + ")";
        }
        return "allDiff(" + this.getChild(0) + ")";
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (this.numChildren() == 1);
        ASTNode aSTNode = this.getChild(0);
        if (aSTNode instanceof CompoundMatrix && aSTNode.numChildren() == 3) {
            bufferedWriter.append("constraint int_ne(");
            aSTNode.getChild(1).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(",");
            aSTNode.getChild(2).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(");");
        } else {
            bufferedWriter.append("constraint all_different_int(");
            this.getChild(0).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(")::domain;");
        }
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        ASTNode aSTNode = this.getChild(0);
        if (aSTNode instanceof CompoundMatrix && aSTNode.numChildren() == 3) {
            stringBuilder.append("(");
            aSTNode.getChild(1).toMinizinc(stringBuilder, false);
            stringBuilder.append("!=");
            aSTNode.getChild(2).toMinizinc(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            stringBuilder.append("all_different(");
            this.getChild(0).toMinizinc(stringBuilder, false);
            stringBuilder.append(")");
        }
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        assert (this.getChild(0).numChildren() == 3);
        ASTNode aSTNode = this.getChild(0).getChild(1);
        ASTNode aSTNode2 = this.getChild(0).getChild(2);
        if (aSTNode.isConstant()) {
            return -aSTNode2.directEncode(sat, aSTNode.getValue());
        }
        if (aSTNode2.isConstant()) {
            return -aSTNode.directEncode(sat, aSTNode2.getValue());
        }
        return null;
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        assert (this.getChild(0).numChildren() == 3);
        ASTNode aSTNode = this.getChild(0);
        for (int i = 1; i < aSTNode.numChildren(); ++i) {
            for (int j = i + 1; j < aSTNode.numChildren(); ++j) {
                sat.directEncoding(this, aSTNode.getChild(i), aSTNode.getChild(j));
            }
        }
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        assert (this.getChild(0).numChildren() == 3);
        new Equals(this.getChild(0).getChild(1), this.getChild(0).getChild(2)).toSATWithAuxVar(sat, -l);
    }

    @Override
    public boolean test(long l, long l2) {
        return l != l2;
    }

    @Override
    public void toJSON(StringBuilder stringBuilder) {
        this.toJSONHeader(stringBuilder, true);
        stringBuilder.append("\"Children\": [");
        if (this.getChild(0) instanceof CompoundMatrix && this.getChild(0).numChildren() == 3) {
            this.getChild(0).getChild(1).toJSON(stringBuilder);
            stringBuilder.append(", ");
            this.getChild(0).getChild(2).toJSON(stringBuilder);
        } else {
            for (int i = 0; i < this.numChildren(); ++i) {
                stringBuilder.append("\n");
                this.getChild(i).toJSON(stringBuilder);
                if (i >= this.numChildren() - 1) continue;
                stringBuilder.append(",");
            }
        }
        stringBuilder.append("]\n}");
    }

    @Override
    public boolean childrenAreSymmetric() {
        return this.getChild(0) instanceof CompoundMatrix && this.getChild(0).numChildren() == 3;
    }

    @Override
    public boolean isChildSymmetric(int n) {
        return !(this.getChild(0) instanceof CompoundMatrix) || this.getChild(0).numChildren() != 3;
    }

    @Override
    public boolean canChildBeConvertedToDifference(int n) {
        return this.isMyOnlyOtherSiblingEqualZero(n);
    }
}

