/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Implies;
import savilerow.expression.Intpair;
import savilerow.expression.MakeTable;
import savilerow.expression.NumberConstant;
import savilerow.expression.Quantifier;
import savilerow.expression.SimpleDomain;
import savilerow.treetransformer.ReplaceASTNode;

public class ForallExpression
extends Quantifier {
    public static final long serialVersionUID = 1L;

    public ForallExpression(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        super(aSTNode, aSTNode2, aSTNode3);
    }

    @Override
    public ASTNode copy() {
        return new ForallExpression(this.getChild(0), this.getChild(1), this.getChild(2));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public String toString() {
        return "(forall " + this.getChild(0) + " : " + this.getChild(1) + " . " + this.getChild(2) + ")";
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(2) instanceof BooleanConstant && this.getChild(2).getValue() == 1L) {
            return new BooleanConstant(true);
        }
        if (this.getChild(1) instanceof SimpleDomain && this.getChild(1).getCategory() == 0 && !CmdFlags.getDominiontrans()) {
            Intpair intpair = this.getChild(1).getBounds();
            if (intpair.lower + 100L >= intpair.upper && !this.checkMakeTable(this)) {
                ArrayList<Long> arrayList = this.getChild(1).getValueSet();
                ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
                for (int i = 0; i < arrayList.size(); ++i) {
                    ASTNode aSTNode = this.getChild(2).copy();
                    ReplaceASTNode replaceASTNode = new ReplaceASTNode(this.getChild(0), NumberConstant.make(arrayList.get(i)));
                    aSTNode = replaceASTNode.transform(aSTNode);
                    arrayList2.add(aSTNode);
                }
                return new And(arrayList2);
            }
        }
        return null;
    }

    boolean checkMakeTable(ASTNode aSTNode) {
        if (aSTNode instanceof MakeTable) {
            return true;
        }
        for (int i = 0; i < aSTNode.numChildren(); ++i) {
            if (!this.checkMakeTable(aSTNode.getChild(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("Min([");
        this.getChild(2).toDominionParam(stringBuilder);
        stringBuilder.append("|");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(" in {");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append("}");
        if (this.getChild(2) instanceof Implies && this.getChild(2).getChild(0).getCategory() <= 2) {
            stringBuilder.append(", ");
            ASTNode aSTNode = this.getChild(2).getChild(0);
            if (aSTNode instanceof And) {
                for (int i = 0; i < aSTNode.numChildren(); ++i) {
                    aSTNode.getChild(i).toDominionParam(stringBuilder);
                    if (i >= aSTNode.numChildren() - 1) continue;
                    stringBuilder.append(", ");
                }
            } else {
                this.getChild(2).getChild(0).toDominionParam(stringBuilder);
            }
        }
        stringBuilder.append("])");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        if (!this.getParent().inTopAnd()) {
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append("and(");
        }
        stringBuilder.append("[");
        boolean bl2 = false;
        if (this.getChild(2) instanceof Implies && this.getChild(2).getChild(0).getCategory() <= 2) {
            this.getChild(2).getChild(1).toDominion(stringBuilder, true);
            bl2 = true;
        } else {
            this.getChild(2).toDominion(stringBuilder, true);
        }
        stringBuilder.append(" | ");
        ArrayList<ASTNode> arrayList = this.getChild(0).getChildren();
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(" in {");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append("}");
        if (bl2) {
            stringBuilder.append(", ");
            ASTNode aSTNode = this.getChild(2).getChild(0);
            if (aSTNode instanceof And) {
                for (int i = 0; i < aSTNode.numChildren(); ++i) {
                    aSTNode.getChild(i).toDominionParam(stringBuilder);
                    if (i >= aSTNode.numChildren() - 1) continue;
                    stringBuilder.append(", ");
                }
            } else {
                this.getChild(2).getChild(0).toDominionParam(stringBuilder);
            }
        }
        stringBuilder.append("]");
        if (!this.getParent().inTopAnd()) {
            stringBuilder.append(")");
        }
    }

    @Override
    public boolean inTopConjunction() {
        return this.getParent().inTopConjunction();
    }
}

