/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import java.util.Collections;
import savilerow.expression.ASTNode;
import savilerow.expression.EmptyRange;
import savilerow.expression.IntegerDomainConcrete;
import savilerow.expression.IntegerDomainConcreteArray;
import savilerow.expression.Intpair;
import savilerow.expression.NegInfinity;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.PosInfinity;
import savilerow.expression.Range;
import savilerow.expression.SimpleDomain;
import savilerow.expression.ToSet;

public class IntegerDomain
extends SimpleDomain {
    public static final long serialVersionUID = 1L;

    public IntegerDomain(ArrayList<ASTNode> arrayList) {
        if (arrayList.size() == 0) {
            arrayList.add(new EmptyRange());
        }
        this.setChildren(arrayList);
    }

    public IntegerDomain(ASTNode[] aSTNodeArray) {
        if (aSTNodeArray.length == 0) {
            aSTNodeArray = new ASTNode[]{new EmptyRange()};
        }
        this.setChildren(aSTNodeArray);
    }

    public IntegerDomain(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new IntegerDomain(this.getChildren());
    }

    @Override
    public ArrayList<Long> getValueSet() {
        assert (this.isFiniteSet());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int i = 0; i < this.numChildren(); ++i) {
            arrayList.addAll(this.getChild(i).getValueSet());
        }
        Collections.sort(arrayList);
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        if (arrayList.size() > 0) {
            arrayList2.add((Long)arrayList.get(0));
        }
        for (int i = 1; i < arrayList.size(); ++i) {
            if (arrayList.get(i - 1) == arrayList.get(i)) continue;
            arrayList2.add((Long)arrayList.get(i));
        }
        return arrayList2;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        intpair.upper = this.getChild((int)(this.numChildren() - 1)).getBounds().upper;
        return intpair;
    }

    @Override
    public PairASTNode getBoundsAST() {
        return new PairASTNode(this.getChild((int)0).getBoundsAST().e1, this.getChild((int)(this.numChildren() - 1)).getBoundsAST().e2);
    }

    @Override
    public ArrayList<Intpair> getIntervalSet() {
        ArrayList<Intpair> arrayList = new ArrayList<Intpair>(this.numChildren());
        for (int i = 0; i < this.numChildren(); ++i) {
            ArrayList<Intpair> arrayList2 = this.getChild(i).getIntervalSet();
            if (arrayList2 == null) {
                return null;
            }
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    @Override
    public ASTNode simplify() {
        if (this.numChildren() == 1 && this.getChild(0).getDimension() > 0) {
            return new ToSet(this.getChild(0));
        }
        if (this.getCategory() == 0) {
            ArrayList<Intpair> arrayList = this.getIntervalSet();
            for (int i = 0; i < arrayList.size() - 1; ++i) {
                Intpair intpair = arrayList.get(i).merge(arrayList.get(i + 1));
                if (intpair == null) continue;
                System.out.println("WARNING: Merging two adjacent ranges in IntegerDomain: should never happen." + this);
                arrayList.set(i, intpair);
                arrayList.remove(i + 1);
                --i;
            }
            if (arrayList.size() == 1 && arrayList.get((int)0).lower >= Integer.MIN_VALUE && arrayList.get((int)0).upper <= Integer.MAX_VALUE) {
                return new IntegerDomainConcrete((int)arrayList.get((int)0).lower, (int)arrayList.get((int)0).upper);
            }
            if (arrayList.size() >= 1 && this.isFiniteSet()) {
                return new IntegerDomainConcreteArray(arrayList);
            }
        }
        return null;
    }

    @Override
    public boolean isFiniteSetUpper() {
        ASTNode aSTNode = this.getChild(this.numChildren() - 1);
        return !(aSTNode instanceof Range) || !(aSTNode.getChild(1) instanceof PosInfinity);
    }

    @Override
    public boolean isFiniteSetLower() {
        ASTNode aSTNode = this.getChild(0);
        return !(aSTNode instanceof Range) || !(aSTNode.getChild(0) instanceof NegInfinity);
    }

    @Override
    public boolean isFiniteSet() {
        return this.isFiniteSetUpper() && this.isFiniteSetLower();
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public String toString() {
        String string = "int(";
        for (int i = 0; i < this.numChildren(); ++i) {
            string = string + this.getChild(i).toString();
            if (i >= this.numChildren() - 1) continue;
            string = string + ",";
        }
        return string + ")";
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toDominionParam(stringBuilder);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
    }

    @Override
    public ASTNode applyShift(int n) {
        for (int i = 0; i < this.numChildren(); ++i) {
            this.setChild(i, this.getChild(i).applyShift(n));
        }
        return this;
    }

    @Override
    public boolean containsValue(long l) {
        NumberConstant numberConstant = NumberConstant.make(l);
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).equals(numberConstant)) {
                return true;
            }
            if (!(this.getChild(i) instanceof Range) || !this.getChild(i).containsValue(l)) continue;
            return true;
        }
        return false;
    }
}

