/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.SimpleDomain;

public class IntegerDomainConcrete
extends SimpleDomain {
    public static final long serialVersionUID = 1L;
    private int lower;
    private int upper;

    public IntegerDomainConcrete(int n, int n2) {
        this.lower = n;
        this.upper = n2;
    }

    @Override
    public ASTNode copy() {
        return new IntegerDomainConcrete(this.lower, this.upper);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof IntegerDomainConcrete)) {
            return false;
        }
        IntegerDomainConcrete integerDomainConcrete = (IntegerDomainConcrete)object;
        return integerDomainConcrete.lower == this.lower && integerDomainConcrete.upper == this.upper;
    }

    @Override
    public int hashCode() {
        if (this.hashCache == Integer.MIN_VALUE) {
            int n;
            this.hashCache = n = 2251 + 5227 * this.lower + 1723 * this.upper;
            return n;
        }
        return this.hashCache;
    }

    @Override
    public ArrayList<Long> getValueSet() {
        ArrayList<Long> arrayList = new ArrayList<Long>(this.upper - this.lower + 1);
        for (int i = this.lower; i <= this.upper; ++i) {
            arrayList.add(Long.valueOf(i));
        }
        return arrayList;
    }

    @Override
    public Intpair getBounds() {
        return new Intpair(this.lower, this.upper);
    }

    @Override
    public PairASTNode getBoundsAST() {
        return new PairASTNode(NumberConstant.make(this.lower), NumberConstant.make(this.upper));
    }

    @Override
    public ArrayList<Intpair> getIntervalSet() {
        ArrayList<Intpair> arrayList = new ArrayList<Intpair>(1);
        arrayList.add(this.getBounds());
        return arrayList;
    }

    @Override
    public boolean isFiniteSetUpper() {
        return true;
    }

    @Override
    public boolean isFiniteSetLower() {
        return true;
    }

    @Override
    public boolean isFiniteSet() {
        return true;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public String toString() {
        if (this.lower == this.upper) {
            return "int(" + this.lower + ")";
        }
        return "int(" + this.lower + ".." + this.upper + ")";
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append(this.lower);
        stringBuilder.append("..");
        stringBuilder.append(this.upper);
    }

    @Override
    public ASTNode applyShift(int n) {
        return new IntegerDomainConcrete(this.lower + n, this.upper + n);
    }

    @Override
    public boolean containsValue(long l) {
        return l >= (long)this.lower && l <= (long)this.upper;
    }
}

