/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Intpair;
import savilerow.expression.Less;
import savilerow.expression.LexLessEqual;
import savilerow.expression.MatrixBinOp;

public class LexLess
extends MatrixBinOp {
    public static final long serialVersionUID = 1L;

    public LexLess(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new LexLess(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp() && this.getChild(1).strongProp();
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        ASTNode aSTNode2 = this.getChildConst(1);
        if ((aSTNode instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix) && (aSTNode2 instanceof CompoundMatrix || aSTNode2 instanceof EmptyMatrix)) {
            Intpair intpair;
            Intpair intpair2;
            ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
            ArrayList<ASTNode> arrayList2 = aSTNode2.getChildren(1);
            if (arrayList.size() < arrayList2.size()) {
                int n;
                while (arrayList2.size() > arrayList.size()) {
                    arrayList2.remove(arrayList2.size() - 1);
                }
                if (aSTNode == this.getChild(0)) {
                    for (n = 0; n < arrayList.size(); ++n) {
                        arrayList.get(n).setParent(null);
                    }
                }
                if (aSTNode2 == this.getChild(1)) {
                    for (n = 0; n < arrayList2.size(); ++n) {
                        arrayList2.get(n).setParent(null);
                    }
                }
                return new LexLessEqual(CompoundMatrix.make(arrayList), CompoundMatrix.make(arrayList2));
            }
            if (arrayList.size() > arrayList2.size()) {
                int n;
                while (arrayList.size() > arrayList2.size()) {
                    arrayList.remove(arrayList.size() - 1);
                }
                if (aSTNode == this.getChild(0)) {
                    for (n = 0; n < arrayList.size(); ++n) {
                        arrayList.get(n).setParent(null);
                    }
                }
                if (aSTNode2 == this.getChild(1)) {
                    for (n = 0; n < arrayList2.size(); ++n) {
                        arrayList2.get(n).setParent(null);
                    }
                }
                return new LexLess(CompoundMatrix.make(arrayList), CompoundMatrix.make(arrayList2));
            }
            boolean bl = false;
            int n = 0;
            while (n < arrayList.size()) {
                if (arrayList.get(n).equals(arrayList2.get(n))) {
                    arrayList.remove(n);
                    arrayList2.remove(n);
                    bl = true;
                    continue;
                }
                ++n;
            }
            while (arrayList.size() >= 1) {
                intpair2 = arrayList.get(arrayList.size() - 1).getBounds();
                intpair = arrayList2.get(arrayList2.size() - 1).getBounds();
                if (intpair2.lower < intpair.upper) break;
                arrayList.remove(arrayList.size() - 1);
                arrayList2.remove(arrayList2.size() - 1);
                bl = true;
            }
            if (arrayList.size() == 0 && arrayList2.size() == 0) {
                return new BooleanConstant(false);
            }
            intpair2 = arrayList.get(0).getBounds();
            intpair = arrayList2.get(0).getBounds();
            if (intpair2.upper < intpair.lower) {
                return new BooleanConstant(true);
            }
            if (intpair2.lower > intpair.upper) {
                return new BooleanConstant(false);
            }
            if (arrayList.size() == 1) {
                return new Less(arrayList.get(0), arrayList2.get(0));
            }
            if (bl) {
                int n2;
                if (aSTNode == this.getChild(0)) {
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        arrayList.get(n2).setParent(null);
                    }
                }
                if (aSTNode2 == this.getChild(1)) {
                    for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                        arrayList2.get(n2).setParent(null);
                    }
                }
                return new LexLess(CompoundMatrix.make(arrayList), CompoundMatrix.make(arrayList2));
            }
        }
        return null;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        bufferedWriter.append("lexless(");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("lexless(flatten(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("),flatten(");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append("))");
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + " <lex " + this.getChild(1) + ")";
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (CmdFlags.getGecodetrans()) {
            bufferedWriter.append("constraint array_int_lt(");
        } else {
            bufferedWriter.append("constraint lex_less_int(");
        }
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(1).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("lex_less(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }
}

