/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.Intpair;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class Minimising
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Minimising(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        assert (this.numChildren() == 1);
        return new Minimising(this.getChild(0));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() > 0) {
            CmdFlags.println("ERROR: Expected numerical expression in minimising, found a matrix: " + this);
            return false;
        }
        return true;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("MINIMISING ");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append("\n");
    }

    @Override
    public String toString() {
        return "minimising " + this.getChild(0) + "\n";
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("minimising ");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("\n");
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (!this.getChild(0).isConstant()) {
            bufferedWriter.append("minimize ");
            this.getChild(0).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(";\n");
        } else {
            bufferedWriter.append("satisfy;\n");
        }
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("minimize ");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(";\n");
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
        for (int i = 0; i < arrayList.size(); ++i) {
            for (long j = arrayList.get((int)i).lower; j <= arrayList.get((int)i).upper; ++j) {
                if (i >= arrayList.size() - 1 && j >= arrayList.get((int)i).upper) continue;
                sat.addSoftClause(this.getChild(0).orderEncode(sat, j));
            }
        }
    }
}

