/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.math.BigInteger;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.BinOp;
import savilerow.expression.Intpair;
import savilerow.expression.MatrixDomain;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.Power;
import savilerow.expression.Quantifier;
import savilerow.expression.SimpleDomain;
import savilerow.expression.Times;

public class QuantifiedSum
extends Quantifier {
    public static final long serialVersionUID = 1L;

    public QuantifiedSum(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        super(aSTNode, aSTNode2, aSTNode3);
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public ASTNode copy() {
        return new QuantifiedSum(this.getChild(0), this.getChild(1), this.getChild(2));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(2).getBounds();
        if (this.getChild(1) instanceof SimpleDomain) {
            Intpair intpair2 = this.getChild(1).getBounds();
            BigInteger bigInteger = BigInteger.valueOf(intpair2.upper).subtract(BigInteger.valueOf(intpair2.lower)).add(BigInteger.valueOf(1L));
            BigInteger bigInteger2 = BigInteger.valueOf(intpair.lower).multiply(bigInteger);
            BigInteger bigInteger3 = BigInteger.valueOf(intpair.upper).multiply(bigInteger);
            return new Intpair(Intpair.BigIntegerToLong(bigInteger2), Intpair.BigIntegerToLong(bigInteger3));
        }
        assert (this.getChild(1) instanceof MatrixDomain);
        Intpair intpair3 = this.getChild(1).getChild(0).getBounds();
        BigInteger bigInteger = BigInteger.valueOf(intpair3.upper).subtract(BigInteger.valueOf(intpair3.lower)).add(BigInteger.valueOf(1L));
        if (bigInteger.compareTo(BigInteger.valueOf(1L)) == 0) {
            return intpair;
        }
        BigInteger bigInteger4 = BigInteger.valueOf(1L);
        for (int i = 3; i < this.getChild(1).numChildren(); ++i) {
            Intpair intpair4 = this.getChild(1).getChild(i).getBounds();
            BigInteger bigInteger5 = BigInteger.valueOf(intpair4.upper).subtract(BigInteger.valueOf(intpair4.lower)).add(BigInteger.valueOf(1L));
            bigInteger4 = bigInteger4.multiply(bigInteger5);
        }
        if (bigInteger4.compareTo(BigInteger.valueOf(63L)) > 0) {
            return new Intpair(Long.MIN_VALUE, Long.MAX_VALUE);
        }
        BigInteger bigInteger6 = bigInteger.pow(bigInteger4.intValue());
        intpair.lower = Intpair.BigIntegerToLong(BigInteger.valueOf(intpair.lower).multiply(bigInteger6));
        intpair.upper = Intpair.BigIntegerToLong(BigInteger.valueOf(intpair.upper).multiply(bigInteger6));
        return intpair;
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(2).getBoundsAST();
        if (this.getChild(1) instanceof SimpleDomain) {
            PairASTNode pairASTNode2 = this.getChild(1).getBoundsAST();
            ASTNode aSTNode = BinOp.makeBinOp("+", BinOp.makeBinOp("-", pairASTNode2.e2, pairASTNode2.e1), NumberConstant.make(1L));
            pairASTNode.e1 = new Times(pairASTNode.e1, aSTNode);
            pairASTNode.e2 = new Times(pairASTNode.e2, aSTNode);
            return pairASTNode;
        }
        assert (this.getChild(1) instanceof MatrixDomain);
        PairASTNode pairASTNode3 = this.getChild(1).getChild(0).getBoundsAST();
        ASTNode aSTNode = BinOp.makeBinOp("+", BinOp.makeBinOp("-", pairASTNode3.e2, pairASTNode3.e1), NumberConstant.make(1L));
        ASTNode aSTNode2 = NumberConstant.make(1L);
        for (int i = 3; i < this.getChild(1).numChildren(); ++i) {
            PairASTNode pairASTNode4 = this.getChild(1).getChild(i).getBoundsAST();
            ASTNode aSTNode3 = BinOp.makeBinOp("+", BinOp.makeBinOp("-", pairASTNode4.e2, pairASTNode4.e1), NumberConstant.make(1L));
            aSTNode2 = new Times(aSTNode2, aSTNode3);
        }
        Power power = new Power(aSTNode, aSTNode2);
        pairASTNode.e1 = new Times(pairASTNode.e1, power);
        pairASTNode.e2 = new Times(pairASTNode.e2, power);
        return pairASTNode;
    }

    @Override
    public ASTNode simplify() {
        if (!this.getChild(2).contains(this.getChild(0)) && this.getChild(1).getCategory() == 0 && this.getChild(1) instanceof SimpleDomain) {
            long l = Intpair.numValues(this.getChild(1).getIntervalSet());
            this.getChild(2).setParent(null);
            return new Times(this.getChild(2), NumberConstant.make(l));
        }
        return null;
    }

    @Override
    public String toString() {
        return "(sum " + this.getChild(0) + " : " + this.getChild(1) + " . " + this.getChild(2) + ")";
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("Sum([");
        this.getChild(2).toDominionParam(stringBuilder);
        stringBuilder.append(" | ");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(" in {");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append("}");
        stringBuilder.append("])");
    }

    @Override
    public void toDominionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("sum([");
        this.getChild(2).toDominion(stringBuilder, false);
        stringBuilder.append(" | ");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(" in {");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append("}");
        stringBuilder.append("], ");
        aSTNode.toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }
}

