/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.EmptyRange;
import savilerow.expression.Intpair;
import savilerow.expression.NegInfinity;
import savilerow.expression.PairASTNode;
import savilerow.expression.PosInfinity;

public class Range
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Range(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode == null ? new NegInfinity() : aSTNode, aSTNode2 == null ? new PosInfinity() : aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Range(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Range)) {
            return false;
        }
        return this.getChild(0).equals(((ASTNode)object).getChild(0)) && this.getChild(1).equals(((ASTNode)object).getChild(1));
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant() && this.getChild(0).getValue() > this.getChild(1).getValue()) {
            CmdFlags.warning("interval " + this + " is out of order. Rewriting to empty interval.");
            return new EmptyRange();
        }
        if (this.getChild(0).equals(this.getChild(1))) {
            this.getChild(0).setParent(null);
            return this.getChild(0);
        }
        return null;
    }

    @Override
    public Intpair getBounds() {
        return new Intpair(this.getChild((int)0).getBounds().lower, this.getChild((int)1).getBounds().upper);
    }

    @Override
    public PairASTNode getBoundsAST() {
        return new PairASTNode(this.getChild((int)0).getBoundsAST().e1, this.getChild((int)1).getBoundsAST().e2);
    }

    @Override
    public ArrayList<Long> getValueSet() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l = this.getChild(0).getValue();
        long l2 = this.getChild(1).getValue();
        for (long i = l; i <= l2; ++i) {
            arrayList.add(i);
        }
        return arrayList;
    }

    @Override
    public String toString() {
        String string = "";
        if (!(this.getChild(0) instanceof NegInfinity)) {
            string = string + this.getChild(0).toString();
        }
        string = string + "..";
        if (!(this.getChild(1) instanceof PosInfinity)) {
            string = string + this.getChild(1).toString();
        }
        return string;
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        if (!(this.getChild(0) instanceof NegInfinity)) {
            this.getChild(0).toDominionParam(stringBuilder);
        }
        stringBuilder.append("..");
        if (!(this.getChild(1) instanceof PosInfinity)) {
            this.getChild(1).toDominionParam(stringBuilder);
        }
    }

    @Override
    public ASTNode applyShift(int n) {
        for (int i = 0; i < this.numChildren(); ++i) {
            this.setChild(i, this.getChild(i).applyShift(n));
        }
        return this;
    }

    @Override
    public boolean containsValue(long l) {
        return l >= this.getChild(0).getValue() && l <= this.getChild(1).getValue();
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public ArrayList<Intpair> getIntervalSet() {
        if (!this.getChild(0).isConstant() || !this.getChild(1).isConstant()) {
            return null;
        }
        ArrayList<Intpair> arrayList = new ArrayList<Intpair>(1);
        arrayList.add(new Intpair(this.getChild(0).getValue(), this.getChild(1).getValue()));
        return arrayList;
    }
}

