/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Intpair;
import savilerow.expression.Max;
import savilerow.expression.Min;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.Unpack;
import savilerow.model.SymbolTable;

public class SafeMatrixDeref
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public SafeMatrixDeref(ASTNode aSTNode, ArrayList<ASTNode> arrayList) {
        super(aSTNode, arrayList.toArray(new ASTNode[arrayList.size()]));
    }

    @Override
    public ASTNode copy() {
        return new SafeMatrixDeref(this.getChild(0), this.getChildren(1));
    }

    @Override
    public boolean isRelation() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean strongProp() {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).strongProp()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNumerical() {
        return !this.getChild(0).isRelation() && !this.getChild(0).isSet();
    }

    @Override
    public boolean isSet() {
        return this.getChild(0).isSet();
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        if (intpair.lower > 0L) {
            intpair.lower = 0L;
        }
        if (intpair.upper < 0L) {
            intpair.upper = 0L;
        }
        return intpair;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = new ArrayList<Intpair>(1);
        arrayList.add(new Intpair(0L, 0L));
        return Intpair.union(this.getChild(0).getIntervalSetExp(), arrayList);
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(0).getBoundsAST();
        pairASTNode.e1 = new Min(pairASTNode.e1, NumberConstant.make(0L));
        pairASTNode.e2 = new Max(pairASTNode.e2, NumberConstant.make(0L));
        return pairASTNode;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode;
        if (this.numChildren() == 2 && this.getChild(1) instanceof Unpack) {
            ArrayList<ASTNode> arrayList = ((Unpack)this.getChild(1)).items();
            if (arrayList != null) {
                this.getChild(0).setParent(null);
                for (int i = 0; i < arrayList.size(); ++i) {
                    arrayList.get(i).setParent(null);
                }
                return new SafeMatrixDeref(this.getChild(0), arrayList);
            }
            return null;
        }
        boolean bl = false;
        for (int i = 1; i < this.numChildren(); ++i) {
            if (this.getChild(i).getCategory() == 0) continue;
            bl = true;
            break;
        }
        if (!bl && ((aSTNode = this.getChildConst(0)) instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix)) {
            ASTNode aSTNode2 = SafeMatrixDeref.derefCompoundMatrix(aSTNode, this.getChildren(1));
            return aSTNode2 == null ? null : aSTNode2;
        }
        return null;
    }

    public static ASTNode derefCompoundMatrix(ASTNode aSTNode, ArrayList<ASTNode> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            if (!(aSTNode instanceof CompoundMatrix) && !(aSTNode instanceof EmptyMatrix)) {
                return null;
            }
            if (aSTNode instanceof EmptyMatrix) {
                return NumberConstant.make(0L);
            }
            ASTNode aSTNode2 = aSTNode.getChild(0);
            long l = arrayList.get(i).getValue();
            ArrayList<Intpair> arrayList2 = aSTNode2.getIntervalSet();
            int n2 = -1;
            int n3 = 0;
            for (n = 0; n < arrayList2.size(); ++n) {
                Intpair intpair = arrayList2.get(n);
                if (l >= intpair.lower && l <= intpair.upper) {
                    n2 = (int)(l - intpair.lower + (long)n3);
                    break;
                }
                n3 = (int)((long)n3 + (intpair.upper - intpair.lower + 1L));
            }
            if (n2 == -1) {
                return NumberConstant.make(0L);
            }
            n = n2 + 1;
            aSTNode = aSTNode.getChildConst(n);
        }
        return aSTNode;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        int n;
        for (n = 0; n < this.numChildren(); ++n) {
            if (this.getChild(n).typecheck(symbolTable)) continue;
            return false;
        }
        if (this.getChild(0).getDimension() != this.numChildren() - 1) {
            System.out.println("ERROR: Dimension mismatch in matrix deref: " + this);
            return false;
        }
        for (n = 1; n < this.numChildren(); ++n) {
            if (this.getChild(n).isNumerical() || this.getChild(n).isRelation()) continue;
            System.out.println("ERROR: In matrix deref " + this + ", index " + this.getChild(n) + " is not numerical or relational.");
            return false;
        }
        return true;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (bl) {
            if (CmdFlags.getUseBoundVars() && this.exceedsBoundThreshold()) {
                bufferedWriter.append("eq(");
            } else {
                bufferedWriter.append("w-literal(");
            }
        }
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toMinion(bufferedWriter, false);
            if (i >= this.numChildren() - 1) continue;
            bufferedWriter.append(",");
        }
        bufferedWriter.append("]");
        if (bl) {
            bufferedWriter.append(",1)");
        }
    }

    @Override
    public String toString() {
        String string = this.getChild(0).toString() + "[";
        for (int i = 1; i < this.numChildren(); ++i) {
            string = string + this.getChild(i);
            if (i >= this.numChildren() - 1) continue;
            string = string + ", ";
        }
        return string + "]";
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append("literal(");
        }
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toDominion(stringBuilder, false);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        if (bl) {
            stringBuilder.append(", 1)");
        }
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toDominionParam(stringBuilder);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        this.getChild(0).toMinizinc(stringBuilder, bl);
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toMinizinc(stringBuilder, false);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
    }
}

