/*
 * Decompiled with CFR 0.152.
 */
package savilerow.solver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.expression.ASTNode;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.Minimising;
import savilerow.expression.Negate;
import savilerow.expression.Solution;
import savilerow.model.Model;
import savilerow.model.NumberMap;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;
import savilerow.solver.Solver;
import savilerow.solver.Stats;

public abstract class SATSolver
extends Solver {
    static int solutionNumber = 1;
    private ArrayList<String> stdout_lines = new ArrayList();
    Model m;

    public SATSolver(Model model) {
        this.m = model;
    }

    @Override
    public void findSolutions(String string, String string2, Model model) throws IOException, InterruptedException {
        if (model.objective != null) {
            this.findObjective(string, string2, model);
        } else if (CmdFlags.getFindAllSolutions() || CmdFlags.getFindNumSolutions() > -1L) {
            this.findMultipleSolutions(string, string2, model);
        } else {
            this.findOneSolution(string, string2, model);
        }
    }

    public abstract Pair<ArrayList<String>, Stats> runSatSolver(String var1, String var2, Model var3, Stats var4) throws IOException, InterruptedException;

    public void findMultipleSolutions(String string, String string2, Model model) {
        double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
        int n = 6;
        try {
            Stats stats = null;
            while (CmdFlags.getFindAllSolutions() || this.solutionCounter < CmdFlags.getFindNumSolutions()) {
                Pair<ArrayList<String>, Stats> pair = this.runSatSolver(string, string2, model, stats);
                ArrayList<String> arrayList = pair.getFirst();
                Stats stats2 = pair.getSecond();
                stats = stats == null ? stats2 : stats.add(stats2);
                if (arrayList == null) break;
                Solution solution = this.solverSolToAST(arrayList, model.global_symbols);
                this.createSolutionFile(solution, true);
                ArrayList<Long> arrayList2 = new ArrayList<Long>();
                HashMap<String, Long> hashMap = this.readAllAssignments(arrayList, model.global_symbols);
                for (int i = 1; i < model.branchingon.numChildren(); ++i) {
                    ASTNode aSTNode = model.branchingon.getChild(i);
                    if (aSTNode instanceof Negate) {
                        aSTNode = aSTNode.getChild(0);
                    }
                    if (aSTNode instanceof Identifier) {
                        String string3 = aSTNode.toString();
                        Long l = hashMap.get(string3);
                        if (l == null) continue;
                        Identifier identifier = new Identifier(model, string3);
                        long l2 = -((ASTNode)identifier).directEncode(model.satModel, l);
                        if (l2 == 1L) {
                            arrayList2.add(((ASTNode)identifier).orderEncode(model.satModel, l - 1L));
                            arrayList2.add(-((ASTNode)identifier).orderEncode(model.satModel, l));
                            continue;
                        }
                        arrayList2.add(l2);
                        continue;
                    }
                    if (aSTNode.isConstant()) continue;
                    CmdFlags.errorExit("When using SAT and finding multiple solutions, only variables or negated variables are allowed in the branching on list: " + aSTNode.toString());
                }
                model.satModel.addClauseAfterFinalise(arrayList2);
            }
            stats.putValue("SavileRowTotalTime", String.valueOf(d));
            this.writeToFileSolutionStats(stats);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void findObjective(String string, String string2, Model model) {
        if (CmdFlags.getMaxsattrans()) {
            this.findOneSolution(string, string2, model);
        } else if (CmdFlags.getOptStrategy().equals("linear")) {
            this.findObjectiveLinear(string, string2, model);
        } else if (CmdFlags.getOptStrategy().equals("unsat")) {
            this.findObjectiveUnsatMethod(string, string2, model);
        } else {
            assert (CmdFlags.getOptStrategy().equals("bisect"));
            this.findObjectiveBisect(string, string2, model);
        }
    }

    public void findObjectiveLinear(String string, String string2, Model model) {
        double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
        Identifier identifier = (Identifier)model.objective.getChild(0);
        ArrayList<Intpair> arrayList = model.global_symbols.getDomain(identifier.getName()).getIntervalSet();
        ArrayList<String> arrayList2 = null;
        int n = 0;
        Stats stats = null;
        try {
            Object object;
            while (true) {
                if (((Pair)(object = this.runSatSolver(string, string2, model, stats))).getFirst() != null) {
                    arrayList2 = ((Pair)object).getFirst();
                }
                Stats stats2 = ((Pair)object).getSecond();
                stats = stats == null ? stats2 : stats.add(stats2);
                if (((Pair)object).getFirst() == null) break;
                HashMap<String, Long> hashMap = this.readAllAssignments(arrayList2, model.global_symbols);
                Long l = hashMap.get(model.objective.getChild(0).toString());
                System.out.println("While optimising, found value: " + l);
                if (model.objective instanceof Minimising) {
                    model.satModel.addClauseAfterFinalise(model.satModel.getOrderVariable(identifier.getName(), l - 1L));
                } else {
                    model.satModel.addClauseAfterFinalise(-model.satModel.getOrderVariable(identifier.getName(), l));
                }
                ++n;
            }
            if (n > 0) {
                object = this.solverSolToAST(arrayList2, model.global_symbols);
                this.createSolutionFile((ASTNode)object, false);
            } else if (model.incumbentSolution != null) {
                this.createSolutionFile(model.incumbentSolution, false);
            }
            stats.putValue("SavileRowTotalTime", String.valueOf(d));
            this.writeToFileSolutionStats(stats);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void findObjectiveUnsatMethod(String string, String string2, Model model) {
        double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
        Identifier identifier = (Identifier)model.objective.getChild(0);
        ArrayList<Intpair> arrayList = model.global_symbols.getDomain(identifier.getName()).getIntervalSet();
        ArrayList<String> arrayList2 = null;
        boolean bl = false;
        Stats stats = null;
        try {
            long l;
            int n;
            if (model.objective instanceof Minimising) {
                for (n = 0; n < arrayList.size(); ++n) {
                    for (l = arrayList.get((int)n).lower; l <= arrayList.get((int)n).upper; ++l) {
                        Pair<Stats, ArrayList<String>> pair = this.optTestValue(string, string2, identifier, l, stats);
                        stats = pair.getFirst();
                        arrayList2 = pair.getSecond();
                        if (arrayList2 != null) break;
                    }
                    if (arrayList2 == null) {
                        continue;
                    }
                    break;
                }
            } else {
                for (n = arrayList.size() - 1; n >= 0; --n) {
                    for (l = arrayList.get((int)n).upper; l >= arrayList.get((int)n).lower; --l) {
                        Pair<Stats, ArrayList<String>> pair = this.optTestValue(string, string2, identifier, l, stats);
                        stats = pair.getFirst();
                        arrayList2 = pair.getSecond();
                        if (arrayList2 != null) break;
                    }
                    if (arrayList2 == null) {
                        continue;
                    }
                    break;
                }
            }
            if (arrayList2 != null) {
                HashMap<String, Long> hashMap = this.readAllAssignments(arrayList2, model.global_symbols);
                Long l2 = hashMap.get(model.objective.getChild(0).toString());
                System.out.println("While optimising, found value: " + l2);
                Solution solution = this.solverSolToAST(arrayList2, model.global_symbols);
                this.createSolutionFile(solution, false);
            } else if (model.incumbentSolution != null) {
                this.createSolutionFile(model.incumbentSolution, false);
            }
            stats.putValue("SavileRowTotalTime", String.valueOf(d));
            this.writeToFileSolutionStats(stats);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Pair<Stats, ArrayList<String>> optTestValue(String string, String string2, ASTNode aSTNode, long l, Stats stats) throws IOException, InterruptedException {
        System.out.println("Testing value: " + l);
        this.m.satModel.addClauseAfterFinalise(aSTNode.orderEncode(this.m.satModel, l));
        this.m.satModel.addClauseAfterFinalise(-aSTNode.orderEncode(this.m.satModel, l - 1L));
        Pair<ArrayList<String>, Stats> pair = this.runSatSolver(string, string2, this.m, stats);
        this.m.satModel.removeFinalClause();
        this.m.satModel.removeFinalClause();
        ArrayList<String> arrayList = null;
        if (pair.getFirst() != null) {
            arrayList = pair.getFirst();
        }
        Stats stats2 = pair.getSecond();
        stats = stats == null ? stats2 : stats.add(stats2);
        return new Pair<Stats, ArrayList<String>>(stats, arrayList);
    }

    public void findObjectiveBisect(String string, String string2, Model model) {
        double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
        Identifier identifier = (Identifier)model.objective.getChild(0);
        ArrayList<Intpair> arrayList = model.global_symbols.getDomain(identifier.getName()).getIntervalSet();
        ArrayList<String> arrayList2 = null;
        int n = 0;
        Stats stats = null;
        try {
            long l = arrayList.get((int)0).lower;
            long l2 = arrayList.get((int)(arrayList.size() - 1)).upper;
            System.out.println("In dichotomic search, lower: " + l + " upper: " + l2);
            Pair<ArrayList<String>, Stats> pair = this.runSatSolver(string, string2, model, stats);
            if (pair.getFirst() != null) {
                arrayList2 = pair.getFirst();
            }
            stats = pair.getSecond();
            if (pair.getFirst() == null) {
                if (model.incumbentSolution != null) {
                    this.createSolutionFile(model.incumbentSolution, false);
                }
                stats.putValue("SavileRowTotalTime", String.valueOf(d));
                this.writeToFileSolutionStats(stats);
                return;
            }
            HashMap<String, Long> hashMap = this.readAllAssignments(arrayList2, model.global_symbols);
            Serializable serializable = hashMap.get(model.objective.getChild(0).toString());
            System.out.println("While optimising, found value: " + serializable);
            ++n;
            if (model.objective instanceof Minimising) {
                l2 = serializable - 1L;
            } else {
                l = serializable + 1L;
            }
            boolean bl = false;
            while (!bl) {
                long l3 = (l2 - l + 1L) / 2L + l;
                System.out.println("In dichotomic search, lower: " + l + " upper: " + l2 + " midpoint: " + l3);
                if (model.objective instanceof Minimising) {
                    model.satModel.addClauseAfterFinalise(model.satModel.getOrderVariable(identifier.getName(), l3));
                } else {
                    model.satModel.addClauseAfterFinalise(-model.satModel.getOrderVariable(identifier.getName(), l3 - 1L));
                }
                pair = this.runSatSolver(string, string2, model, stats);
                if (pair.getFirst() != null) {
                    arrayList2 = pair.getFirst();
                }
                Stats stats2 = pair.getSecond();
                stats = stats.add(stats2);
                if (pair.getFirst() == null) {
                    if (model.objective instanceof Minimising) {
                        l = l3 + 1L;
                    } else {
                        l2 = l3 - 1L;
                    }
                } else {
                    HashMap<String, Long> hashMap2 = this.readAllAssignments(arrayList2, model.global_symbols);
                    Long l4 = hashMap2.get(model.objective.getChild(0).toString());
                    System.out.println("While optimising, found value: " + l4);
                    ++n;
                    if (model.objective instanceof Minimising) {
                        l2 = l4 - 1L;
                    } else {
                        l = l4 + 1L;
                    }
                }
                model.satModel.removeFinalClause();
                model.satModel.addClauseAfterFinalise(model.satModel.getOrderVariable(identifier.getName(), l2));
                model.satModel.addClauseAfterFinalise(-model.satModel.getOrderVariable(identifier.getName(), l - 1L));
                if (l <= l2) continue;
                break;
            }
            if (n > 0) {
                serializable = this.solverSolToAST(arrayList2, model.global_symbols);
                this.createSolutionFile((ASTNode)serializable, false);
            } else if (model.incumbentSolution != null) {
                this.createSolutionFile(model.incumbentSolution, false);
            }
            stats.putValue("SavileRowTotalTime", String.valueOf(d));
            this.writeToFileSolutionStats(stats);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void findOneSolution(String string, String string2, Model model) {
        double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
        try {
            Pair<ArrayList<String>, Stats> pair = this.runSatSolver(string, string2, model, null);
            ArrayList<String> arrayList = pair.getFirst();
            Stats stats = pair.getSecond();
            stats.putValue("SavileRowTotalTime", String.valueOf(d));
            this.writeToFileSolutionStats(stats);
            if (arrayList != null) {
                Solution solution = this.solverSolToAST(arrayList, model.global_symbols);
                this.createSolutionFile(solution, false);
            } else if (model.incumbentSolution != null) {
                this.createSolutionFile(model.incumbentSolution, false);
            } else {
                System.out.println("No solution found.");
            }
            CmdFlags.rmTempFiles();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    Solution parseOneSolverSolution(SymbolTable symbolTable, BufferedReader bufferedReader) {
        return null;
    }

    @Override
    Solution parseLastSolverSolution(SymbolTable symbolTable, BufferedReader bufferedReader) {
        return null;
    }

    protected void writeToFileSolutionStats(Stats stats) {
        stats.putValue("SATVars", String.valueOf(this.m.satModel.getNumVars()));
        stats.putValue("SATClauses", String.valueOf(this.m.satModel.getNumClauses()));
        if (stats != null) {
            stats.makeInfoFiles();
        }
    }

    @Override
    HashMap<String, Long> readAllAssignments(ArrayList<String> arrayList, SymbolTable symbolTable) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        Sat sat = symbolTable.m.satModel;
        long l = 0L;
        for (int i = 0; i < arrayList.size(); ++i) {
            long l2 = Long.valueOf(arrayList.get(i));
            NumberMap numberMap = sat.getDimacsMapping(l2);
            if (numberMap != null) {
                hashMap.put(numberMap.getVariable(), numberMap.getValue());
                l = l2;
                continue;
            }
            if (l2 > 0L && (numberMap = sat.orderMappingMin.get(l2)) != null) {
                hashMap.put(numberMap.getVariable(), numberMap.getValue());
                l = l2;
                continue;
            }
            if (l2 > 0L && l < 0L && (numberMap = sat.orderMappingMid.get(l2)) != null) {
                hashMap.put(numberMap.getVariable(), numberMap.getValue());
                l = l2;
                continue;
            }
            if (l2 < 0L && (numberMap = sat.orderMappingMax.get(l2)) != null) {
                hashMap.put(numberMap.getVariable(), numberMap.getValue());
                l = l2;
                continue;
            }
            l = l2;
        }
        if (CmdFlags.getTestSolutions()) {
            this.checkSolution(hashMap);
        }
        return hashMap;
    }
}

