/*
 * Decompiled with CFR 0.152.
 */
package savilerow.treetransformer;

import java.util.ArrayList;
import java.util.HashSet;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.Identifier;
import savilerow.expression.MakeTable;
import savilerow.expression.MatrixDeref;
import savilerow.expression.MatrixSlice;
import savilerow.expression.SafeMatrixDeref;
import savilerow.model.Model;
import savilerow.treetransformer.NodeReplacement;
import savilerow.treetransformer.TransformMakeTable;

public class TransformMakeTableEarly
extends TransformMakeTable {
    private static boolean verbose = false;

    public TransformMakeTableEarly(Model model) {
        super(model);
    }

    @Override
    protected NodeReplacement processNode(ASTNode aSTNode) {
        if (aSTNode instanceof MakeTable) {
            if (CmdFlags.make_short_tab == 0) {
                return new NodeReplacement(aSTNode.getChild(0));
            }
            if (this.expressionInvariantExceptVars(aSTNode.getChild(0), aSTNode.getChild(0))) {
                boolean bl = CmdFlags.make_short_tab == 2 || CmdFlags.make_short_tab == 4;
                TransformMakeTable.RetPair retPair = this.tryCache(aSTNode, bl);
                if (retPair.nodereplace != null) {
                    return retPair.nodereplace;
                }
                if (verbose) {
                    System.out.println(aSTNode);
                    System.out.println(this.getVariables(aSTNode));
                    System.out.println(this.getDomains(this.getVariables(aSTNode)));
                }
                if (CmdFlags.make_short_tab == 1 || CmdFlags.make_short_tab == 3) {
                    ASTNode aSTNode2 = this.makeTableLong(aSTNode.getChild(0), Long.MAX_VALUE, Long.MAX_VALUE);
                    this.saveToCache(retPair.expstring, aSTNode, aSTNode2);
                    return new NodeReplacement(aSTNode2);
                }
                if (CmdFlags.make_short_tab == 2 || CmdFlags.make_short_tab == 4) {
                    ASTNode aSTNode3 = this.makeTableShort(aSTNode.getChild(0), Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
                    this.saveToCache(retPair.expstring, aSTNode, aSTNode3);
                    return new NodeReplacement(aSTNode3);
                }
            }
        }
        return null;
    }

    public boolean expressionInvariantExceptVars(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode2 instanceof MatrixSlice) {
            return false;
        }
        if (aSTNode2 instanceof MatrixDeref || aSTNode2 instanceof SafeMatrixDeref) {
            if (aSTNode2.getChild(0).getCategory() == 0) {
                for (int i = 1; i < aSTNode2.numChildren(); ++i) {
                    if (this.expressionInvariantExceptVars(aSTNode, aSTNode2.getChild(i))) continue;
                    return false;
                }
                return true;
            }
            if (!(aSTNode2.getChild(0) instanceof Identifier)) {
                return false;
            }
            return aSTNode2.getChild(0).getCategory() >= 3;
        }
        if (aSTNode2 instanceof Identifier) {
            if (aSTNode2.getCategory() == 2) {
                ASTNode aSTNode3 = aSTNode.getDomainForId(aSTNode2);
                return aSTNode3 == null;
            }
            return true;
        }
        for (int i = 0; i < aSTNode2.numChildren(); ++i) {
            if (this.expressionInvariantExceptVars(aSTNode, aSTNode2.getChild(i))) continue;
            return false;
        }
        return true;
    }

    public ArrayList<ASTNode> getVariables(ASTNode aSTNode) {
        HashSet<ASTNode> hashSet = new HashSet<ASTNode>();
        this.getVariablesInner(aSTNode, hashSet);
        return new ArrayList<ASTNode>(hashSet);
    }

    private void getVariablesInner(ASTNode aSTNode, HashSet<ASTNode> hashSet) {
        if (aSTNode instanceof Identifier && aSTNode.getCategory() == 3) {
            hashSet.add(aSTNode);
        } else if (aSTNode instanceof MatrixDeref || aSTNode instanceof SafeMatrixDeref) {
            if (aSTNode.getChild(0).getCategory() == 0) {
                for (int i = 1; i < aSTNode.numChildren(); ++i) {
                    this.getVariablesInner(aSTNode.getChild(i), hashSet);
                }
            } else {
                hashSet.add(aSTNode);
            }
        } else {
            for (int i = 0; i < aSTNode.numChildren(); ++i) {
                this.getVariablesInner(aSTNode.getChild(i), hashSet);
            }
        }
    }

    @Override
    public ArrayList<ASTNode> getDomains(ArrayList<ASTNode> arrayList) {
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) instanceof Identifier) {
                arrayList2.add(this.m.global_symbols.getDomain(arrayList.get(i).toString()));
                continue;
            }
            assert (arrayList.get(i).getChild(0) instanceof Identifier);
            arrayList2.add(this.m.global_symbols.getDomain(arrayList.get(i).getChild(0).toString()).getChild(0));
        }
        return arrayList2;
    }
}

