/*
 * Decompiled with CFR 0.152.
 */
package savilerow.treetransformer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.BooleanDomain;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.ComprehensionForall;
import savilerow.expression.ComprehensionMatrix;
import savilerow.expression.Container;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.EmptyRange;
import savilerow.expression.ExistsExpression;
import savilerow.expression.Flatten;
import savilerow.expression.ForallExpression;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Intersect;
import savilerow.expression.Intpair;
import savilerow.expression.MatrixDomain;
import savilerow.expression.NumberConstant;
import savilerow.expression.Or;
import savilerow.expression.QuantifiedSum;
import savilerow.expression.Quantifier;
import savilerow.expression.Range;
import savilerow.expression.SimpleDomain;
import savilerow.expression.WeightedSum;
import savilerow.model.Model;
import savilerow.treetransformer.NodeReplacement;
import savilerow.treetransformer.ReplaceASTNode;
import savilerow.treetransformer.TransformMatrixToAtoms;
import savilerow.treetransformer.TransformSimplify;
import savilerow.treetransformer.TreeTransformerTopdown;

public class TransformQuantifiedExpression
extends TreeTransformerTopdown {
    public TransformQuantifiedExpression(Model model) {
        super(model);
    }

    @Override
    protected NodeReplacement processNode(ASTNode aSTNode) {
        if (aSTNode instanceof Quantifier) {
            TransformSimplify transformSimplify = new TransformSimplify();
            if (aSTNode.getChild(1) instanceof SimpleDomain) {
                Serializable serializable;
                ASTNode aSTNode2 = aSTNode.getChild(2);
                ASTNode aSTNode3 = aSTNode.getChild(0);
                ASTNode aSTNode4 = aSTNode.getChild(1);
                TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(this.m);
                aSTNode4 = transformQuantifiedExpression.transform(aSTNode4);
                aSTNode4 = transformSimplify.transform(aSTNode4);
                Intpair intpair = aSTNode4.getBounds();
                ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
                if (intpair.lower + 20L >= intpair.upper) {
                    serializable = aSTNode4.getValueSet();
                    for (int i = 0; i < serializable.size(); ++i) {
                        ASTNode aSTNode5 = aSTNode2.copy();
                        ReplaceASTNode replaceASTNode = new ReplaceASTNode(aSTNode3, NumberConstant.make(serializable.get(i)));
                        aSTNode5 = replaceASTNode.transform(aSTNode5);
                        arrayList.add(aSTNode5);
                    }
                } else {
                    long l = intpair.lower + (intpair.upper - intpair.lower) / 2L;
                    ASTNode aSTNode6 = Intpair.makeDomain(intpair.lower, l, false);
                    ASTNode aSTNode7 = Intpair.makeDomain(l + 1L, intpair.upper, false);
                    ASTNode aSTNode8 = aSTNode.copy();
                    ASTNode aSTNode9 = aSTNode.copy();
                    aSTNode8.setChild(1, new Intersect(aSTNode6, aSTNode8.getChild(1)));
                    aSTNode9.setChild(1, new Intersect(aSTNode7, aSTNode9.getChild(1)));
                    arrayList.add(aSTNode8);
                    arrayList.add(aSTNode9);
                }
                if (aSTNode instanceof ForallExpression) {
                    serializable = new And(arrayList);
                } else if (aSTNode instanceof ExistsExpression) {
                    serializable = new Or(arrayList);
                } else {
                    assert (aSTNode instanceof QuantifiedSum);
                    serializable = new WeightedSum(arrayList);
                }
                ((ASTNode)serializable).setParent(aSTNode.getParent());
                serializable = transformSimplify.transform((ASTNode)serializable);
                return new NodeReplacement((ASTNode)serializable);
            }
            if (aSTNode.getChild(1).getCategory() > 0) {
                CmdFlags.println("ERROR: Domain of quantifier is not constant at unrolling time." + aSTNode.getChild(1));
                assert (false);
                CmdFlags.exit();
            }
            assert (aSTNode.getChild(1) instanceof MatrixDomain);
            ArrayList<ASTNode> arrayList = aSTNode.getChild(1).getChildren(3);
            ASTNode aSTNode10 = TransformMatrixToAtoms.enumerateMatrixLiteral(arrayList, aSTNode.getChild(0).toString(), this.m, aSTNode.getChild(1).getChild(0).isBooleanSet());
            ASTNode aSTNode11 = transformSimplify.transform(new Flatten(aSTNode10.copy()));
            ArrayList<ASTNode> arrayList2 = aSTNode11.getChildren(1);
            ReplaceASTNode replaceASTNode = new ReplaceASTNode(aSTNode.getChild(0), aSTNode10);
            ASTNode aSTNode12 = replaceASTNode.transform(aSTNode.getChild(2));
            for (int i = 0; i < arrayList2.size(); ++i) {
                if (aSTNode instanceof ForallExpression) {
                    aSTNode12 = new ForallExpression(arrayList2.get(i), aSTNode.getChild(1).getChild(0), aSTNode12);
                    continue;
                }
                if (aSTNode instanceof ExistsExpression) {
                    aSTNode12 = new ExistsExpression(arrayList2.get(i), aSTNode.getChild(1).getChild(0), aSTNode12);
                    continue;
                }
                if (aSTNode instanceof QuantifiedSum) {
                    aSTNode12 = new QuantifiedSum(arrayList2.get(i), aSTNode.getChild(1).getChild(0), aSTNode12);
                    continue;
                }
                assert (false);
            }
            aSTNode12 = transformSimplify.transform(aSTNode12);
            return new NodeReplacement(aSTNode12);
        }
        if (aSTNode instanceof ComprehensionMatrix) {
            ArrayList<ASTNode> arrayList;
            TransformSimplify transformSimplify = new TransformSimplify();
            ArrayList<ASTNode> arrayList3 = this.comprehendComprehension(aSTNode, aSTNode.getChild(0), aSTNode.getChild(1), aSTNode.getChild(2), 0);
            ASTNode aSTNode13 = aSTNode.getChild(3);
            if (aSTNode13.getCategory() >= 2) {
                arrayList = new TransformQuantifiedExpression(this.m);
                aSTNode13 = transformSimplify.transform(((TreeTransformerTopdown)((Object)arrayList)).transform(aSTNode13));
            }
            if (aSTNode13.isFiniteSet()) {
                assert (arrayList3.size() == aSTNode13.getValueSet().size());
                if (arrayList3.size() > 0) {
                    return new NodeReplacement(new CompoundMatrix(aSTNode13, arrayList3));
                }
                arrayList = aSTNode.getChild(0).getIndexDomains();
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(0, aSTNode13);
                SimpleDomain simpleDomain = aSTNode.getChild(0).isRelation() ? new BooleanDomain(new EmptyRange()) : new IntegerDomain(new EmptyRange());
                return new NodeReplacement(new EmptyMatrix(new MatrixDomain((ASTNode)simpleDomain, arrayList)));
            }
            assert (aSTNode13.isFiniteSetLower());
            assert (aSTNode13.getCategory() == 0);
            arrayList = aSTNode13.getIntervalSet();
            long l = arrayList3.size();
            long l2 = Long.MIN_VALUE;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (((Intpair)((Object)arrayList.get((int)i))).upper == Long.MAX_VALUE) {
                    l2 = ((Intpair)((Object)arrayList.get((int)i))).lower + l - 1L;
                    break;
                }
                long l3 = ((Intpair)((Object)arrayList.get((int)i))).upper - ((Intpair)((Object)arrayList.get((int)i))).lower + 1L;
                if (l - l3 <= 0L) {
                    l2 = ((Intpair)((Object)arrayList.get((int)i))).lower + l - 1L;
                    break;
                }
                l -= l3;
            }
            aSTNode13 = new Intersect((ASTNode)new IntegerDomain(new Range(null, NumberConstant.make(l2))), aSTNode13);
            if (arrayList3.size() > 0) {
                return new NodeReplacement(new CompoundMatrix(aSTNode13, arrayList3));
            }
            ArrayList<ASTNode> arrayList4 = aSTNode.getChild(0).getIndexDomains();
            if (arrayList4 == null) {
                arrayList4 = new ArrayList();
            }
            arrayList4.add(0, aSTNode13);
            SimpleDomain simpleDomain = aSTNode.getChild(0).isRelation() ? new BooleanDomain(new EmptyRange()) : new IntegerDomain(new EmptyRange());
            return new NodeReplacement(new EmptyMatrix(new MatrixDomain((ASTNode)simpleDomain, arrayList4)));
        }
        return null;
    }

    ArrayList<ASTNode> comprehendComprehension(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, ASTNode aSTNode4, int n) {
        TransformSimplify transformSimplify = new TransformSimplify();
        if ((aSTNode4 = transformSimplify.transform(aSTNode4)).isConstant() && aSTNode4.getValue() == 0L) {
            return new ArrayList<ASTNode>();
        }
        aSTNode3 = transformSimplify.transform(aSTNode3);
        TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(this.m);
        if (n < aSTNode3.numChildren()) {
            if (aSTNode3.getChild(n).getChild(1) instanceof MatrixDomain) {
                ASTNode aSTNode5;
                Pair<ArrayList<ASTNode>, ReplaceASTNode> pair = this.enumerateMatrixDomain(aSTNode3.getChild(n));
                ReplaceASTNode replaceASTNode = pair.getSecond();
                ASTNode aSTNode6 = replaceASTNode.transform(aSTNode2.copy());
                ArrayList<ASTNode> arrayList = aSTNode3.copy().getChildren();
                for (int i = n + 1; i < arrayList.size(); ++i) {
                    aSTNode5 = transformSimplify.transform(replaceASTNode.transform(arrayList.get(i).getChild(1)));
                    arrayList.get(i).setChild(1, aSTNode5);
                }
                arrayList.remove(n);
                arrayList.addAll(n, (Collection<ASTNode>)pair.getFirst());
                Container container = new Container(arrayList);
                aSTNode5 = replaceASTNode.transform(aSTNode4.copy());
                ComprehensionMatrix comprehensionMatrix = new ComprehensionMatrix((ASTNode)new BooleanConstant(false), arrayList, (ASTNode)new BooleanConstant(false));
                aSTNode5.setParent(comprehensionMatrix);
                return this.comprehendComprehension(comprehensionMatrix, aSTNode6, container, aSTNode5, n);
            }
            ASTNode aSTNode7 = aSTNode3.getChild(n).getChild(0);
            ASTNode aSTNode8 = aSTNode3.getChild(n).getChild(1);
            aSTNode8 = transformQuantifiedExpression.transform(aSTNode8);
            aSTNode8 = transformSimplify.transform(aSTNode8);
            ArrayList<Intpair> arrayList = aSTNode8.getIntervalSet();
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
            for (int i = 0; i < arrayList.size(); ++i) {
                for (long j = arrayList.get((int)i).lower; j <= arrayList.get((int)i).upper; ++j) {
                    ASTNode aSTNode9 = aSTNode3.getChild(n).getChild(1).isBooleanSet() ? new BooleanConstant(j != 0L) : NumberConstant.make(j);
                    ReplaceASTNode replaceASTNode = new ReplaceASTNode(aSTNode7, aSTNode9);
                    ASTNode aSTNode10 = replaceASTNode.transform(aSTNode2.copy());
                    ASTNode aSTNode11 = aSTNode3.copy();
                    for (int k = n + 1; k < aSTNode3.numChildren(); ++k) {
                        ASTNode aSTNode12 = replaceASTNode.transform(aSTNode11.getChild(k).getChild(1));
                        aSTNode12 = transformSimplify.transform(aSTNode12);
                        aSTNode11.getChild(k).setChild(1, aSTNode12);
                    }
                    ASTNode aSTNode13 = replaceASTNode.transform(aSTNode4.copy());
                    aSTNode13.setParent(aSTNode);
                    arrayList2.addAll(this.comprehendComprehension(aSTNode, aSTNode10, aSTNode11, aSTNode13, n + 1));
                }
            }
            return arrayList2;
        }
        aSTNode4 = transformQuantifiedExpression.transform(aSTNode4);
        if (!((aSTNode4 = transformSimplify.transform(aSTNode4)) instanceof BooleanConstant)) {
            System.out.println(aSTNode4);
        }
        assert (aSTNode4 instanceof BooleanConstant);
        if (aSTNode4.getValue() == 1L) {
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            arrayList.add(aSTNode2);
            return arrayList;
        }
        return new ArrayList<ASTNode>();
    }

    public NodeReplacement replaceMatrixDomainsAtoms(ASTNode aSTNode) {
        TransformSimplify transformSimplify = new TransformSimplify();
        for (int i = 0; i < aSTNode.getChild(1).numChildren(); ++i) {
            int n;
            ASTNode aSTNode2 = aSTNode.getChild(1).getChild(i);
            if (!(aSTNode2.getChild(1) instanceof MatrixDomain)) continue;
            TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(this.m);
            aSTNode2 = transformSimplify.transform(transformQuantifiedExpression.transform(aSTNode2));
            ASTNode aSTNode3 = aSTNode2.getChild(0);
            ArrayList<ASTNode> arrayList = aSTNode2.getChild(1).getChildren(3);
            ASTNode aSTNode4 = TransformMatrixToAtoms.enumerateMatrixLiteral(arrayList, aSTNode2.getChild(0).toString(), this.m, aSTNode2.getChild(1).getChild(0).isBooleanSet());
            ASTNode aSTNode5 = transformSimplify.transform(new Flatten(aSTNode4.copy()));
            ArrayList<ASTNode> arrayList2 = aSTNode5.getChildren(1);
            ReplaceASTNode replaceASTNode = new ReplaceASTNode(aSTNode2.getChild(0), aSTNode4);
            ASTNode aSTNode6 = replaceASTNode.transform(aSTNode.getChild(0));
            ASTNode aSTNode7 = replaceASTNode.transform(aSTNode.getChild(2));
            for (int j = 0; j < arrayList2.size(); ++j) {
                arrayList2.set(j, new ComprehensionForall(arrayList2.get(j), aSTNode2.getChild(1).getChild(0)));
            }
            ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
            for (n = 0; n < i; ++n) {
                arrayList3.add(aSTNode.getChild(1).getChild(n));
            }
            arrayList3.addAll(arrayList2);
            for (n = i + 1; n < aSTNode.getChild(1).numChildren(); ++n) {
                arrayList3.add(aSTNode.getChild(1).getChild(n));
            }
            return new NodeReplacement(new ComprehensionMatrix(aSTNode6, arrayList3, aSTNode7, aSTNode.getChild(3)));
        }
        return null;
    }

    public Pair<ArrayList<ASTNode>, ReplaceASTNode> enumerateMatrixDomain(ASTNode aSTNode) {
        assert (aSTNode.getChild(1) instanceof MatrixDomain);
        TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(this.m);
        TransformSimplify transformSimplify = new TransformSimplify();
        aSTNode = transformSimplify.transform(transformQuantifiedExpression.transform(aSTNode));
        ASTNode aSTNode2 = aSTNode.getChild(0);
        ArrayList<ASTNode> arrayList = aSTNode.getChild(1).getChildren(3);
        ASTNode aSTNode3 = TransformMatrixToAtoms.enumerateMatrixLiteral(arrayList, aSTNode.getChild(0).toString(), this.m, aSTNode.getChild(1).getChild(0).isBooleanSet());
        ASTNode aSTNode4 = transformSimplify.transform(new Flatten(aSTNode3.copy()));
        ArrayList<ASTNode> arrayList2 = aSTNode4.getChildren(1);
        ReplaceASTNode replaceASTNode = new ReplaceASTNode(aSTNode.getChild(0), aSTNode3);
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList2.set(i, new ComprehensionForall(arrayList2.get(i), aSTNode.getChild(1).getChild(0)));
        }
        return new Pair<ArrayList<ASTNode>, ReplaceASTNode>(arrayList2, replaceASTNode);
    }
}

