/*
 * Decompiled with CFR 0.152.
 */
package savilerow.treetransformer;

import java.io.Serializable;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Equals;
import savilerow.expression.Identifier;
import savilerow.expression.Iff;
import savilerow.expression.InSet;
import savilerow.expression.Intersect;
import savilerow.expression.Intpair;
import savilerow.expression.MultiStage;
import savilerow.expression.Negate;
import savilerow.expression.ToVariable;
import savilerow.expression.Top;
import savilerow.model.Model;
import savilerow.treetransformer.NodeReplacement;
import savilerow.treetransformer.TransformSimplify;
import savilerow.treetransformer.TreeTransformerBottomUpNoWrapper;

public class TransformSimplifyExtended
extends TreeTransformerBottomUpNoWrapper {
    public TransformSimplifyExtended(Model model) {
        super(model);
    }

    @Override
    protected NodeReplacement processNode(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.simplify();
        if (aSTNode2 != null) {
            assert (aSTNode2 != aSTNode);
            return new NodeReplacement(aSTNode2);
        }
        if (CmdFlags.getUseDeleteVars()) {
            return TransformSimplifyExtended.doDeleteVars(aSTNode, this.m);
        }
        return null;
    }

    private static NodeReplacement doDeleteVars(ASTNode aSTNode, Model model) {
        if (aSTNode.getParent() != null && (aSTNode.getParent() instanceof And && aSTNode.getParent().getParent() instanceof Top || aSTNode.getParent() instanceof Top)) {
            Serializable serializable;
            Object object;
            boolean bl;
            boolean bl2 = bl = !CmdFlags.getUseAggregate() || CmdFlags.getAfterAggregate();
            if (aSTNode instanceof Equals || aSTNode instanceof Iff || aSTNode instanceof ToVariable) {
                object = aSTNode.getChild(0);
                serializable = aSTNode.getChild(1);
                if (object instanceof Identifier && serializable.isConstant() && bl) {
                    model.global_symbols.assignVariable((ASTNode)object, (ASTNode)serializable);
                    return new NodeReplacement(new BooleanConstant(true));
                }
                if (serializable instanceof Identifier && ((ASTNode)object).isConstant() && bl) {
                    model.global_symbols.assignVariable((ASTNode)serializable, (ASTNode)object);
                    return new NodeReplacement(new BooleanConstant(true));
                }
                if (object instanceof Identifier && serializable instanceof Identifier && !((ASTNode)object).equals(serializable)) {
                    model.global_symbols.unifyVariables((ASTNode)object, (ASTNode)serializable);
                    return new NodeReplacement(new BooleanConstant(true));
                }
                if ((CmdFlags.getMiniontrans() || CmdFlags.getSattrans()) && ((ASTNode)object).isRelation() && serializable.isRelation()) {
                    if (object instanceof Identifier && serializable instanceof Negate && serializable.getChild(0) instanceof Identifier) {
                        model.global_symbols.unifyVariablesNegated((ASTNode)object, (ASTNode)serializable);
                        return new NodeReplacement(new BooleanConstant(true));
                    }
                    if (serializable instanceof Identifier && object instanceof Negate && ((ASTNode)object).getChild(0) instanceof Identifier) {
                        model.global_symbols.unifyVariablesNegated((ASTNode)serializable, (ASTNode)object);
                        return new NodeReplacement(new BooleanConstant(true));
                    }
                }
            }
            if (aSTNode instanceof Identifier && bl) {
                model.global_symbols.assignVariable(aSTNode, new BooleanConstant(true));
                return new NodeReplacement(new BooleanConstant(true));
            }
            if (aSTNode instanceof Negate && aSTNode.getChild(0) instanceof Identifier && bl) {
                model.global_symbols.assignVariable(aSTNode.getChild(0), new BooleanConstant(false));
                return new NodeReplacement(new BooleanConstant(true));
            }
            if (aSTNode instanceof InSet && aSTNode.getChild(0) instanceof Identifier && aSTNode.getChild(0).getCategory() == 3 && aSTNode.getChild(1).getCategory() == 0) {
                object = aSTNode.getChild(0).toString();
                serializable = new Intersect(model.global_symbols.getDomain((String)object), aSTNode.getChild(1));
                TransformSimplify transformSimplify = new TransformSimplify();
                model.global_symbols.setDomain((String)object, transformSimplify.transform((ASTNode)serializable));
                return new NodeReplacement(new BooleanConstant(true));
            }
            if (aSTNode instanceof MultiStage && aSTNode.getChild(0) instanceof Identifier && aSTNode.getChild(1).getCategory() == 0 && ((ASTNode)(object = ((Identifier)aSTNode.getChild(0)).getDomain())).getCategory() == 0) {
                serializable = new ArrayList();
                for (int i = 1; i < aSTNode.getChild(1).numChildren(); ++i) {
                    serializable = Intpair.union((ArrayList<Intpair>)serializable, aSTNode.getChild(1).getChild(i).getIntervalSetExp());
                }
                ArrayList<Intpair> arrayList = ((ASTNode)object).getIntervalSet();
                ArrayList<Intpair> arrayList2 = Intpair.intersection(arrayList, (ArrayList<Intpair>)serializable);
                if (!arrayList2.equals(arrayList)) {
                    String string = aSTNode.getChild(0).toString();
                    model.global_symbols.setDomain(string, Intpair.makeDomain(arrayList2, aSTNode.getChild(0).isRelation()));
                }
            }
        }
        return null;
    }
}

