/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import savilerow.CmdFlags;
import savilerow.RepositoryVersion;

public class PersistentCache {
    static File basedir = new File(System.getProperty("user.home") + "/.savilerow/tablecache/" + RepositoryVersion.repositoryVersion);

    public PersistentCache() {
        boolean bl;
        if (!basedir.exists() && !(bl = basedir.mkdirs())) {
            System.out.println("ERROR: Unable to create table cache");
            System.exit(1);
        }
    }

    public static String getHash(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string.getBytes());
            return new BigInteger(1, messageDigest.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("ERROR: SHA-256 doesn't exist");
            System.exit(1);
            return null;
        }
    }

    public void addToCache(String string, String string2) {
        CmdFlags.printlnIfVerbose("adding to cache");
        File file = new File(basedir, PersistentCache.getHash(string));
        try (PrintWriter printWriter = new PrintWriter(file);){
            printWriter.print("# ");
            printWriter.println(string);
            printWriter.println(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            CmdFlags.errorExit("Unable to write cache file: " + file);
        }
    }

    public String findInCache(String string) {
        File file = new File(basedir, PersistentCache.getHash(string));
        if (!file.exists()) {
            CmdFlags.printlnIfVerbose("Cache miss");
            return null;
        }
        CmdFlags.printlnIfVerbose("Cache hit");
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string3 = bufferedReader.readLine();
            if (!string3.equals("# " + string)) {
                System.out.println("ERROR: Cache hash collision");
                System.out.println(file);
                System.out.println("E: '# " + string + "'");
                System.out.println("G: '" + string3 + "'");
                System.exit(1);
            }
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            System.out.println("ERROR: Unable to read cache file");
            System.exit(1);
            return null;
        }
    }
}

