/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.AllDifferent;
import savilerow.expression.And;
import savilerow.expression.Divide;
import savilerow.expression.Equals;
import savilerow.expression.Iff;
import savilerow.expression.Implies;
import savilerow.expression.InSet;
import savilerow.expression.Intersect;
import savilerow.expression.Less;
import savilerow.expression.LessEqual;
import savilerow.expression.LexLess;
import savilerow.expression.LexLessEqual;
import savilerow.expression.Mod;
import savilerow.expression.Or;
import savilerow.expression.Power;
import savilerow.expression.SetDifference;
import savilerow.expression.Subset;
import savilerow.expression.SubsetEq;
import savilerow.expression.Times;
import savilerow.expression.Union;
import savilerow.expression.WeightedSum;
import savilerow.expression.Xor;
import savilerow.model.SymbolTable;

public abstract class BinOp
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public BinOp(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + " " + this.getClass().getName() + " " + this.getChild(1) + ")";
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < 2; ++i) {
            if (!this.getChild(i).typecheck(symbolTable)) {
                return false;
            }
            if (this.getChild(i).getDimension() > 0) {
                CmdFlags.println("ERROR: Unexpected matrix in binary numerical/logical operator: " + this);
                return false;
            }
            if (!this.getChild(i).isSet()) continue;
            CmdFlags.println("ERROR: Unexpected domain in binary numerical/logical operator: " + this);
            return false;
        }
        return true;
    }

    public static ASTNode make(ASTNode aSTNode, String string, ASTNode aSTNode2) {
        return BinOp.makeBinOp(string, aSTNode, aSTNode2);
    }

    public static ASTNode makeBinOp(String string, ASTNode aSTNode, ASTNode aSTNode2) {
        if (string.equals("=")) {
            return new Equals(aSTNode, aSTNode2);
        }
        if (string.equals("!=")) {
            return new AllDifferent(aSTNode, aSTNode2);
        }
        if (string.equals("<=")) {
            return new LessEqual(aSTNode, aSTNode2);
        }
        if (string.equals("<")) {
            return new Less(aSTNode, aSTNode2);
        }
        if (string.equals(">=")) {
            return new LessEqual(aSTNode2, aSTNode);
        }
        if (string.equals(">")) {
            return new Less(aSTNode2, aSTNode);
        }
        if (string.equals("<=lex")) {
            return new LexLessEqual(aSTNode, aSTNode2);
        }
        if (string.equals("<lex")) {
            return new LexLess(aSTNode, aSTNode2);
        }
        if (string.equals(">=lex")) {
            return new LexLessEqual(aSTNode2, aSTNode);
        }
        if (string.equals(">lex")) {
            return new LexLess(aSTNode2, aSTNode);
        }
        if (string.equals("in")) {
            return new InSet(aSTNode, aSTNode2);
        }
        if (string.equals("+")) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            arrayList.add(1L);
            arrayList.add(1L);
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
            arrayList2.add(aSTNode);
            arrayList2.add(aSTNode2);
            return new WeightedSum(arrayList2, arrayList);
        }
        if (string.equals("-")) {
            if (aSTNode.isSet() || aSTNode2.isSet()) {
                return new SetDifference(aSTNode, aSTNode2);
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            arrayList.add(1L);
            arrayList.add(-1L);
            ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
            arrayList3.add(aSTNode);
            arrayList3.add(aSTNode2);
            return new WeightedSum(arrayList3, arrayList);
        }
        if (string.equals("/")) {
            return new Divide(aSTNode, aSTNode2);
        }
        if (string.equals("*")) {
            return new Times(aSTNode, aSTNode2);
        }
        if (string.equals("**")) {
            return new Power(aSTNode, aSTNode2);
        }
        if (string.equals("%")) {
            return new Mod(aSTNode, aSTNode2);
        }
        if (string.equals("/\\")) {
            return new And(aSTNode, aSTNode2);
        }
        if (string.equals("\\/")) {
            return new Or(aSTNode, aSTNode2);
        }
        if (string.equals("xor")) {
            return new Xor(aSTNode, aSTNode2);
        }
        if (string.equals("=>") || string.equals("->")) {
            return new Implies(aSTNode, aSTNode2);
        }
        if (string.equals("<=>") || string.equals("<->")) {
            return new Iff(aSTNode, aSTNode2);
        }
        if (string.equals("union")) {
            return new Union(aSTNode, aSTNode2);
        }
        if (string.equals("intersect")) {
            return new Intersect(aSTNode, aSTNode2);
        }
        if (string.equals("subsetEq")) {
            return new SubsetEq(aSTNode, aSTNode2);
        }
        if (string.equals("subset")) {
            return new Subset(aSTNode, aSTNode2);
        }
        if (string.equals("supsetEq")) {
            return new SubsetEq(aSTNode2, aSTNode);
        }
        if (string.equals("supset")) {
            return new Subset(aSTNode2, aSTNode);
        }
        System.out.println("Unsupported binary operator:" + string);
        return null;
    }
}

