/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.Intpair;
import savilerow.expression.Top;
import savilerow.model.Sat;

public class BooleanConstant
extends ASTNodeC {
    public static final long serialVersionUID = 1L;
    boolean b;

    public BooleanConstant(boolean bl) {
        this.b = bl;
    }

    @Override
    public ASTNode copy() {
        return new BooleanConstant(this.b);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof BooleanConstant)) {
            return false;
        }
        return this.b == ((BooleanConstant)object).b;
    }

    @Override
    public int hashCode() {
        if (this.b) {
            return 643787;
        }
        return 7812376;
    }

    @Override
    public String toString() {
        return "" + this.b;
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public long getValue() {
        if (this.b) {
            return 1L;
        }
        return 0L;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = new ArrayList<Intpair>();
        long l = this.b ? 1L : 0L;
        arrayList.add(new Intpair(l, l));
        return arrayList;
    }

    @Override
    public long directEncode(Sat sat, long l) {
        if ((long)(this.b ? 1 : 0) == l) {
            return sat.getTrue();
        }
        return -sat.getTrue();
    }

    @Override
    public long orderEncode(Sat sat, long l) {
        if ((long)(this.b ? 1 : 0) <= l) {
            return sat.getTrue();
        }
        return -sat.getTrue();
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        ASTNode aSTNode = this.getParent();
        if (bl) {
            if (this.b) {
                bufferedWriter.append("true()");
            } else {
                bufferedWriter.append("false()");
            }
        } else if (this.b) {
            bufferedWriter.append("1");
        } else {
            bufferedWriter.append("0");
        }
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        if (!this.b) {
            sat.addClause(-sat.getTrue());
        }
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        if (this.b) {
            stringBuilder.append("1");
        } else {
            stringBuilder.append("0");
        }
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        ASTNode aSTNode = this.getParent();
        if (aSTNode instanceof Top) {
            if (this.b) {
                bufferedWriter.append("constraint bool_eq(true,true);");
            } else {
                bufferedWriter.append("constraint bool_eq(true,false);");
            }
        } else if (!bl) {
            if (this.b) {
                bufferedWriter.append("1");
            } else {
                bufferedWriter.append("0");
            }
        } else if (this.b) {
            bufferedWriter.append("true");
        } else {
            bufferedWriter.append("false");
        }
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            if (this.b) {
                stringBuilder.append("true");
            } else {
                stringBuilder.append("false");
            }
        } else if (this.b) {
            stringBuilder.append("1");
        } else {
            stringBuilder.append("0");
        }
    }
}

