/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.Container;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.Range;
import savilerow.model.SymbolTable;

public class ComprehensionMatrix
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public ComprehensionMatrix(ASTNode aSTNode, ArrayList<ASTNode> arrayList, ASTNode aSTNode2) {
        super(aSTNode, new Container(arrayList), aSTNode2, new IntegerDomain(new Range((ASTNode)NumberConstant.make(1L), null)));
    }

    public ComprehensionMatrix(ASTNode aSTNode, ArrayList<ASTNode> arrayList, ASTNode aSTNode2, ASTNode aSTNode3) {
        super(aSTNode, new Container(arrayList), aSTNode2, aSTNode3);
    }

    @Override
    public ASTNode copy() {
        return new ComprehensionMatrix(this.getChild(0), this.getChild(1).getChildren(), this.getChild(2), this.getChild(3));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public boolean isRelation() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean isNumerical() {
        return this.getChild(0).isNumerical();
    }

    @Override
    public int getDimension() {
        return 1 + this.getChild(0).getDimension();
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!(this.getChild(0).typecheck(symbolTable) && this.getChild(1).typecheck(symbolTable) && this.getChild(2).typecheck(symbolTable) && this.getChild(3).typecheck(symbolTable))) {
            return false;
        }
        for (int i = 0; i < this.getChild(1).numChildren(); ++i) {
            ASTNode aSTNode = this.getChild(1).getChild(i);
            if (this.getParent().getDomainForId(aSTNode.getChild(0)) != null || symbolTable.hasVariable(aSTNode.getChild(0).toString())) {
                CmdFlags.println("ERROR: In matrix comprehension: " + this);
                CmdFlags.println("ERROR: Variable `" + aSTNode.getChild(0) + "' is already defined.");
                return false;
            }
            for (int j = 0; j < i; ++j) {
                if (!aSTNode.getChild(0).equals(this.getChild(1).getChild(j).getChild(0))) continue;
                CmdFlags.println("ERROR: In matrix comprehension: " + this);
                CmdFlags.println("ERROR: Variable `" + aSTNode.getChild(0) + "' is already defined.");
                return false;
            }
        }
        if (this.getChild(2).getCategory() > 2) {
            System.out.println("ERROR: In matrix comprehension: " + this);
            System.out.println("ERROR: Decision variable in condition.");
            return false;
        }
        if (!this.getChild(2).isRelation()) {
            System.out.println("ERROR: In matrix comprehension: " + this);
            System.out.println("ERROR: The condition is not a boolean expression.");
            return false;
        }
        if (this.getChild(3).getCategory() > 2) {
            System.out.println("ERROR: In matrix comprehension: " + this);
            System.out.println("ERROR: Decision variable in index domain.");
            return false;
        }
        if (!this.getChild(3).isSet()) {
            System.out.println("ERROR: In matrix comprehension: " + this);
            System.out.println("ERROR: Index domain is not a set.");
            return false;
        }
        return true;
    }

    @Override
    public ASTNode getDomainForId(ASTNode aSTNode) {
        for (int i = 0; i < this.getChild(1).numChildren(); ++i) {
            ASTNode aSTNode2 = this.getChild(1).getChild(i);
            if (!aSTNode2.getChild(0).equals(aSTNode)) continue;
            return aSTNode2.getChild(1);
        }
        return this.getParent().getDomainForId(aSTNode);
    }

    @Override
    public Intpair getBounds() {
        return this.getChild(0).getBounds();
    }

    @Override
    public PairASTNode getBoundsAST() {
        return this.getChild(0).getBoundsAST();
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("[");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("|");
        for (int i = 0; i < this.getChild(1).numChildren(); ++i) {
            this.getChild(1).getChild(i).toDominionParam(stringBuilder);
            stringBuilder.append(", ");
        }
        this.getChild(2).toDominionParam(stringBuilder);
        stringBuilder.append("]");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("[");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append("|");
        for (int i = 0; i < this.getChild(1).numChildren(); ++i) {
            this.getChild(1).getChild(i).toDominionParam(stringBuilder);
            stringBuilder.append(", ");
        }
        this.getChild(2).toDominionParam(stringBuilder);
        stringBuilder.append("]");
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.getChild(0));
        stringBuilder.append("|");
        for (int i = 0; i < this.getChild(1).numChildren(); ++i) {
            stringBuilder.append(this.getChild(1).getChild(i).toString());
            stringBuilder.append(", ");
        }
        stringBuilder.append(this.getChild(2));
        stringBuilder.append(" ;");
        stringBuilder.append(this.getChild(3));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

