/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.EmptyRange;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Intpair;
import savilerow.expression.MatrixDomain;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.Range;
import savilerow.expression.Unary;
import savilerow.model.SymbolTable;

public class Flatten
extends Unary {
    public static final long serialVersionUID = 1L;

    public Flatten(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new Flatten(this.getChild(0));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() < 1) {
            System.out.println("ERROR: Expected matrix inside flatten function: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof Flatten) {
            this.getChild(0).setParent(null);
            return this.getChild(0);
        }
        ASTNode aSTNode = this.getChildConst(0);
        if (aSTNode instanceof CompoundMatrix) {
            int n;
            ArrayList<ASTNode> arrayList = this.flatten_compound_matrix(aSTNode);
            boolean bl = true;
            for (n = 0; n < arrayList.size(); ++n) {
                if (arrayList.get(n).getDimension() <= 0) continue;
                bl = false;
                break;
            }
            if (bl) {
                if (aSTNode == this.getChild(0)) {
                    for (n = 0; n < arrayList.size(); ++n) {
                        arrayList.get(n).setParent(null);
                    }
                }
                return CompoundMatrix.make(arrayList);
            }
            return null;
        }
        if (aSTNode instanceof EmptyMatrix) {
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            arrayList.add(new IntegerDomain(new EmptyRange()));
            return new EmptyMatrix(new MatrixDomain(aSTNode.getChild(0).getChild(0), arrayList));
        }
        return null;
    }

    private ArrayList<ASTNode> flatten_compound_matrix(ASTNode aSTNode) {
        assert (aSTNode instanceof CompoundMatrix);
        ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
        ArrayList<ASTNode> arrayList2 = Flatten.list();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) instanceof CompoundMatrix) {
                ArrayList<ASTNode> arrayList3 = this.flatten_compound_matrix(arrayList.get(i));
                arrayList2.addAll(arrayList3);
                continue;
            }
            if (arrayList.get(i) instanceof EmptyMatrix) continue;
            arrayList2.add(arrayList.get(i));
        }
        return arrayList2;
    }

    @Override
    public ArrayList<Long> getValueSet() {
        return this.getChild(0).getValueSet();
    }

    @Override
    public Intpair getBounds() {
        return this.getChild(0).getBounds();
    }

    @Override
    public PairASTNode getBoundsAST() {
        return this.getChild(0).getBoundsAST();
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        return this.getChild(0).getIntervalSetExp();
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public boolean isRelation() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean isNumerical() {
        return this.getChild(0).isNumerical();
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public ArrayList<ASTNode> getIndexDomains() {
        ArrayList<ASTNode> arrayList = this.getChild(0).getIndexDomains();
        if (arrayList == null) {
            return null;
        }
        long l = 1L;
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList<Intpair> arrayList2 = arrayList.get(i).getIntervalSet();
            long l2 = 0L;
            for (int j = 0; j < arrayList2.size(); ++j) {
                if (arrayList2.get(j).isEmpty()) continue;
                l2 += arrayList2.get((int)j).upper - arrayList2.get((int)j).lower + 1L;
            }
            l *= l2;
        }
        arrayList.clear();
        arrayList.add(new IntegerDomain(new Range((ASTNode)NumberConstant.make(1L), NumberConstant.make(l))));
        return arrayList;
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("flatten(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("flatten(");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (!bl);
        this.getChild(0).toMinion(bufferedWriter, false);
    }

    @Override
    public String toString() {
        return "flatten(" + this.getChild(0) + ")";
    }
}

