/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.ComprehensionForall;
import savilerow.expression.ComprehensionMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Identifier;
import savilerow.expression.Indices;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Intpair;
import savilerow.expression.MatrixDeref;
import savilerow.expression.MatrixDomain;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.Range;
import savilerow.expression.SafeMatrixDeref;
import savilerow.expression.Unpack;
import savilerow.model.Model;
import savilerow.model.SymbolTable;

public class MatrixSlice
extends ASTNodeC {
    public static final long serialVersionUID = 1L;
    protected transient Model m;

    public MatrixSlice(Model model, ASTNode aSTNode, ArrayList<ASTNode> arrayList) {
        super(aSTNode, arrayList.toArray(new ASTNode[arrayList.size()]));
        this.m = model;
    }

    @Override
    public boolean hasModel() {
        return true;
    }

    @Override
    public Model getModel() {
        return this.m;
    }

    @Override
    public void setModel(Model model) {
        this.m = model;
    }

    @Override
    public ASTNode copy() {
        return new MatrixSlice(this.m, this.getChild(0), this.getChildren(1));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (ASTNode aSTNode : this.getChildren()) {
            if (aSTNode.typecheck(symbolTable)) continue;
            return false;
        }
        for (int i = 1; i < this.numChildren(); ++i) {
            if (this.getChild(i).getCategory() <= 2) continue;
        }
        if (this.numChildren() - 1 != this.getChild(0).getDimension()) {
            CmdFlags.println("ERROR: Number of indices in matrix slice does not match dimensions of matrix:");
            CmdFlags.println("ERROR: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode;
        if (this.numChildren() == 2 && this.getChild(1) instanceof Unpack) {
            ArrayList<ASTNode> arrayList = ((Unpack)this.getChild(1)).items();
            if (arrayList != null) {
                this.getChild(0).setParent(null);
                return new MatrixSlice(this.m, this.getChild(0), arrayList);
            }
            return null;
        }
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 1; i < this.numChildren(); ++i) {
            int n = this.getChild(i).getCategory();
            if (n > 0) {
                bl = false;
            }
            if (n != 3) continue;
            bl2 = true;
        }
        if (bl && ((aSTNode = this.getChildConst(0)) instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix)) {
            ASTNode aSTNode2 = MatrixSlice.evaluateSlice(aSTNode, this.getChildren(1));
            return aSTNode2 == null ? null : aSTNode2;
        }
        if (bl2) {
            ASTNode aSTNode3;
            ArrayList<ASTNode> arrayList = MatrixSlice.list();
            ArrayList<ASTNode> arrayList2 = MatrixSlice.list();
            for (int i = 1; i < this.numChildren(); ++i) {
                if (this.getChild(i).isSet()) {
                    aSTNode3 = new Identifier(this.m, this.m.global_symbols.newAuxId());
                    arrayList.add(aSTNode3);
                    arrayList2.add(aSTNode3);
                    continue;
                }
                arrayList.add(null);
                arrayList2.add(this.getChild(i));
            }
            this.getChild(0).setParent(null);
            ASTNodeC aSTNodeC = new SafeMatrixDeref(this.getChild(0), arrayList2);
            aSTNode3 = new Indices(this.getChild(0));
            for (int i = this.numChildren() - 1; i >= 1; --i) {
                if (!this.getChild(i).isSet()) continue;
                MatrixDeref matrixDeref = new MatrixDeref(aSTNode3, MatrixSlice.list(NumberConstant.make(i)));
                aSTNodeC = new ComprehensionMatrix((ASTNode)aSTNodeC, MatrixSlice.list(new ComprehensionForall(arrayList.get(i - 1), matrixDeref)), (ASTNode)new BooleanConstant(true), (ASTNode)matrixDeref);
            }
            return aSTNodeC;
        }
        return null;
    }

    public static ASTNode evaluateSlice(ASTNode aSTNode, ArrayList<ASTNode> arrayList) {
        long l;
        if (arrayList.size() == 0) {
            assert (!(aSTNode instanceof CompoundMatrix) && !(aSTNode instanceof EmptyMatrix));
            return aSTNode;
        }
        ASTNode aSTNode2 = arrayList.get(0);
        if (aSTNode instanceof EmptyMatrix) {
            ASTNode aSTNode3 = aSTNode.getChild(0);
            ArrayList<ASTNode> arrayList2 = aSTNode3.getChildren(3);
            assert (arrayList2.size() == arrayList.size());
            for (int i = arrayList2.size() - 1; i >= 0; --i) {
                if (arrayList.get(i).equals(new IntegerDomain(new Range(null, null)))) continue;
                arrayList2.remove(i);
            }
            return new EmptyMatrix(new MatrixDomain(aSTNode.getChild(0).getChild(0), arrayList2));
        }
        if (aSTNode2.isSet()) {
            assert (!aSTNode2.isFiniteSetUpper() && !aSTNode2.isFiniteSetLower());
            ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
            ArrayList<ASTNode> arrayList4 = new ArrayList<ASTNode>(arrayList);
            arrayList4.remove(0);
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                ASTNode aSTNode4 = MatrixSlice.evaluateSlice(aSTNode.getChildConst(i), arrayList4);
                if (aSTNode4 == null) {
                    return null;
                }
                arrayList3.add(aSTNode4);
            }
            return new CompoundMatrix(aSTNode.getChild(0), arrayList3);
        }
        ArrayList<Long> arrayList5 = aSTNode instanceof CompoundMatrix ? aSTNode.getChild(0).getValueSet() : (aSTNode instanceof EmptyMatrix ? new ArrayList() : null);
        int n = arrayList5.indexOf(l = aSTNode2.getValue());
        if (n == -1) {
            return null;
        }
        ArrayList<ASTNode> arrayList6 = new ArrayList<ASTNode>(arrayList);
        arrayList6.remove(0);
        return MatrixSlice.evaluateSlice(aSTNode.getChildConst(n + 1), arrayList6);
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (!bl);
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toMinion(bufferedWriter, false);
            if (i >= this.numChildren() - 1) continue;
            bufferedWriter.append(",");
        }
        bufferedWriter.append("]");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        this.toDominionParam(stringBuilder);
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toDominionParam(stringBuilder);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
    }

    @Override
    public Intpair getBounds() {
        return this.getChild(0).getBounds();
    }

    @Override
    public PairASTNode getBoundsAST() {
        return this.getChild(0).getBoundsAST();
    }

    @Override
    public int getDimension() {
        int n = 0;
        for (int i = 1; i < this.numChildren(); ++i) {
            if (!this.getChild(i).isSet()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public String toString() {
        String string = this.getChild(0).toString() + "[";
        for (int i = 1; i < this.numChildren(); ++i) {
            string = string + this.getChild(i);
            if (i >= this.numChildren() - 1) continue;
            string = string + ",";
        }
        return string + "]";
    }

    @Override
    public boolean isRelation() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean strongProp() {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).isSet() || this.getChild(i).strongProp()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNumerical() {
        return this.getChild(0).isNumerical();
    }
}

