/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.Constants;
import savilerow.expression.ASTNode;
import savilerow.expression.BinOp;
import savilerow.expression.Intpair;
import savilerow.expression.Max;
import savilerow.expression.Min;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.Power;
import savilerow.model.Sat;

public class SafePower
extends BinOp {
    public static final long serialVersionUID = 1L;

    public SafePower(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new SafePower(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            long l = this.getChild(0).getValue();
            long l2 = this.getChild(1).getValue();
            if (l == 0L && l2 == 0L || l2 < 0L) {
                return NumberConstant.make(0L);
            }
            return NumberConstant.make(Power.pow(l, l2));
        }
        if (this.getChild(1).isConstant() && this.getChild(1).getValue() == 1L) {
            this.getChild(0).setParent(null);
            return this.getChild(0);
        }
        return null;
    }

    @Override
    public Intpair getBounds() {
        long l;
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        long l2 = intpair2.upper;
        long l3 = intpair2.upper - 1L;
        long l4 = intpair2.lower;
        intpair2.upper = Math.max(Power.pow(intpair.upper, l2), Math.max(Power.pow(intpair.lower, l2), Power.pow(intpair.lower, l3)));
        intpair2.lower = Math.min(Power.pow(intpair.lower, l4), Math.min(Power.pow(intpair.lower, l2), Power.pow(intpair.lower, l3)));
        if (intpair2.upper < 0L) {
            intpair2.upper = 0L;
        }
        if (intpair2.lower > 0L) {
            intpair2.lower = 0L;
        }
        if (intpair2.upper < 1L) {
            intpair2.upper = 1L;
        }
        if (intpair2.lower > 1L) {
            intpair2.lower = 1L;
        }
        if (this.getChild(1).isConstant() && (l = this.getChild(1).getValue()) > 0L && l % 2L == 0L && intpair2.lower < 0L) {
            intpair2.lower = 0L;
        }
        return this.lookupBounds(intpair2);
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
        ArrayList<Intpair> arrayList2 = this.getChild(1).getIntervalSetExp();
        if (Intpair.numValues(arrayList) * Intpair.numValues(arrayList2) > (long)Constants.intervallim) {
            return super.getIntervalSetExp();
        }
        ArrayList<Intpair> arrayList3 = new ArrayList<Intpair>();
        for (int i = 0; i < arrayList.size(); ++i) {
            for (long j = arrayList.get((int)i).lower; j <= arrayList.get((int)i).upper; ++j) {
                for (int k = 0; k < arrayList2.size(); ++k) {
                    for (long i2 = arrayList2.get((int)k).lower; i2 <= arrayList2.get((int)k).upper; ++i2) {
                        long l = Power.pow(j, i2);
                        arrayList3.add(new Intpair(l, l));
                    }
                }
            }
        }
        Intpair.normalise(arrayList3);
        return arrayList3;
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(0).getBoundsAST();
        PairASTNode pairASTNode2 = this.getChild(1).getBoundsAST();
        ASTNode aSTNode = pairASTNode2.e2;
        ASTNode aSTNode2 = BinOp.makeBinOp("-", pairASTNode2.e2, NumberConstant.make(1L));
        ASTNode aSTNode3 = pairASTNode2.e1;
        pairASTNode2.e2 = new Max((ASTNode)new SafePower(pairASTNode.e2, aSTNode), new Max((ASTNode)new SafePower(pairASTNode.e1, aSTNode), new SafePower(pairASTNode.e1, aSTNode2)));
        pairASTNode2.e1 = new Min((ASTNode)new SafePower(pairASTNode.e1, aSTNode3), new Min((ASTNode)new SafePower(pairASTNode.e1, aSTNode), new SafePower(pairASTNode.e1, aSTNode2)));
        pairASTNode2.e2 = new Max(pairASTNode2.e2, NumberConstant.make(0L));
        pairASTNode2.e1 = new Min(pairASTNode2.e1, NumberConstant.make(0L));
        pairASTNode2.e2 = new Max(pairASTNode2.e2, NumberConstant.make(1L));
        pairASTNode2.e1 = new Min(pairASTNode2.e1, NumberConstant.make(1L));
        return pairASTNode2;
    }

    @Override
    public void toMinionWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        bufferedWriter.append("pow(");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        aSTNode.toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("Pow(");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(",");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("pow(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        aSTNode.toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + "**" + this.getChild(1) + ")";
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        assert (!bl);
        stringBuilder.append("pow(");
        this.getChild(0).toMinizinc(stringBuilder, bl);
        stringBuilder.append(",");
        this.getChild(1).toMinizinc(stringBuilder, bl);
        stringBuilder.append(")");
    }

    @Override
    public void toSATWithAuxVar(Sat sat, ASTNode aSTNode) throws IOException {
        sat.ternaryEncoding(this, aSTNode);
    }

    @Override
    public boolean test(long l, long l2, long l3) {
        return this.func(l, l2) == l3;
    }

    @Override
    public long func(long l, long l2) {
        if (l == 0L && l2 == 0L || l2 < 0L) {
            return 0L;
        }
        return Power.pow(l, l2);
    }
}

