/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.math.BigInteger;
import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.BinOp;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.model.Sat;

public class ShiftMapper
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public ShiftMapper(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new ShiftMapper(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp();
    }

    @Override
    public ASTNode simplify() {
        assert (this.getChild(0).getCategory() <= 3 || this.getChild(0).getCategory() == 20);
        assert (this.getChild(1).getCategory() <= 2 || this.getChild(1).getCategory() == 20);
        if (this.getChild(0).isConstant()) {
            this.detachChildren();
            return BinOp.makeBinOp("+", this.getChild(0), this.getChild(1));
        }
        if (this.getChild(1).equals(NumberConstant.make(0L))) {
            this.getChild(0).setParent(null);
            return this.getChild(0);
        }
        if (this.getChild(0) instanceof ShiftMapper) {
            this.getChild(0).detachChildren();
            this.getChild(1).setParent(null);
            ASTNode aSTNode = BinOp.makeBinOp("+", this.getChild(1), this.getChild(0).getChild(1));
            return new ShiftMapper(this.getChild(0).getChild(0), aSTNode);
        }
        return null;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        intpair.lower = Intpair.BigIntegerToLong(BigInteger.valueOf(intpair.lower).add(BigInteger.valueOf(intpair2.lower)));
        intpair.upper = Intpair.BigIntegerToLong(BigInteger.valueOf(intpair.upper).add(BigInteger.valueOf(intpair2.upper)));
        return intpair;
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(0).getBoundsAST();
        pairASTNode.e1 = BinOp.makeBinOp("+", pairASTNode.e1, this.getChild(1));
        pairASTNode.e2 = BinOp.makeBinOp("+", pairASTNode.e2, this.getChild(1));
        return pairASTNode;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
        long l = this.getChild(1).getValue();
        return Intpair.shiftIntervalSet(arrayList, l);
    }

    @Override
    public String toString() {
        return "shift(" + this.getChild(0) + ", " + this.getChild(1) + ")";
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("shift(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public long directEncode(Sat sat, long l) {
        return this.getChild(0).directEncode(sat, l - this.getChild(1).getValue());
    }

    @Override
    public long orderEncode(Sat sat, long l) {
        return this.getChild(0).orderEncode(sat, l - this.getChild(1).getValue());
    }
}

