/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.BooleanConstant;
import savilerow.expression.BooleanDomainFull;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Identifier;
import savilerow.expression.IntegerDomain;
import savilerow.expression.NumberConstant;
import savilerow.expression.Range;
import savilerow.expression.SATLiteral;
import savilerow.model.Model;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class TableShort
extends ASTNodeC {
    public static final long serialVersionUID = 1L;
    protected transient Model m;
    static long shorttablecount = 1L;

    public TableShort(Model model, ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
        this.m = model;
    }

    @Override
    public boolean hasModel() {
        return true;
    }

    @Override
    public Model getModel() {
        return this.m;
    }

    @Override
    public void setModel(Model model) {
        this.m = model;
    }

    @Override
    public ASTNode copy() {
        return new TableShort(this.m, this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp();
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (!this.getChild(1).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: First argument of tableshort should be 1-dimensional matrix: " + this);
            return false;
        }
        if (this.getChild(1).getDimension() != 3) {
            CmdFlags.println("ERROR: Second argument of tableshort should be 3-dimensional matrix: " + this);
            return false;
        }
        if (this.getChild(1).getCategory() > 2) {
            CmdFlags.println("ERROR: Second argument of tableshort cannot contain decision variables: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        if ((aSTNode instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix) && this.getChild(1).getCategory() == 0) {
            ASTNode aSTNode2 = this.getChildConst(1);
            if (this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix) {
                if (aSTNode2 instanceof EmptyMatrix) {
                    return new BooleanConstant(false);
                }
                if (aSTNode2.getChild(1) instanceof EmptyMatrix) {
                    return new BooleanConstant(true);
                }
                ASTNode aSTNode3 = this.m.cmstore.newConstantMatrixDedup(aSTNode2);
                this.getChild(0).setParent(null);
                return new TableShort(this.m, this.getChild(0), aSTNode3);
            }
            if (aSTNode2 instanceof CompoundMatrix || aSTNode2 instanceof EmptyMatrix) {
                if (aSTNode2 instanceof EmptyMatrix) {
                    return new BooleanConstant(false);
                }
                if (aSTNode2.getChild(1) instanceof EmptyMatrix) {
                    return new BooleanConstant(true);
                }
                if (aSTNode instanceof EmptyMatrix) {
                    return new BooleanConstant(true);
                }
                ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
                int[] nArray = new int[arrayList.size()];
                int n = 1;
                boolean bl = true;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (arrayList.get(i).isConstant()) {
                        nArray[i] = -1;
                        continue;
                    }
                    nArray[i] = n++;
                    bl = false;
                }
                if (nArray[arrayList.size() - 1] != arrayList.size()) {
                    int n2;
                    HashSet<ASTNode> hashSet = new HashSet<ASTNode>();
                    for (n2 = 1; n2 < aSTNode2.numChildren(); ++n2) {
                        ASTNode aSTNode4 = aSTNode2.getChild(n2);
                        boolean bl2 = true;
                        ArrayList<ASTNode> arrayList2 = TableShort.list();
                        for (int i = 1; i < aSTNode4.numChildren(); ++i) {
                            int n3 = (int)aSTNode4.getChild(i).getChild(1).getValue();
                            long l = aSTNode4.getChild(i).getChild(2).getValue();
                            if (nArray[n3 - 1] == -1) {
                                if (l == arrayList.get(n3 - 1).getValue()) continue;
                                bl2 = false;
                                break;
                            }
                            ASTNode aSTNode5 = CompoundMatrix.make(NumberConstant.make(nArray[n3 - 1]), aSTNode4.getChild(i).getChild(2));
                            arrayList2.add(aSTNode5);
                        }
                        if (!bl2) continue;
                        if (arrayList2.size() == 0) {
                            return new BooleanConstant(true);
                        }
                        hashSet.add(CompoundMatrix.make(arrayList2));
                    }
                    for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                        if (!arrayList.get(n2).isConstant()) continue;
                        assert (nArray[n2] == -1);
                        arrayList.remove(n2);
                    }
                    ASTNode aSTNode6 = CompoundMatrix.make(new ArrayList<ASTNode>(hashSet));
                    aSTNode6 = this.m.cmstore.newConstantMatrixDedup(aSTNode6);
                    if (aSTNode == this.getChild(0)) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            arrayList.get(i).setParent(null);
                        }
                    }
                    return new TableShort(this.m, CompoundMatrix.make(arrayList), aSTNode6);
                }
            }
        }
        return null;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        if (this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix) {
            ASTNode aSTNode = this.getChild(1);
            bufferedWriter.append("**SHORTTUPLELIST**\n");
            bufferedWriter.append("tableshort");
            bufferedWriter.append(String.valueOf(shorttablecount));
            bufferedWriter.append(" ");
            bufferedWriter.append(String.valueOf(aSTNode.numChildren() - 1));
            bufferedWriter.append("\n");
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                bufferedWriter.append("[");
                ASTNode aSTNode2 = aSTNode.getChild(i);
                for (int j = 1; j < aSTNode.getChild(i).numChildren(); ++j) {
                    long l = aSTNode2.getChild(j).getChild(1).getValue();
                    long l2 = aSTNode2.getChild(j).getChild(2).getValue();
                    bufferedWriter.append("(");
                    bufferedWriter.append(String.valueOf(l - 1L));
                    bufferedWriter.append(",");
                    bufferedWriter.append(String.valueOf(l2));
                    bufferedWriter.append("),");
                }
                bufferedWriter.append("]\n");
            }
            bufferedWriter.append("**CONSTRAINTS**\n");
            bufferedWriter.append("shortstr2(");
            this.getChild(0).toMinion(bufferedWriter, false);
            bufferedWriter.append(", tableshort");
            bufferedWriter.append(String.valueOf(shorttablecount));
            bufferedWriter.append(")");
            ++shorttablecount;
        } else {
            bufferedWriter.append("shortstr2(");
            this.getChild(0).toMinion(bufferedWriter, false);
            bufferedWriter.append(", ");
            this.getChild(1).toMinion(bufferedWriter, false);
            bufferedWriter.append(")");
        }
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        this.toSATHelper2(sat);
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        this.toSATHelper(sat, l);
    }

    public void toSATHelper(Sat sat, long l) throws IOException {
        ASTNode aSTNode = this.getChildConst(1);
        ArrayList<Long> arrayList = new ArrayList<Long>(aSTNode.numChildren());
        for (int i = 1; i < aSTNode.numChildren(); ++i) {
            ASTNode aSTNode2 = aSTNode.getChild(i);
            long l2 = sat.createAuxSATVariable();
            ArrayList<Long> arrayList2 = new ArrayList<Long>(aSTNode2.numChildren() - 1);
            for (int j = 1; j < aSTNode2.numChildren(); ++j) {
                long l3 = aSTNode2.getChild(j).getChild(1).getValue();
                long l4 = aSTNode2.getChild(j).getChild(2).getValue();
                long l5 = this.getChild(0).getChild((int)l3).directEncode(sat, l4);
                arrayList2.add(-l5);
            }
            sat.addClauseReified(arrayList2, -l2);
            arrayList.add(l2);
        }
        sat.addClauseReified(arrayList, l);
    }

    public void toSATHelper2(Sat sat) throws IOException {
        ArrayList<Object> arrayList;
        int n;
        Serializable serializable;
        ASTNode aSTNode = this.getChildConst(1);
        int n2 = this.getChild(0).numChildren() - 1;
        ArrayList<ASTNode> arrayList2 = aSTNode.getChildren();
        ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
        for (int i = 1; i <= n2; ++i) {
            ASTNode aSTNode2 = this.getChild(0).getChild(i);
            if (aSTNode2 instanceof Identifier) {
                arrayList3.add(((Identifier)aSTNode2).getDomain());
                continue;
            }
            if (aSTNode2.isConstant()) {
                arrayList3.add(new IntegerDomain(new Range(aSTNode2, aSTNode2)));
                continue;
            }
            if (aSTNode2 instanceof SATLiteral) {
                arrayList3.add(new BooleanDomainFull());
                continue;
            }
            assert (false) : "Unknown type contained in tableshort constraint:" + aSTNode2;
        }
        ArrayList<Long> arrayList4 = new ArrayList<Long>(arrayList2.size());
        for (int i = 1; i < arrayList2.size(); ++i) {
            boolean bl = true;
            serializable = arrayList2.get(i);
            n = ((ASTNode)serializable).numChildren();
            for (int j = 1; j < n; ++j) {
                long l = ((ASTNode)serializable).getChild(j).getChild(1).getValue() - 1L;
                long l2 = ((ASTNode)serializable).getChild(j).getChild(2).getValue();
                if (((ASTNode)arrayList3.get((int)l)).containsValue(l2)) continue;
                bl = false;
                break;
            }
            if (!bl) {
                arrayList2.set(i, arrayList2.get(arrayList2.size() - 1));
                arrayList2.remove(arrayList2.size() - 1);
                --i;
                continue;
            }
            long l = sat.createAuxSATVariable();
            arrayList4.add(l);
            if (!CmdFlags.short_tab_sat_extra) continue;
            arrayList = new ArrayList(arrayList2.get(i).numChildren() - 1);
            for (int j = 1; j < ((ASTNode)serializable).numChildren(); ++j) {
                ASTNode aSTNode3 = ((ASTNode)serializable).getChild(j);
                arrayList.add(-this.getChild(0).getChild((int)aSTNode3.getChild(1).getValue()).directEncode(sat, aSTNode3.getChild(2).getValue()));
            }
            sat.addClauseReified(arrayList, -l);
        }
        ArrayList<ArrayList<Long>> arrayList5 = new ArrayList<ArrayList<Long>>(n2);
        ArrayList arrayList6 = new ArrayList(n2);
        serializable = new ArrayList(n2);
        for (n = 1; n <= n2; ++n) {
            ASTNode aSTNode4 = this.getChild(0).getChild(n);
            arrayList5.add(((ASTNode)arrayList3.get(n - 1)).getValueSet());
            arrayList6.add(new ArrayList());
            ((ArrayList)serializable).add(new ArrayList(((ArrayList)arrayList5.get(n - 1)).size()));
            for (int i = 0; i < ((ArrayList)arrayList5.get(n - 1)).size(); ++i) {
                ((ArrayList)((ArrayList)serializable).get(n - 1)).add(new ArrayList());
            }
        }
        for (n = 1; n < arrayList2.size(); ++n) {
            int n3;
            ASTNode aSTNode5 = arrayList2.get(n);
            int n4 = aSTNode5.numChildren();
            arrayList = new ArrayList<Boolean>(Collections.nCopies(n2, false));
            for (n3 = 1; n3 < n4; ++n3) {
                int n5 = (int)(aSTNode5.getChild(n3).getChild(1).getValue() - 1L);
                long l = aSTNode5.getChild(n3).getChild(2).getValue();
                assert (!((Boolean)((Object)arrayList.get(n5))).booleanValue());
                arrayList.set(n5, (Long)((Object)Boolean.valueOf(true)));
                int n6 = Collections.binarySearch((List)arrayList5.get(n5), l);
                assert ((Long)((ArrayList)arrayList5.get(n5)).get(n6) == l);
                ((ArrayList)((ArrayList)((ArrayList)serializable).get(n5)).get(n6)).add(arrayList4.get(n - 1));
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (((Boolean)((Object)arrayList.get(n3))).booleanValue()) continue;
                ((ArrayList)arrayList6.get(n3)).add(arrayList4.get(n - 1));
            }
        }
        for (n = 0; n < n2; ++n) {
            ASTNode aSTNode6 = this.getChild(0).getChild(n + 1);
            for (int i = 0; i < ((ArrayList)arrayList5.get(n)).size(); ++i) {
                int n7;
                if (!CmdFlags.short_tab_sat_extra) {
                    for (int j = 0; j < ((ArrayList)((ArrayList)((ArrayList)serializable).get(n)).get(i)).size(); ++j) {
                        long l = aSTNode6.directEncode(sat, (Long)((ArrayList)arrayList5.get(n)).get(i));
                        sat.addClause(l, -((Long)((ArrayList)((ArrayList)((ArrayList)serializable).get(n)).get(i)).get(j)).longValue());
                    }
                }
                arrayList = new ArrayList(1 + ((ArrayList)((ArrayList)((ArrayList)serializable).get(n)).get(i)).size() + ((ArrayList)arrayList6.get(n)).size());
                arrayList.add(-aSTNode6.directEncode(sat, (Long)((ArrayList)arrayList5.get(n)).get(i)));
                for (n7 = 0; n7 < ((ArrayList)((ArrayList)((ArrayList)serializable).get(n)).get(i)).size(); ++n7) {
                    arrayList.add(((ArrayList)((ArrayList)((ArrayList)serializable).get(n)).get(i)).get(n7));
                }
                for (n7 = 0; n7 < ((ArrayList)arrayList6.get(n)).size(); ++n7) {
                    arrayList.add(((ArrayList)arrayList6.get(n)).get(n7));
                }
                sat.addClause(arrayList);
            }
        }
        sat.addClause(arrayList4);
    }

    public ArrayList<ASTNode> getVariables(ASTNode aSTNode) {
        HashSet<ASTNode> hashSet = new HashSet<ASTNode>();
        this.getVariablesInner(aSTNode, hashSet);
        return new ArrayList<ASTNode>(hashSet);
    }

    private void getVariablesInner(ASTNode aSTNode, HashSet<ASTNode> hashSet) {
        if (aSTNode instanceof Identifier && aSTNode.getCategory() > 0) {
            hashSet.add(aSTNode);
        } else {
            for (int i = 0; i < aSTNode.numChildren(); ++i) {
                this.getVariablesInner(aSTNode.getChild(i), hashSet);
            }
        }
    }

    @Override
    public String toString() {
        return "tableshort(" + this.getChild(0) + ", " + this.getChild(1) + ")";
    }
}

