/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Element;
import savilerow.expression.ElementOne;
import savilerow.expression.Equals;
import savilerow.expression.Identifier;
import savilerow.expression.Iff;
import savilerow.expression.Intpair;
import savilerow.expression.Negate;
import savilerow.expression.NumberConstant;
import savilerow.expression.Or;
import savilerow.expression.SATLiteral;
import savilerow.expression.SafeElement;
import savilerow.model.Sat;

public class ToVariable
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public ToVariable(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new ToVariable(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp() && this.getChild(1).strongProp();
    }

    @Override
    public String toString() {
        if (this.getChild(0).isRelation()) {
            return "(" + this.getChild(0) + "<-tv>" + this.getChild(1) + ")";
        }
        return "(" + this.getChild(0) + "=tv=" + this.getChild(1) + ")";
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof BooleanConstant || this.getChild(0) instanceof Identifier && this.getChild(0).isRelation()) {
            this.detachChildren();
            if (this.getChild(1).isRelation()) {
                return new Iff(this.getChild(0), this.getChild(1));
            }
            return new Equals(this.getChild(0), this.getChild(1));
        }
        if (this.getChild(0) instanceof NumberConstant || this.getChild(0) instanceof Identifier && this.getChild(0).isNumerical()) {
            this.detachChildren();
            return new Equals(this.getChild(0), this.getChild(1));
        }
        if (this.getChild(0).equals(this.getChild(1))) {
            return new BooleanConstant(true);
        }
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            return new BooleanConstant(this.getChild(0).getValue() == this.getChild(1).getValue());
        }
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        if (intpair.lower > intpair2.upper) {
            return new BooleanConstant(false);
        }
        if (intpair.upper < intpair2.lower) {
            return new BooleanConstant(false);
        }
        if (CmdFlags.getMiniontrans()) {
            // empty if block
        }
        return null;
    }

    @Override
    public boolean isNegatable() {
        return this.getChild(1).isRelation();
    }

    @Override
    public ASTNode negation() {
        return new ToVariable(this.getChild(0), new Negate(this.getChild(1)));
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        if (this.getChild(0).isRelation() && !(this.getChild(0) instanceof SafeElement) && !(this.getChild(0) instanceof Element) && !(this.getChild(0) instanceof ElementOne)) {
            bufferedWriter.append("reify(");
            this.getChild(0).toMinion(bufferedWriter, true);
            bufferedWriter.append(", ");
            this.getChild(1).toMinion(bufferedWriter, false);
            bufferedWriter.append(")");
        } else {
            this.getChild(0).toMinionWithAuxVar(bufferedWriter, this.getChild(1));
        }
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        if (this.getChild(0).isRelation()) {
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append("reify(");
            this.getChild(0).toDominion(stringBuilder, true);
            stringBuilder.append(", ");
            this.getChild(1).toDominion(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            this.getChild(0).toDominionWithAuxVar(stringBuilder, this.getChild(1));
        }
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (this.getChild(0).isRelation() && !(this.getChild(0) instanceof ElementOne)) {
            if (this.getChild(0) instanceof And || this.getChild(0) instanceof Or) {
                this.getChild(0).toFlatzincWithAuxVar(bufferedWriter, this.getChild(1));
            } else {
                StringWriter stringWriter = new StringWriter();
                BufferedWriter bufferedWriter2 = new BufferedWriter(stringWriter);
                this.getChild(0).toFlatzinc(bufferedWriter2, true);
                bufferedWriter2.flush();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(stringWriter.toString());
                StringWriter stringWriter2 = new StringWriter();
                BufferedWriter bufferedWriter3 = new BufferedWriter(stringWriter2);
                this.getChild(1).toFlatzinc(bufferedWriter3, true);
                bufferedWriter3.flush();
                int n = stringBuffer.lastIndexOf(");");
                if (n != -1) {
                    stringBuffer.replace(n, n + 2, "," + stringWriter2.toString() + ");");
                } else {
                    n = stringBuffer.lastIndexOf(")::");
                    stringBuffer.replace(n, n + 3, "," + stringWriter2.toString() + ")::");
                }
                int n2 = stringBuffer.indexOf("(");
                stringBuffer.replace(n2, n2 + 1, "_reif(");
                bufferedWriter.append(stringBuffer);
            }
        } else {
            this.getChild(0).toFlatzincWithAuxVar(bufferedWriter, this.getChild(1));
        }
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("( ");
        if (this.getChild(0).isRelation()) {
            this.getChild(0).toMinizinc(stringBuilder, true);
            stringBuilder.append(" <-> ");
            this.getChild(1).toMinizinc(stringBuilder, true);
        } else {
            this.getChild(0).toMinizinc(stringBuilder, false);
            stringBuilder.append(" == ");
            this.getChild(1).toMinizinc(stringBuilder, false);
        }
        if (this.getChild(1) instanceof Identifier && ((Identifier)this.getChild(1)).isAuxiliary()) {
            stringBuilder.append(":: defines_var(");
            this.getChild(1).toMinizinc(stringBuilder, this.getChild(0).isRelation());
            stringBuilder.append(")");
        }
        stringBuilder.append(" )");
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        if (this.getChild(0).isConstant()) {
            return this.getChild(1).directEncode(sat, this.getChild(0).getValue());
        }
        if (this.getChild(1).isConstant() && (this.getChild(0) instanceof SATLiteral || this.getChild(0) instanceof Identifier)) {
            return this.getChild(0).directEncode(sat, this.getChild(1).getValue());
        }
        return null;
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        if (this.getChild(0).isRelation() && !(this.getChild(0) instanceof SafeElement) && !(this.getChild(0) instanceof Element)) {
            if (this.getChild(1) instanceof BooleanConstant) {
                if (this.getChild(1).getValue() == 1L) {
                    this.getChild(0).toSAT(sat);
                } else {
                    assert (this.getChild(1).getValue() == 0L);
                    new Negate(this.getChild(0)).toSAT(sat);
                }
            } else {
                this.getChild(0).toSATWithAuxVar(sat, this.getChild(1).directEncode(sat, 1L));
                if (!this.getChild(1).isRelation()) {
                    sat.addClause(this.getChild(1).orderEncode(sat, 1L));
                    sat.addClause(-this.getChild(1).orderEncode(sat, -1L));
                }
            }
        } else {
            this.getChild(0).toSATWithAuxVar(sat, this.getChild(1));
        }
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        if (this.getChild(0).isRelation() && !(this.getChild(0) instanceof SafeElement) && !(this.getChild(0) instanceof Element)) {
            long l2;
            long l3 = sat.createAuxSATVariable();
            this.getChild(0).toSATWithAuxVar(sat, l3);
            if (this.getChild(1) instanceof SATLiteral) {
                l2 = ((SATLiteral)this.getChild(1)).getLit();
            } else {
                if (!this.getChild(1).isRelation()) {
                    System.err.println("Weird expression in output: " + this);
                }
                l2 = ((Identifier)this.getChild(1)).directEncode(sat, 1L);
            }
            sat.addClause(-l, -l3, l2);
            sat.addClause(-l, l3, -l2);
            sat.addClause(l, -l3, -l2);
            sat.addClause(l, l3, l2);
        } else {
            CmdFlags.errorExit("Missing part of toSATWithAuxVar(long) method on type ToVariable.");
        }
    }
}

