/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import savilerow.CmdFlags;
import savilerow.Constants;
import savilerow.Pair;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.Divide;
import savilerow.expression.Intpair;
import savilerow.expression.LessEqual;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.Times;
import savilerow.expression.UnaryMinus;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class WeightedSum
extends ASTNodeC {
    public static final long serialVersionUID = 1L;
    long[] weights;

    public WeightedSum(ArrayList<ASTNode> arrayList) {
        super(arrayList);
        this.weights = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.weights[i] = 1L;
        }
    }

    public WeightedSum(ASTNode[] aSTNodeArray) {
        super(aSTNodeArray);
        this.weights = new long[aSTNodeArray.length];
        for (int i = 0; i < aSTNodeArray.length; ++i) {
            this.weights[i] = 1L;
        }
    }

    public WeightedSum(ArrayList<ASTNode> arrayList, ArrayList<Long> arrayList2) {
        super(arrayList);
        this.weights = new long[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            this.weights[i] = arrayList2.get(i);
        }
        assert (arrayList.size() == arrayList2.size());
    }

    public WeightedSum(ASTNode[] aSTNodeArray, long[] lArray) {
        super(aSTNodeArray);
        this.weights = lArray;
        assert (aSTNodeArray.length == lArray.length);
    }

    public WeightedSum(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
        this.weights = new long[2];
        this.weights[0] = 1L;
        this.weights[1] = 1L;
    }

    public WeightedSum(ASTNode aSTNode, ASTNode aSTNode2, long l, long l2) {
        super(aSTNode, aSTNode2);
        this.weights = new long[2];
        this.weights[0] = l;
        this.weights[1] = l2;
    }

    public ArrayList<Long> getWeights() {
        ArrayList<Long> arrayList = new ArrayList<Long>(this.weights.length);
        for (int i = 0; i < this.weights.length; ++i) {
            arrayList.add(this.weights[i]);
        }
        return arrayList;
    }

    public long[] getWeightsArray() {
        long[] lArray = new long[this.weights.length];
        System.arraycopy(this.weights, 0, lArray, 0, this.weights.length);
        return lArray;
    }

    public long getWeight(int n) {
        return this.weights[n];
    }

    @Override
    public ASTNode copy() {
        long[] lArray = new long[this.weights.length];
        for (int i = 0; i < this.weights.length; ++i) {
            lArray[i] = this.weights[i];
        }
        return new WeightedSum(this.getChildrenArray(), lArray);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof WeightedSum)) {
            return false;
        }
        WeightedSum weightedSum = (WeightedSum)object;
        if (!weightedSum.getChildren().equals(this.getChildren())) {
            return false;
        }
        return Arrays.equals(weightedSum.weights, this.weights);
    }

    @Override
    public int hashCode() {
        if (this.hashCache == Integer.MIN_VALUE) {
            int n = Arrays.hashCode(this.weights);
            this.hashCache = n = n * 13 + Arrays.hashCode(this.getChildrenArray());
            return n;
        }
        return this.hashCache;
    }

    @Override
    public ASTNode simplify() {
        int n;
        int n2;
        int n3;
        int n4;
        ArrayList<ASTNode> arrayList = this.getChildren();
        ArrayList<Long> arrayList2 = this.getWeights();
        boolean bl = false;
        assert (arrayList.size() == arrayList2.size());
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            if (arrayList.get(n4) instanceof WeightedSum) {
                ASTNode aSTNode = arrayList.remove(n4);
                long l = arrayList2.remove(n4);
                --n4;
                arrayList.addAll(aSTNode.getChildren());
                ArrayList<Long> arrayList3 = ((WeightedSum)aSTNode).getWeights();
                for (int i = 0; i < arrayList3.size(); ++i) {
                    arrayList2.add(arrayList3.get(i) * l);
                }
                bl = true;
                continue;
            }
            if (!(arrayList.get(n4) instanceof UnaryMinus)) continue;
            bl = true;
            arrayList.set(n4, arrayList.get(n4).getChild(0));
            arrayList2.set(n4, -arrayList2.get(n4).longValue());
        }
        assert (arrayList.size() == arrayList2.size());
        n4 = 0;
        int n5 = -1;
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            if (!arrayList.get(n3).isConstant()) continue;
            if (arrayList.get(n3).getValue() * arrayList2.get(n3) == 0L) {
                arrayList.remove(n3);
                arrayList2.remove(n3);
                --n3;
                bl = true;
                continue;
            }
            n5 = n3;
            ++n4;
        }
        if (n4 > 0) {
            if (n4 == 1) {
                if (arrayList2.get(n5) != 1L) {
                    arrayList.set(n5, NumberConstant.make(arrayList.get(n5).getValue() * arrayList2.get(n5)));
                    arrayList2.set(n5, 1L);
                    bl = true;
                }
            } else {
                n3 = 0;
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    if (!arrayList.get(n2).isConstant()) continue;
                    n3 = (int)((long)n3 + arrayList.get(n2).getValue() * arrayList2.get(n2));
                    arrayList.remove(n2);
                    arrayList2.remove(n2);
                    --n2;
                }
                if (arrayList.size() == 0) {
                    return NumberConstant.make(n3);
                }
                if (n3 != 0) {
                    arrayList.add(NumberConstant.make(n3));
                    arrayList2.add(1L);
                    bl = true;
                }
            }
        }
        n3 = 1;
        for (n2 = 0; n2 < arrayList.size() - 1; ++n2) {
            if (arrayList.get(n2).hashCode() <= arrayList.get(n2 + 1).hashCode()) continue;
            n3 = 0;
            break;
        }
        if (n3 == 0) {
            int n6;
            Object[] objectArray = new ASTLongPair[arrayList.size()];
            for (n6 = 0; n6 < arrayList.size(); ++n6) {
                objectArray[n6] = new ASTLongPair(arrayList2.get(n6), arrayList.get(n6));
            }
            Arrays.sort(objectArray);
            for (n6 = 0; n6 < arrayList.size(); ++n6) {
                arrayList.set(n6, ((ASTLongPair)objectArray[n6]).ch);
                arrayList2.set(n6, ((ASTLongPair)objectArray[n6]).wt);
            }
            bl = true;
        }
        for (n = 0; n < arrayList.size() - 1; ++n) {
            if (!arrayList.get(n).equals(arrayList.get(n + 1))) continue;
            bl = true;
            arrayList.remove(n + 1);
            arrayList2.set(n, arrayList2.get(n) + arrayList2.remove(n + 1));
            --n;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (arrayList2.get(n) != 0L) continue;
            bl = true;
            arrayList2.remove(n);
            arrayList.remove(n);
            --n;
        }
        if (arrayList.size() == 0) {
            return NumberConstant.make(0L);
        }
        if (arrayList.size() == 1 && arrayList2.get(0) == 1L) {
            return arrayList.get(0);
        }
        if (arrayList.size() == 1 && arrayList2.get(0) == -1L) {
            return new UnaryMinus(arrayList.get(0));
        }
        if (bl) {
            for (n = 0; n < arrayList.size(); ++n) {
                arrayList.get(n).setParent(null);
            }
            return new WeightedSum(arrayList, arrayList2);
        }
        return null;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!this.getChild(i).typecheck(symbolTable)) {
                return false;
            }
            if (this.getChild(i).getDimension() <= 0) continue;
            CmdFlags.println("ERROR: Unexpected matrix in weighted sum: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode normalise() {
        boolean bl = true;
        for (int i = 0; i < this.numChildren() - 1; ++i) {
            if (this.getChild(i).hashCode() <= this.getChild(i + 1).hashCode()) continue;
            bl = false;
            break;
        }
        if (!bl) {
            int n;
            Object[] objectArray = new ASTLongPair[this.numChildren()];
            for (n = 0; n < this.numChildren(); ++n) {
                objectArray[n] = new ASTLongPair(this.weights[n], this.getChild(n));
            }
            Arrays.sort(objectArray);
            for (n = 0; n < this.numChildren(); ++n) {
                ((ASTLongPair)objectArray[n]).ch.setParent(null);
                this.setChild(n, ((ASTLongPair)objectArray[n]).ch);
                this.weights[n] = ((ASTLongPair)objectArray[n]).wt;
            }
        }
        return this;
    }

    @Override
    public ASTNode normaliseAlpha() {
        boolean bl = true;
        for (int i = 0; i < this.numChildren() - 1; ++i) {
            if (this.getChild(i).toString().compareTo(this.getChild(i + 1).toString()) <= 0) continue;
            bl = false;
            break;
        }
        if (!bl) {
            int n;
            Object[] objectArray = new ASTLongPairAlpha[this.numChildren()];
            for (n = 0; n < this.numChildren(); ++n) {
                objectArray[n] = new ASTLongPairAlpha(this.weights[n], this.getChild(n));
            }
            Arrays.sort(objectArray);
            for (n = 0; n < this.numChildren(); ++n) {
                ((ASTLongPairAlpha)objectArray[n]).ch.setParent(null);
                this.setChild(n, ((ASTLongPairAlpha)objectArray[n]).ch);
                this.weights[n] = ((ASTLongPairAlpha)objectArray[n]).wt;
            }
        }
        return null;
    }

    public boolean isCommutative() {
        return true;
    }

    public boolean isAssociative() {
        return true;
    }

    @Override
    public String toString() {
        String string = "(";
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).isConstant()) {
                long l = this.weights[i] * this.getChild(i).getValue();
                if (l >= 0L && i > 0) {
                    string = string + " + ";
                }
                string = string + l;
                continue;
            }
            if (this.weights[i] >= 0L && i > 0) {
                string = string + " + ";
            }
            if (this.weights[i] != 1L) {
                string = string + this.weights[i] + "*";
            }
            string = string + this.getChild(i);
        }
        string = string + ")";
        return string;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return !(this.getParent() instanceof LessEqual);
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public Intpair getBounds() {
        BigInteger bigInteger = BigInteger.valueOf(0L);
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        for (int i = 0; i < this.weights.length; ++i) {
            Intpair intpair = this.getChild(i).getBounds();
            if (this.weights[i] > 0L) {
                bigInteger = bigInteger.add(BigInteger.valueOf(intpair.lower).multiply(BigInteger.valueOf(this.weights[i])));
                bigInteger2 = bigInteger2.add(BigInteger.valueOf(intpair.upper).multiply(BigInteger.valueOf(this.weights[i])));
                continue;
            }
            bigInteger = bigInteger.add(BigInteger.valueOf(intpair.upper).multiply(BigInteger.valueOf(this.weights[i])));
            bigInteger2 = bigInteger2.add(BigInteger.valueOf(intpair.lower).multiply(BigInteger.valueOf(this.weights[i])));
        }
        return this.lookupBounds(new Intpair(Intpair.BigIntegerToLong(bigInteger), Intpair.BigIntegerToLong(bigInteger2)));
    }

    @Override
    public PairASTNode getBoundsAST() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        for (int i = 0; i < this.weights.length; ++i) {
            PairASTNode pairASTNode = this.getChild(i).getBoundsAST();
            if (this.weights[i] > 0L) {
                arrayList.add(pairASTNode.e1);
                arrayList2.add(pairASTNode.e2);
                continue;
            }
            arrayList.add(pairASTNode.e2);
            arrayList2.add(pairASTNode.e1);
        }
        return new PairASTNode(new WeightedSum(arrayList, this.getWeights()), new WeightedSum(arrayList2, this.getWeights()));
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = new ArrayList<Intpair>();
        arrayList.add(new Intpair(0L, 0L));
        for (int i = 0; i < this.weights.length; ++i) {
            ArrayList<Intpair> arrayList2 = this.getChild(i).getIntervalSetExp();
            arrayList2 = (this.weights[i] > 1L || this.weights[i] < -1L) && Intpair.numValues(arrayList2) > (long)Constants.intervallim ? Intpair.scaleIntervalSet(arrayList2, this.weights[i]) : Intpair.multIntervalSet(arrayList2, this.weights[i]);
            ArrayList<Intpair> arrayList3 = new ArrayList<Intpair>();
            for (int j = 0; j < arrayList.size(); ++j) {
                for (int k = 0; k < arrayList2.size(); ++k) {
                    long l = arrayList.get((int)j).lower + arrayList2.get((int)k).lower;
                    long l2 = arrayList.get((int)j).upper + arrayList2.get((int)k).upper;
                    arrayList3.add(new Intpair(l, l2));
                }
            }
            Intpair.normalise(arrayList3);
            arrayList = arrayList3;
        }
        return arrayList;
    }

    @Override
    public long getValue() {
        long l = 0L;
        for (int i = 0; i < this.numChildren(); ++i) {
            assert (this.getChild(i).isConstant());
            l += this.getChild(i).getValue() * this.weights[i];
        }
        return l;
    }

    public Pair<ASTNode, ASTNode> retrieveConstant() {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!(this.getChild(i) instanceof NumberConstant)) continue;
            ArrayList<ASTNode> arrayList = this.getChildren();
            ArrayList<Long> arrayList2 = this.getWeights();
            ASTNode aSTNode = arrayList.remove(i);
            Long l = arrayList2.remove(i);
            aSTNode = NumberConstant.make(aSTNode.getValue() * l);
            return new Pair<ASTNode, ASTNode>(aSTNode, new WeightedSum(arrayList, arrayList2));
        }
        return null;
    }

    public Pair<ASTNode, ASTNode> factorOutGCD() {
        Object object;
        long l;
        boolean bl = false;
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.weights[i] != 1L && this.weights[i] != -1L) continue;
            bl = true;
            break;
        }
        if (bl) {
            l = 1L;
        } else {
            object = BigInteger.valueOf(this.weights[0]);
            for (int i = 1; i < this.numChildren(); ++i) {
                object = ((BigInteger)object).gcd(BigInteger.valueOf(this.weights[i]));
            }
            l = ((BigInteger)object).longValue();
        }
        if (l > 1L) {
            object = new long[this.weights.length];
            ASTNode[] aSTNodeArray = new ASTNode[this.weights.length];
            for (int i = 0; i < this.numChildren(); ++i) {
                object[i] = this.weights[i] / l;
                aSTNodeArray[i] = this.getChild(i);
            }
            return new Pair<ASTNode, ASTNode>(NumberConstant.make(l), new WeightedSum(aSTNodeArray, (long[])object));
        }
        return null;
    }

    public void toMinionLeq(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        int n;
        boolean bl = true;
        for (n = 0; n < this.weights.length; ++n) {
            if (this.weights[n] == 1L) continue;
            bl = false;
            break;
        }
        if (bl) {
            bufferedWriter.append("sumleq([");
            for (n = 0; n < this.numChildren(); ++n) {
                this.getChild(n).toMinion(bufferedWriter, false);
                if (n >= this.numChildren() - 1) continue;
                bufferedWriter.append(",");
            }
            bufferedWriter.append("],");
            aSTNode.toMinion(bufferedWriter, false);
            bufferedWriter.append(")");
        } else {
            bufferedWriter.append("weightedsumleq([");
            for (n = 0; n < this.weights.length; ++n) {
                bufferedWriter.append(String.valueOf(this.weights[n]));
                if (n >= this.weights.length - 1) continue;
                bufferedWriter.append(",");
            }
            bufferedWriter.append("],[");
            for (n = 0; n < this.numChildren(); ++n) {
                this.getChild(n).toMinion(bufferedWriter, false);
                if (n >= this.numChildren() - 1) continue;
                bufferedWriter.append(",");
            }
            bufferedWriter.append("],");
            aSTNode.toMinion(bufferedWriter, false);
            bufferedWriter.append(")");
        }
    }

    public void toMinionGeq(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        int n;
        boolean bl = true;
        for (n = 0; n < this.weights.length; ++n) {
            if (this.weights[n] == 1L) continue;
            bl = false;
            break;
        }
        if (bl) {
            bufferedWriter.append("sumgeq([");
            for (n = 0; n < this.numChildren(); ++n) {
                this.getChild(n).toMinion(bufferedWriter, false);
                if (n >= this.numChildren() - 1) continue;
                bufferedWriter.append(",");
            }
            bufferedWriter.append("],");
            aSTNode.toMinion(bufferedWriter, false);
            bufferedWriter.append(")");
        } else {
            bufferedWriter.append("weightedsumgeq([");
            for (n = 0; n < this.weights.length; ++n) {
                bufferedWriter.append(String.valueOf(this.weights[n]));
                if (n >= this.weights.length - 1) continue;
                bufferedWriter.append(",");
            }
            bufferedWriter.append("],[");
            for (n = 0; n < this.numChildren(); ++n) {
                this.getChild(n).toMinion(bufferedWriter, false);
                if (n >= this.numChildren() - 1) continue;
                bufferedWriter.append(",");
            }
            bufferedWriter.append("],");
            aSTNode.toMinion(bufferedWriter, false);
            bufferedWriter.append(")");
        }
    }

    public boolean isAll1Weights() {
        boolean bl = true;
        for (int i = 0; i < this.weights.length; ++i) {
            if (this.weights[i] == 1L) continue;
            bl = false;
            break;
        }
        return bl;
    }

    String mappertype() {
        boolean bl = true;
        boolean bl2 = true;
        for (int i = 0; i < this.weights.length; ++i) {
            long l = this.weights[i];
            if (l != -1L && l != 1L) {
                bl2 = false;
            }
            if (l >= 0L) continue;
            bl = false;
        }
        if (bl2) {
            return "signmult";
        }
        if (bl) {
            return "posmult";
        }
        return "mult";
    }

    public void toDominionLeq(StringBuilder stringBuilder, ASTNode aSTNode) {
        this.toDominionOp(stringBuilder, aSTNode, "sumleq");
    }

    public void toDominionGeq(StringBuilder stringBuilder, ASTNode aSTNode) {
        this.toDominionOp(stringBuilder, aSTNode, "sumgeq");
    }

    public void toDominionOp(StringBuilder stringBuilder, ASTNode aSTNode, String string) {
        if (this.isAll1Weights()) {
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append(string + "([");
            for (int i = 0; i < this.numChildren(); ++i) {
                this.getChild(i).toDominion(stringBuilder, false);
                if (i >= this.numChildren() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("],");
            aSTNode.toDominion(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            String string2 = this.mappertype();
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append(string + "([");
            for (int i = 0; i < this.weights.length; ++i) {
                stringBuilder.append(string2);
                stringBuilder.append("(");
                this.getChild(i).toDominion(stringBuilder, false);
                stringBuilder.append("," + this.weights[i] + ")");
                if (i >= this.weights.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("],");
            aSTNode.toDominion(stringBuilder, false);
            stringBuilder.append(")");
        }
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        if (this.numChildren() > 1) {
            stringBuilder.append("Sum([");
        }
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.weights[i] != 1L) {
                stringBuilder.append("Product(" + this.weights[i] + ",");
            }
            this.getChild(i).toDominionParam(stringBuilder);
            if (this.weights[i] != 1L) {
                stringBuilder.append(")");
            }
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        if (this.numChildren() > 1) {
            stringBuilder.append("])");
        }
    }

    @Override
    public void toDominionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        if (this.isAll1Weights()) {
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append("sum([");
            for (int i = 0; i < this.numChildren(); ++i) {
                this.getChild(i).toDominion(stringBuilder, false);
                if (i >= this.numChildren() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("],");
            aSTNode.toDominion(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            String string = this.mappertype();
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append("sum([");
            for (int i = 0; i < this.weights.length; ++i) {
                stringBuilder.append(string);
                stringBuilder.append("(");
                this.getChild(i).toDominion(stringBuilder, false);
                stringBuilder.append("," + this.weights[i] + ")");
                if (i >= this.weights.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("],");
            aSTNode.toDominion(stringBuilder, false);
            stringBuilder.append(")");
        }
    }

    public void toFlatzincLeq(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        int n;
        bufferedWriter.append("constraint int_lin_le([");
        for (n = 0; n < this.weights.length; ++n) {
            bufferedWriter.append(String.valueOf(this.weights[n]));
            bufferedWriter.append(",");
        }
        bufferedWriter.append("-1],[");
        for (n = 0; n < this.numChildren(); ++n) {
            this.getChild(n).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(",");
        }
        aSTNode.toFlatzinc(bufferedWriter, false);
        bufferedWriter.append("],0);");
    }

    public void toFlatzincGeq(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        int n;
        bufferedWriter.append("constraint int_lin_le([");
        for (n = 0; n < this.weights.length; ++n) {
            bufferedWriter.append(String.valueOf(-this.weights[n]));
            bufferedWriter.append(",");
        }
        bufferedWriter.append("1],[");
        for (n = 0; n < this.numChildren(); ++n) {
            this.getChild(n).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(",");
        }
        aSTNode.toFlatzinc(bufferedWriter, false);
        bufferedWriter.append("],0);");
    }

    @Override
    public void toFlatzincWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        if (!aSTNode.isConstant()) {
            int n;
            bufferedWriter.append("constraint int_lin_eq([");
            for (n = 0; n < this.weights.length; ++n) {
                bufferedWriter.append(String.valueOf(this.weights[n]));
                bufferedWriter.append(",");
            }
            bufferedWriter.append("-1],[");
            for (n = 0; n < this.numChildren(); ++n) {
                this.getChild(n).toFlatzinc(bufferedWriter, false);
                bufferedWriter.append(",");
            }
            aSTNode.toFlatzinc(bufferedWriter, false);
            bufferedWriter.append("],0);");
        } else {
            int n;
            bufferedWriter.append("constraint int_lin_eq([");
            for (n = 0; n < this.weights.length; ++n) {
                bufferedWriter.append(String.valueOf(this.weights[n]));
                if (n >= this.weights.length - 1) continue;
                bufferedWriter.append(",");
            }
            bufferedWriter.append("],[");
            for (n = 0; n < this.numChildren(); ++n) {
                this.getChild(n).toFlatzinc(bufferedWriter, false);
                if (n >= this.weights.length - 1) continue;
                bufferedWriter.append(",");
            }
            bufferedWriter.append("],");
            aSTNode.toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(");");
        }
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        for (int i = 0; i < this.numChildren(); ++i) {
            stringBuilder.append("(");
            if (this.weights[i] != 1L) {
                stringBuilder.append(this.weights[i]);
                stringBuilder.append("*");
            }
            this.getChild(i).toMinizinc(stringBuilder, false);
            stringBuilder.append(")");
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append("+");
        }
        stringBuilder.append(")");
    }

    private void orderEncodingLeq(Sat sat, long[] lArray, long l, long l2) throws IOException {
        long[] lArray2 = new long[this.numChildren()];
        ArrayList<ArrayList<Intpair>> arrayList = new ArrayList<ArrayList<Intpair>>();
        for (int i = 0; i < this.numChildren(); ++i) {
            ArrayList<Intpair> arrayList2 = this.getChild(i).getIntervalSetExp();
            arrayList2 = Intpair.multIntervalSet(arrayList2, lArray[i]);
            arrayList.add(arrayList2);
        }
        ArrayList<ASTNode> arrayList3 = this.getChildren();
        for (int i = 0; i < this.numChildren(); ++i) {
            for (int j = i - 1; j >= 0 && Intpair.numValues(arrayList.get(j + 1)) < Intpair.numValues(arrayList.get(j)); --j) {
                ASTNode aSTNode = arrayList3.get(j + 1);
                arrayList3.set(j + 1, arrayList3.get(j));
                arrayList3.set(j, aSTNode);
                long l3 = lArray[j + 1];
                lArray[j + 1] = lArray[j];
                lArray[j] = l3;
                ArrayList<Intpair> arrayList4 = arrayList.get(j + 1);
                arrayList.set(j + 1, arrayList.get(j));
                arrayList.set(j, arrayList4);
            }
        }
        this.orderEncodingLeqHelper(sat, arrayList3, lArray, l, arrayList, lArray2, 0, l2);
    }

    private void orderEncodingLeqHelper(Sat sat, ArrayList<ASTNode> arrayList, long[] lArray, long l, ArrayList<ArrayList<Intpair>> arrayList2, long[] lArray2, int n, long l2) throws IOException {
        if (n == arrayList.size() - 1) {
            long l3;
            boolean bl = false;
            long l4 = 0L;
            for (int i = 0; i < arrayList.size() - 1; ++i) {
                l4 += lArray2[i];
            }
            lArray2[n] = l - l4;
            if (lArray2[n] > arrayList2.get((int)n).get((int)(arrayList2.get((int)n).size() - 1)).upper) {
                return;
            }
            ArrayList<Long> arrayList3 = new ArrayList<Long>(arrayList.size());
            if (l2 != 0L) {
                arrayList3.add(l2);
            }
            for (int i = 0; i < arrayList.size() - 1; ++i) {
                long l5 = lArray2[i] / lArray[i];
                assert (lArray2[i] % lArray[i] == 0L);
                long l6 = lArray[i] > 0L ? arrayList.get(i).orderEncode(sat, l5 - 1L) : -arrayList.get(i).orderEncode(sat, l5);
                if (l6 == sat.getTrue()) {
                    bl = true;
                    break;
                }
                if (l6 == -sat.getTrue()) continue;
                arrayList3.add(l6);
            }
            if (lArray[n] > 0L) {
                long l7 = Divide.div(lArray2[n], lArray[n]);
                l3 = arrayList.get(n).orderEncode(sat, l7);
            } else {
                long l8 = Divide.divceil(lArray2[n], lArray[n]);
                l3 = -arrayList.get(n).orderEncode(sat, l8 - 1L);
            }
            if (l3 == sat.getTrue()) {
                bl = true;
            }
            if (l3 != -sat.getTrue()) {
                arrayList3.add(l3);
            }
            if (!bl) {
                sat.addClause(arrayList3);
            }
        } else {
            ArrayList<Intpair> arrayList4 = arrayList2.get(n);
            for (int i = 0; i < arrayList4.size(); ++i) {
                long l9 = arrayList4.get((int)i).lower;
                while (l9 <= arrayList4.get((int)i).upper) {
                    lArray2[n] = l9++;
                    this.orderEncodingLeqHelper(sat, arrayList, lArray, l, arrayList2, lArray2, n + 1, l2);
                }
            }
        }
    }

    public void toSATLeq(Sat sat, long l) throws IOException {
        long[] lArray = new long[this.numChildren()];
        boolean bl = true;
        boolean bl2 = true;
        for (int i = 0; i < this.numChildren(); ++i) {
            lArray[i] = this.weights[i];
            if (lArray[i] != 1L) {
                bl = false;
            }
            if (this.getChild(i).isRelation()) continue;
            bl2 = false;
        }
        if (CmdFlags.use_commander && bl && bl2 && l == 1L) {
            sat.commanderEncodingAMO(this.getChildren(), false);
        } else {
            this.orderEncodingLeq(sat, lArray, l, 0L);
        }
    }

    public void toSATGeq(Sat sat, long l) throws IOException {
        long[] lArray = new long[this.numChildren()];
        for (int i = 0; i < this.numChildren(); ++i) {
            lArray[i] = -this.weights[i];
        }
        this.orderEncodingLeq(sat, lArray, -l, 0L);
    }

    public void toSATLeqWithAuxVar(Sat sat, long l, long l2) throws IOException {
        int n;
        long[] lArray = new long[this.numChildren()];
        for (n = 0; n < this.numChildren(); ++n) {
            lArray[n] = this.weights[n];
        }
        this.orderEncodingLeq(sat, lArray, l, -l2);
        for (n = 0; n < this.numChildren(); ++n) {
            lArray[n] = -this.weights[n];
        }
        this.orderEncodingLeq(sat, lArray, -(l + 1L), l2);
    }

    public void toSATGeqWithAuxVar(Sat sat, long l, long l2) throws IOException {
        int n;
        long[] lArray = new long[this.numChildren()];
        for (n = 0; n < this.numChildren(); ++n) {
            lArray[n] = -this.weights[n];
        }
        this.orderEncodingLeq(sat, lArray, -l, -l2);
        for (n = 0; n < this.numChildren(); ++n) {
            lArray[n] = this.weights[n];
        }
        this.orderEncodingLeq(sat, lArray, l - 1L, l2);
    }

    @Override
    public void toSATWithAuxVar(Sat sat, ASTNode aSTNode) throws IOException {
        if (Sat.eligibleCommander(this) && aSTNode.isConstant() && aSTNode.getValue() == 1L) {
            sat.commanderEncodingAMO(this.getChildren(), true);
        } else {
            assert (CmdFlags.getSatAlt());
            sat.ternaryEncoding(this, aSTNode);
        }
    }

    @Override
    public boolean test(long l, long l2, long l3) {
        return this.func(l, l2) == l3;
    }

    @Override
    public long func(long l, long l2) {
        return this.weights[0] * l + this.weights[1] * l2;
    }

    @Override
    public void toJSON(StringBuilder stringBuilder) {
        if (this.getParent() != null && this.getParent().canChildBeConvertedToDifference(this.getChildNo()) && this.isValidDifference()) {
            this.toJSONAsDifference(stringBuilder);
            return;
        }
        this.toJSONHeader(stringBuilder, true);
        stringBuilder.append("\"children\": [");
        for (int i = 0; i < this.numChildren(); ++i) {
            stringBuilder.append("\n");
            NumberConstant numberConstant = NumberConstant.make(this.weights[i]);
            Times times = new Times((ASTNode)numberConstant, this.getChild(i));
            times.toJSON(stringBuilder);
            stringBuilder.append(",");
        }
        stringBuilder.append("]\n}");
    }

    @Override
    public boolean childrenAreSymmetric() {
        return true;
    }

    public boolean isValidDifference() {
        long l = Math.abs(this.weights[0]);
        for (int i = 1; i < this.numChildren(); ++i) {
            if (l == Math.abs(this.weights[i])) continue;
            return false;
        }
        return true;
    }

    public void toJSONAsDifference(StringBuilder stringBuilder) {
        String string = "{\n\"type\": \"Difference\",\n\"symmetricChildren\": true,\n\"children\": [";
        ArrayList<ASTNode> arrayList = this.collectNodesOfSign(true);
        ArrayList<Long> arrayList2 = this.makeFilledList(arrayList.size(), Math.abs(this.weights[0]));
        WeightedSum weightedSum = new WeightedSum(arrayList, arrayList2);
        arrayList = this.collectNodesOfSign(false);
        arrayList2 = this.makeFilledList(arrayList.size(), Math.abs(this.weights[0]));
        WeightedSum weightedSum2 = new WeightedSum(arrayList, arrayList2);
        stringBuilder.append(string);
        stringBuilder.append("\n");
        weightedSum.toJSON(stringBuilder);
        stringBuilder.append(",\n");
        weightedSum2.toJSON(stringBuilder);
        stringBuilder.append("]\n}");
    }

    public ArrayList<ASTNode> collectNodesOfSign(boolean bl) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (int i = 0; i < this.numChildren(); ++i) {
            if ((!bl || this.weights[i] <= 0L) && (bl || this.weights[i] >= 0L)) continue;
            arrayList.add(this.getChild(i));
        }
        return arrayList;
    }

    public ArrayList<Long> makeFilledList(int n, long l) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(l);
        }
        return arrayList;
    }

    class ASTLongPairAlpha
    implements Comparable<ASTLongPairAlpha> {
        public long wt;
        public ASTNode ch;

        public ASTLongPairAlpha(long l, ASTNode aSTNode) {
            this.wt = l;
            this.ch = aSTNode;
        }

        @Override
        public int compareTo(ASTLongPairAlpha aSTLongPairAlpha) {
            return this.ch.toString().compareTo(aSTLongPairAlpha.ch.toString());
        }

        public String toString() {
            return "(" + this.wt + ", " + this.ch + ")";
        }
    }

    class ASTLongPair
    implements Comparable<ASTLongPair> {
        public long wt;
        public ASTNode ch;

        public ASTLongPair(long l, ASTNode aSTNode) {
            this.wt = l;
            this.ch = aSTNode;
        }

        @Override
        public int compareTo(ASTLongPair aSTLongPair) {
            int n;
            int n2 = this.ch.hashCode();
            if (n2 < (n = aSTLongPair.ch.hashCode())) {
                return -1;
            }
            if (n2 == n) {
                return 0;
            }
            return 1;
        }

        public String toString() {
            return "(" + this.wt + ", " + this.ch + ")";
        }
    }
}

