/*
 * Decompiled with CFR 0.152.
 */
package savilerow.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import savilerow.ACCSE;
import savilerow.ACCSEActiveSum;
import savilerow.ACCSEActiveSum2;
import savilerow.CSE;
import savilerow.CSEActive;
import savilerow.CSEClassIdentical;
import savilerow.CSETopLevel;
import savilerow.CmdFlags;
import savilerow.ICSEProduct;
import savilerow.ICSESum;
import savilerow.Pair;
import savilerow.RemoveRedundantVars;
import savilerow.SymmetryBreaker;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Find;
import savilerow.expression.Given;
import savilerow.expression.Identifier;
import savilerow.expression.Intersect;
import savilerow.expression.Intpair;
import savilerow.expression.Less;
import savilerow.expression.LessEqual;
import savilerow.expression.Letting;
import savilerow.expression.MatrixDeref;
import savilerow.expression.MatrixDomain;
import savilerow.expression.Minimising;
import savilerow.expression.MultiStage;
import savilerow.expression.MultiStageOnSolution;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.SNS;
import savilerow.expression.SNSIncumbentMapping;
import savilerow.expression.SafeMatrixDeref;
import savilerow.expression.Solution;
import savilerow.expression.ToVariable;
import savilerow.expression.Top;
import savilerow.expression.WeightedSum;
import savilerow.expression.Where;
import savilerow.model.ConstantMatrixStore;
import savilerow.model.FilteredDomainStore;
import savilerow.model.Model;
import savilerow.model.categoryentry;
import savilerow.solver.AllMinisatSATSolver;
import savilerow.solver.FznSolver;
import savilerow.solver.GlucoseSATSolver;
import savilerow.solver.LingelingSATSolver;
import savilerow.solver.MinionSolver;
import savilerow.solver.MinisatSATSolver;
import savilerow.solver.OpenWBOSATSolver;
import savilerow.solver.SATSolver;
import savilerow.solver.Stats;
import savilerow.treetransformer.ReplaceASTNode;
import savilerow.treetransformer.TransformAbsReify;
import savilerow.treetransformer.TransformAlldiffExcept;
import savilerow.treetransformer.TransformAlldiffGCCSum;
import savilerow.treetransformer.TransformAlldiffToSums;
import savilerow.treetransformer.TransformBoolEq;
import savilerow.treetransformer.TransformBreakupSum;
import savilerow.treetransformer.TransformBreakupSum2;
import savilerow.treetransformer.TransformCollectAlldiff;
import savilerow.treetransformer.TransformCollectBool;
import savilerow.treetransformer.TransformCollectGCC;
import savilerow.treetransformer.TransformCollectSATDirect;
import savilerow.treetransformer.TransformConstMatrixClass;
import savilerow.treetransformer.TransformCountToSum;
import savilerow.treetransformer.TransformDeMorgans;
import savilerow.treetransformer.TransformDecomposeLex;
import savilerow.treetransformer.TransformDecomposeLex2;
import savilerow.treetransformer.TransformDecomposeMinMax;
import savilerow.treetransformer.TransformDecomposeNegativeTable;
import savilerow.treetransformer.TransformDistributeLogical;
import savilerow.treetransformer.TransformElementForSAT2;
import savilerow.treetransformer.TransformEncodeSumSpecial;
import savilerow.treetransformer.TransformEqual;
import savilerow.treetransformer.TransformEqualClass;
import savilerow.treetransformer.TransformEqualConst;
import savilerow.treetransformer.TransformEqualConstClass;
import savilerow.treetransformer.TransformExistsVar;
import savilerow.treetransformer.TransformExpandShortTable;
import savilerow.treetransformer.TransformFactorLogical;
import savilerow.treetransformer.TransformFactorOutSum;
import savilerow.treetransformer.TransformFixSTRef;
import savilerow.treetransformer.TransformForBoundVars;
import savilerow.treetransformer.TransformForallAndToAndForall;
import savilerow.treetransformer.TransformGCAssignClique;
import savilerow.treetransformer.TransformGCCSum;
import savilerow.treetransformer.TransformGCCToSums;
import savilerow.treetransformer.TransformImplicationOr;
import savilerow.treetransformer.TransformLexAlldiff;
import savilerow.treetransformer.TransformMakeSafe;
import savilerow.treetransformer.TransformMakeTable;
import savilerow.treetransformer.TransformMakeTableScopes;
import savilerow.treetransformer.TransformMappingToTable;
import savilerow.treetransformer.TransformMatrixDeref;
import savilerow.treetransformer.TransformMatrixDerefClass;
import savilerow.treetransformer.TransformMatrixIndexedMatrix;
import savilerow.treetransformer.TransformMatrixIndicesClass;
import savilerow.treetransformer.TransformMatrixToAtoms;
import savilerow.treetransformer.TransformModToTable;
import savilerow.treetransformer.TransformMultiplyOutSum;
import savilerow.treetransformer.TransformNormalise;
import savilerow.treetransformer.TransformOccurrence;
import savilerow.treetransformer.TransformOccurrenceToSum;
import savilerow.treetransformer.TransformPowToTable;
import savilerow.treetransformer.TransformProductToMult;
import savilerow.treetransformer.TransformProductToMultInQSum;
import savilerow.treetransformer.TransformQuantifiedExpression;
import savilerow.treetransformer.TransformReifyAlldiff;
import savilerow.treetransformer.TransformReifyMin;
import savilerow.treetransformer.TransformRemoveSafeTypes;
import savilerow.treetransformer.TransformReverseDeMorgans;
import savilerow.treetransformer.TransformSATEncoding;
import savilerow.treetransformer.TransformShortTableSquash;
import savilerow.treetransformer.TransformSimplify;
import savilerow.treetransformer.TransformSortWeightedSum2;
import savilerow.treetransformer.TransformSubInSolution;
import savilerow.treetransformer.TransformSumEq;
import savilerow.treetransformer.TransformSumEqToSum;
import savilerow.treetransformer.TransformSumEqualSum;
import savilerow.treetransformer.TransformSumForSAT;
import savilerow.treetransformer.TransformSumLeq;
import savilerow.treetransformer.TransformSumLess;
import savilerow.treetransformer.TransformSumToAMOPB;
import savilerow.treetransformer.TransformSumToShift;
import savilerow.treetransformer.TransformTableToShortTable;
import savilerow.treetransformer.TransformTimes;
import savilerow.treetransformer.TransformToFlat;
import savilerow.treetransformer.TransformToFlatClass;
import savilerow.treetransformer.TransformToFlatGecode;
import savilerow.treetransformer.TransformWSumToSum;
import savilerow.treetransformer.TransformWeightedSumForSAT;
import savilerow.treetransformer.TransformXor;
import savilerow.treetransformer.TreeTransformer;
import savilerow.treetransformer.TreeTransformerBottomUp;
import savilerow.treetransformer.TreeTransformerBottomUpNoWrapper;
import savilerow.treetransformer.TreeTransformerTopdown;

public class ModelContainer {
    public Model m;
    public ArrayList<ASTNode> parameters;

    public ModelContainer(Model model, ArrayList<ASTNode> arrayList) {
        this.m = model;
        this.parameters = arrayList;
    }

    public void process() {
        this.processPreamble();
        if (CmdFlags.getDominiontrans()) {
            this.classLevelFlattening();
        } else {
            this.instancePreFlattening1();
            if (CmdFlags.getUsePropagate()) {
                this.squashDomains();
                CmdFlags.currentModel = this.m;
            }
            this.instancePreFlattening2(false);
            if (CmdFlags.getMode() == 3) {
                this.branchingInstanceFlattening();
            } else {
                this.instanceFlattening(-1, false);
                this.postFlattening(-1, false);
            }
        }
    }

    public void dryrun() {
        this.processPreamble();
        if (CmdFlags.getDominiontrans()) {
            this.classLevelFlattening();
        } else {
            this.instancePreFlattening1();
            if (CmdFlags.getUsePropagate()) {
                this.squashDomains();
                CmdFlags.currentModel = this.m;
            }
            this.instancePreFlattening2(false);
            if (CmdFlags.getMode() == 3) {
                this.branchingInstanceFlattening();
            } else {
                this.instanceFlattening(-1, false);
            }
        }
    }

    public void processPreamble() {
        TreeTransformer treeTransformer;
        Object object;
        Object object2;
        Object object3;
        CmdFlags.setOutputReady(false);
        CmdFlags.setAfterAggregate(false);
        ArrayDeque<ASTNode> arrayDeque = this.m.global_symbols.lettings_givens;
        for (int i = 0; i < this.parameters.size(); ++i) {
            object3 = this.parameters.get(i);
            if (!((ASTNode)object3).typecheck(this.m.global_symbols)) {
                CmdFlags.errorExit("Failed type checking in parameter file:" + object3);
            }
            object2 = new TransformMakeSafe(this.m);
            object3 = ((TreeTransformerBottomUp)object2).transform((ASTNode)object3);
            object = ((TreeTransformerBottomUp)object2).getContextCts();
            if (object != null) {
                arrayDeque.addLast(new Where((ASTNode)object));
            }
            treeTransformer = new TransformSimplify();
            object3 = ((TreeTransformerBottomUpNoWrapper)treeTransformer).transform((ASTNode)object3);
            TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(this.m);
            object3 = transformQuantifiedExpression.transform((ASTNode)object3);
            object3 = ((TreeTransformerBottomUpNoWrapper)treeTransformer).transform((ASTNode)object3);
            object3 = this.fixIndexDomainsLetting((ASTNode)object3);
            this.parameters.set(i, (ASTNode)object3);
            ReplaceASTNode replaceASTNode = new ReplaceASTNode(((ASTNode)object3).getChild(0), ((ASTNode)object3).getChild(1));
            for (int j = i + 1; j < this.parameters.size(); ++j) {
                this.parameters.set(j, replaceASTNode.transform(this.parameters.get(j)));
            }
        }
        while (arrayDeque.size() != 0) {
            ASTNode aSTNode = arrayDeque.removeFirst();
            if (!aSTNode.typecheck(this.m.global_symbols)) {
                CmdFlags.errorExit("Failed type checking:" + aSTNode);
            }
            object3 = new TransformMakeSafe(this.m);
            aSTNode = ((TreeTransformerBottomUp)object3).transform(aSTNode);
            object2 = ((TreeTransformerBottomUp)object3).getContextCts();
            if (object2 != null) {
                arrayDeque.addLast(new Where((ASTNode)object2));
            }
            object = new TransformSimplify();
            aSTNode = ((TreeTransformerBottomUpNoWrapper)object).transform(aSTNode);
            if (!CmdFlags.getDominiontrans()) {
                treeTransformer = new TransformQuantifiedExpression(this.m);
                aSTNode = ((TreeTransformerTopdown)treeTransformer).transform(aSTNode);
            }
            if ((aSTNode = ((TreeTransformerBottomUpNoWrapper)object).transform(aSTNode)) instanceof Letting) {
                aSTNode = this.fixIndexDomainsLetting(aSTNode);
                this.processLetting(aSTNode);
                continue;
            }
            if (aSTNode instanceof Find) {
                this.processFind(aSTNode);
                continue;
            }
            if (aSTNode instanceof Where) {
                this.processWhere(aSTNode);
                continue;
            }
            assert (aSTNode instanceof Given);
            this.processGiven(aSTNode);
        }
        if (this.parameters.size() > 0) {
            CmdFlags.warning("Number of givens in model file does not match number of lettings in parameter file.");
        }
        this.parameters = null;
        if (!this.m.typecheck()) {
            CmdFlags.errorExit("Failed type checking after substituting in lettings.");
        }
        if (CmdFlags.getVerbose()) {
            CmdFlags.println("Model before undef handling:");
            CmdFlags.println(this.m);
        }
        this.removeMatrixIndexedMatrices();
        TransformMakeSafe transformMakeSafe = new TransformMakeSafe(this.m);
        this.m.transform(transformMakeSafe);
        this.m.simplify();
    }

    public void instancePreFlattening1() {
        Object object;
        Object object2;
        Object object3;
        if (!CmdFlags.getMinionSNStrans() && this.m.sns != null) {
            object3 = ((SNS)this.m.sns).deactivateEarly();
            this.m.constraints.getChild(0).setParent(null);
            this.m.constraints.setChild(0, new And(this.m.constraints.getChild(0), (ASTNode)object3));
            this.m.simplify();
        }
        object3 = new TransformExistsVar(this.m);
        this.m.transform((TreeTransformer)object3);
        TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(this.m);
        this.m.transform(transformQuantifiedExpression);
        this.destroyMatrices();
        if (this.m.sns != null) {
            object2 = ((SNSIncumbentMapping)this.m.sns.getChild(0)).makeIncumbentDisable();
            this.m.constraints.getChild(0).setParent(null);
            this.m.constraints.setChild(0, new And(this.m.constraints.getChild(0), (ASTNode)object2));
            this.m.simplify();
        }
        object2 = new TransformMatrixDeref(this.m);
        this.m.transform((TreeTransformer)object2);
        if (CmdFlags.getGraphColSymBreak()) {
            object = new TransformGCAssignClique(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.getUseVarSymBreaking()) {
            this.writeModelAsJSON(this.m);
        }
        if (this.m.objective != null && !((ASTNode)(object = this.m.objective.getChild(0))).isConstant() && !(object instanceof Identifier)) {
            boolean bl = true;
            if (object instanceof MatrixDeref || object instanceof SafeMatrixDeref) {
                bl = false;
                for (int i = 1; i < ((ASTNode)object).numChildren(); ++i) {
                    if (((ASTNode)object).getChild(i).isConstant()) continue;
                    bl = true;
                }
            }
            if (bl) {
                ASTNode aSTNode = this.m.global_symbols.newAuxHelper((ASTNode)object);
                ASTNodeC aSTNodeC = CmdFlags.getAuxNonFunctional() && this.m.objective.getChild(0) instanceof WeightedSum && CmdFlags.getSattrans() ? (this.m.objective instanceof Minimising ? new LessEqual((ASTNode)object, aSTNode) : new LessEqual(aSTNode, (ASTNode)object)) : new ToVariable((ASTNode)object, aSTNode);
                this.m.global_symbols.auxVarRepresentsConstraint(aSTNode.toString(), ((ASTNode)object).toString());
                this.m.objective.setChild(0, aSTNode);
                this.m.constraints.getChild(0).setParent(null);
                this.m.constraints.setChild(0, new And((ASTNode)aSTNodeC, this.m.constraints.getChild(0)));
            }
        }
        object = new TransformNormalise(this.m);
        this.m.transform((TreeTransformer)object);
    }

    public void instancePreFlattening2(boolean bl) {
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper;
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper2;
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper3;
        TreeTransformer treeTransformer;
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper4;
        Object object;
        if ((!CmdFlags.getMinionSNStrans() || bl) && this.m.sns != null) {
            object = ((SNS)this.m.sns).deactivate();
            this.m.constraints.getChild(0).setParent(null);
            this.m.constraints.setChild(0, new And(this.m.constraints.getChild(0), (ASTNode)object));
            this.m.simplify();
            this.m.sns = null;
        }
        if (CmdFlags.getRemoveRedundantVars()) {
            object = new RemoveRedundantVars();
            ((RemoveRedundantVars)object).transform(this.m);
        }
        if (CmdFlags.getUseAggregate()) {
            object = new TransformCollectAlldiff(this.m);
            this.m.transform((TreeTransformer)object);
            treeTransformerBottomUpNoWrapper4 = new TransformCollectGCC(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper4);
        }
        CmdFlags.setAfterAggregate(true);
        if (CmdFlags.getUseDeleteVars() && CmdFlags.getUseAggregate()) {
            this.m.simplify();
        }
        object = new TransformAlldiffExcept(this.m);
        this.m.transform((TreeTransformer)object);
        treeTransformerBottomUpNoWrapper4 = new TransformOccurrence();
        this.m.transform(treeTransformerBottomUpNoWrapper4);
        if (CmdFlags.getUseBoundVars() && CmdFlags.getMiniontrans()) {
            treeTransformer = new TransformForBoundVars(this.m);
            this.m.transform(treeTransformer);
        }
        treeTransformer = new TransformBoolEq(this.m);
        this.m.transform(treeTransformer);
        TransformGCCSum transformGCCSum = new TransformGCCSum(this.m);
        this.m.transform(transformGCCSum);
        TransformMakeTable transformMakeTable = new TransformMakeTable(this.m, bl);
        if (!(bl || CmdFlags.make_short_tab != 3 && CmdFlags.make_short_tab != 4)) {
            treeTransformerBottomUpNoWrapper3 = new TransformNormalise(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper3);
            treeTransformerBottomUpNoWrapper2 = new TransformMakeTableScopes(this.m, transformMakeTable);
            this.m.transform(treeTransformerBottomUpNoWrapper2);
            ((TransformMakeTableScopes)treeTransformerBottomUpNoWrapper2).doIt();
        }
        this.m.transform(transformMakeTable);
        treeTransformerBottomUpNoWrapper3 = new TransformLexAlldiff(this.m);
        this.m.transform(treeTransformerBottomUpNoWrapper3);
        if ((CmdFlags.getGecodetrans() || CmdFlags.getChuffedtrans()) && !bl) {
            treeTransformerBottomUpNoWrapper2 = new TransformReifyAlldiff(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper2);
            treeTransformerBottomUpNoWrapper = new TransformDecomposeNegativeTable(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        if (CmdFlags.getChuffedtrans() && !bl) {
            treeTransformerBottomUpNoWrapper2 = new TransformOccurrenceToSum();
            this.m.transform(treeTransformerBottomUpNoWrapper2);
            treeTransformerBottomUpNoWrapper = new TransformGCCToSums();
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        if (CmdFlags.getSattrans() && !bl) {
            treeTransformerBottomUpNoWrapper2 = new TransformSumToShift(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper2);
            treeTransformerBottomUpNoWrapper = new TransformProductToMult(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        treeTransformerBottomUpNoWrapper2 = new TransformNormalise(this.m);
        this.m.transform(treeTransformerBottomUpNoWrapper2);
    }

    public void squashDomains() {
        Object object;
        ASTNode aSTNode;
        Object object2;
        String string;
        ASTNode aSTNode2;
        Model model = this.m.copy();
        Model model2 = null;
        if (CmdFlags.getVerbose()) {
            model2 = this.m.copy();
        }
        boolean bl = CmdFlags.getOutputReady();
        boolean bl2 = CmdFlags.getAfterAggregate();
        this.instancePreFlattening2(true);
        this.instanceFlattening(-1, true);
        ArrayList<ASTNode> arrayList = this.postFlattening(-1, true);
        FilteredDomainStore filteredDomainStore = this.m.filt;
        ASTNode aSTNode3 = this.m.incumbentSolution;
        this.m = model;
        this.m.filt = filteredDomainStore;
        this.m.incumbentSolution = aSTNode3;
        CmdFlags.setOutputReady(bl);
        CmdFlags.setAfterAggregate(bl2);
        for (int i = 0; i < arrayList.size(); ++i) {
            aSTNode2 = arrayList.get(i).getChild(0);
            ASTNode aSTNode4 = arrayList.get(i).getChild(1);
            assert (aSTNode2 instanceof Identifier);
            assert (aSTNode4.isFiniteSet());
            string = aSTNode2.toString();
            if (this.m.global_symbols.getCategory(string) == 3) {
                object2 = this.m.global_symbols.getDomain(string);
                aSTNode = new Intersect((ASTNode)object2, aSTNode4);
                if (((ASTNode)object2).isBooleanSet()) {
                    object = new TransformSimplify();
                    aSTNode = Intpair.makeDomain(((TreeTransformerBottomUpNoWrapper)object).transform(aSTNode).getIntervalSet(), true);
                }
                this.m.global_symbols.setDomain(string, aSTNode);
                continue;
            }
            this.m.filt.auxVarFilteredDomain(string, aSTNode4);
        }
        if (this.m.sns != null && CmdFlags.getMinionSNStrans()) {
            ASTNode aSTNode5 = this.m.sns.getChild(0).getChild(0);
            aSTNode2 = this.m.sns.getChild(0).getChild(1);
            assert (aSTNode5 instanceof CompoundMatrix);
            assert (aSTNode2 instanceof CompoundMatrix);
            for (int i = 1; i < aSTNode5.numChildren(); ++i) {
                string = aSTNode5.getChild(i).toString();
                object2 = aSTNode2.getChild(i).toString();
                aSTNode = this.m.global_symbols.getDomain(string);
                object = new Intersect(aSTNode, this.m.global_symbols.getDomain((String)object2));
                if (this.m.global_symbols.getDomain((String)object2).isBooleanSet()) {
                    TransformSimplify transformSimplify = new TransformSimplify();
                    object = Intpair.makeDomain(transformSimplify.transform((ASTNode)object).getIntervalSet(), true);
                }
                this.m.global_symbols.setDomain((String)object2, (ASTNode)object);
            }
        }
        this.m.simplify();
        if (CmdFlags.getVerbose() && !this.m.equals(model2)) {
            System.out.println("Domain filtering changed model:\n" + this.m.toString());
        }
    }

    public void branchingInstanceFlattening() {
        CmdFlags.currentModel = null;
        ArrayList<TreeTransformerBottomUpNoWrapper> arrayList = new ArrayList<TreeTransformerBottomUpNoWrapper>();
        arrayList.add(new TransformMultiplyOutSum());
        arrayList.add(new TransformFactorOutSum());
        arrayList.add(new TransformImplicationOr(false));
        arrayList.add(new TransformImplicationOr(true));
        arrayList.add(new TransformDeMorgans(true));
        arrayList.add(new TransformDeMorgans(false));
        arrayList.add(new TransformReverseDeMorgans(true));
        arrayList.add(new TransformReverseDeMorgans(false));
        arrayList.add(new TransformDistributeLogical(true, true));
        arrayList.add(new TransformDistributeLogical(false, true));
        arrayList.add(new TransformFactorLogical(true));
        arrayList.add(new TransformFactorLogical(false));
        ArrayList<ArrayList<Boolean>> arrayList2 = new ArrayList<ArrayList<Boolean>>();
        this.buildSwitches(arrayList2, new ArrayList<Boolean>(), arrayList.size());
        Model model = this.m.copy();
        int n = 0;
        for (int i = 0; i < arrayList2.size(); ++i) {
            System.out.println("Switches: " + arrayList2.get(i));
            boolean bl = false;
            int n2 = -1;
            for (int j = 0; j < arrayList.size(); ++j) {
                if (!arrayList2.get(i).get(j).booleanValue()) continue;
                String string = this.m.toString();
                boolean bl2 = this.m.transform((TreeTransformer)arrayList.get(j));
                String string2 = this.m.toString();
                if (!bl2 && !string.equals(string2)) {
                    CmdFlags.println("Yikes: modelchanged flag wrong.");
                    bl2 = true;
                }
                if (bl2) continue;
                bl = true;
                n2 = j;
                break;
            }
            if (!bl) {
                this.instanceFlattening(++n, false);
                this.postFlattening(n, false);
            } else {
                assert (n2 > -1);
                while (i < arrayList2.size() && arrayList2.get(i).get(n2).booleanValue()) {
                    ++i;
                }
                --i;
            }
            this.m = model.copy();
        }
        System.out.println("Total models:" + n);
    }

    public void buildSwitches(ArrayList<ArrayList<Boolean>> arrayList, ArrayList<Boolean> arrayList2, int n) {
        if (n == 0) {
            arrayList.add(arrayList2);
            return;
        }
        ArrayList<Boolean> arrayList3 = new ArrayList<Boolean>(arrayList2);
        arrayList3.add(false);
        ArrayList<Boolean> arrayList4 = new ArrayList<Boolean>(arrayList2);
        arrayList4.add(true);
        this.buildSwitches(arrayList, arrayList3, n - 1);
        this.buildSwitches(arrayList, arrayList4, n - 1);
    }

    public void instanceFlattening(int n, boolean bl) {
        TreeTransformer treeTransformer;
        TreeTransformer treeTransformer2;
        Object object;
        Object object2;
        Object object3;
        TreeTransformer treeTransformer3;
        if (!CmdFlags.getUseEliminateVars() || !bl) {
            // empty if block
        }
        if ((CmdFlags.getGecodetrans() || CmdFlags.getChuffedtrans() || CmdFlags.getMinizinctrans()) && !bl) {
            treeTransformer3 = new TransformRemoveSafeTypes(this.m);
            this.m.transform(treeTransformer3);
        }
        if (CmdFlags.getVerbose()) {
            System.out.println("Rules: Normalisation and CSE");
        }
        treeTransformer3 = new TransformAlldiffGCCSum(this.m);
        if (CmdFlags.getUseACCSE() || CmdFlags.getUseACCSEAlt()) {
            this.m.transform(treeTransformer3);
        }
        TransformNormalise transformNormalise = new TransformNormalise(this.m);
        if (CmdFlags.getUseACCSE()) {
            this.m.transform(transformNormalise);
            object3 = new ACCSE();
            ((ACCSE)object3).flattenCSEs(this.m, "*");
            CmdFlags.stats.put("AC-CSE-Times_number", ((ACCSE)object3).numcse);
            CmdFlags.stats.put("AC-CSE-Times_eliminated_expressions", ((ACCSE)object3).countcse);
            CmdFlags.stats.put("AC-CSE-Times_total_size", ((ACCSE)object3).totallength);
            this.m.simplify();
            ((ACCSE)object3).flattenCSEs(this.m, "xor");
            CmdFlags.stats.put("AC-CSE-Xor_number", ((ACCSE)object3).numcse);
            CmdFlags.stats.put("AC-CSE-Xor_eliminated_expressions", ((ACCSE)object3).countcse);
            CmdFlags.stats.put("AC-CSE-Xor_total_size", ((ACCSE)object3).totallength);
            this.m.simplify();
        }
        if (CmdFlags.getUseACCSEAlt()) {
            this.m.transform(transformNormalise);
            object3 = new ICSEProduct();
            ((ICSEProduct)object3).flattenCSEs(this.m);
            this.m.simplify();
        }
        CmdFlags.setOutputReady(true);
        object3 = new TransformTimes(this.m);
        this.m.transform((TreeTransformer)object3);
        TransformXor transformXor = new TransformXor(this.m);
        this.m.transform(transformXor);
        if (CmdFlags.getUseCSE()) {
            this.m.transform(transformNormalise);
            object2 = new CSETopLevel();
            ((CSETopLevel)object2).flattenCSEs(this.m);
            CmdFlags.stats.put("CSETopLevel_number", ((CSETopLevel)object2).numcse);
            CmdFlags.stats.put("CSETopLevel_eliminated_expressions", ((CSETopLevel)object2).countcse);
            CmdFlags.stats.put("CSETopLevel_total_size", ((CSETopLevel)object2).totallength);
            this.m.simplify();
        }
        if (CmdFlags.getUseACCSE()) {
            object2 = new ACCSE();
            this.m.transform(transformNormalise);
            ((ACCSE)object2).flattenCSEs(this.m, "\\/");
            CmdFlags.stats.put("AC-CSE-Or_number", ((ACCSE)object2).numcse);
            CmdFlags.stats.put("AC-CSE-Or_eliminated_expressions", ((ACCSE)object2).countcse);
            CmdFlags.stats.put("AC-CSE-Or_total_size", ((ACCSE)object2).totallength);
            this.m.simplify();
            this.m.transform(transformNormalise);
            ((ACCSE)object2).flattenCSEs(this.m, "/\\");
            CmdFlags.stats.put("AC-CSE-And_number", ((ACCSE)object2).numcse);
            CmdFlags.stats.put("AC-CSE-And_eliminated_expressions", ((ACCSE)object2).countcse);
            CmdFlags.stats.put("AC-CSE-And_total_size", ((ACCSE)object2).totallength);
            this.m.simplify();
            this.m.transform(transformNormalise);
            if (CmdFlags.getUseActiveACCSE()) {
                object = new ACCSEActiveSum();
                ((ACCSEActiveSum)object).flattenCSEs(this.m);
                CmdFlags.stats.put("Active-AC-CSE-Sum_number", ((ACCSEActiveSum)object).numcse);
                CmdFlags.stats.put("Active-AC-CSE-Sum_eliminated_expressions", ((ACCSEActiveSum)object).countcse);
                CmdFlags.stats.put("Active-AC-CSE-Sum_total_size", ((ACCSEActiveSum)object).totallength);
                CmdFlags.stats.put("Active-AC-CSE-Found", ((ACCSEActiveSum)object).active_ac_cs_found ? 1 : 0);
            } else if (CmdFlags.getUseActiveACCSE2()) {
                object = new ACCSEActiveSum2();
                ((ACCSEActiveSum2)object).flattenCSEs(this.m);
                CmdFlags.stats.put("Active-AC-CSE-Sum_number", ((ACCSEActiveSum2)object).numcse);
                CmdFlags.stats.put("Active-AC-CSE-Sum_eliminated_expressions", ((ACCSEActiveSum2)object).countcse);
                CmdFlags.stats.put("Active-AC-CSE-Sum_total_size", ((ACCSEActiveSum2)object).totallength);
                CmdFlags.stats.put("Active-AC-CSE-Found", ((ACCSEActiveSum2)object).active_ac_cs_found ? 1 : 0);
            } else {
                ((ACCSE)object2).flattenCSEs(this.m, "+");
                CmdFlags.stats.put("AC-CSE-Sum_number", ((ACCSE)object2).numcse);
                CmdFlags.stats.put("AC-CSE-Sum_eliminated_expressions", ((ACCSE)object2).countcse);
                CmdFlags.stats.put("AC-CSE-Sum_total_size", ((ACCSE)object2).totallength);
            }
        }
        if (CmdFlags.getUseACCSEAlt()) {
            object2 = new ACCSE();
            this.m.transform(transformNormalise);
            ((ACCSE)object2).flattenCSEs(this.m, "\\/");
            CmdFlags.stats.put("AC-CSE-Or_number", ((ACCSE)object2).numcse);
            CmdFlags.stats.put("AC-CSE-Or_eliminated_expressions", ((ACCSE)object2).countcse);
            CmdFlags.stats.put("AC-CSE-Or_total_size", ((ACCSE)object2).totallength);
            this.m.simplify();
            this.m.transform(transformNormalise);
            ((ACCSE)object2).flattenCSEs(this.m, "/\\");
            CmdFlags.stats.put("AC-CSE-And_number", ((ACCSE)object2).numcse);
            CmdFlags.stats.put("AC-CSE-And_eliminated_expressions", ((ACCSE)object2).countcse);
            CmdFlags.stats.put("AC-CSE-And_total_size", ((ACCSE)object2).totallength);
            this.m.simplify();
            this.m.transform(transformNormalise);
            object = new ICSESum();
            ((ICSESum)object).flattenCSEs(this.m);
            this.m.simplify();
        }
        if (CmdFlags.getUseACCSE() || CmdFlags.getUseACCSEAlt()) {
            ((TransformAlldiffGCCSum)treeTransformer3).removeImpliedConstraints();
        }
        if (CmdFlags.getSattrans() && !bl) {
            this.decomposeSatEncoding();
        }
        if (CmdFlags.getUseCSE() || CmdFlags.getUseActiveCSE()) {
            this.m.transform(transformNormalise);
            if (CmdFlags.getUseActiveCSE()) {
                object2 = new CSEActive();
                ((CSEActive)object2).flattenCSEs(this.m);
                this.m.simplify();
                CmdFlags.stats.put("CSE_active_number", ((CSEActive)object2).numcse);
                CmdFlags.stats.put("CSE_active_eliminated_expressions", ((CSEActive)object2).countcse);
                CmdFlags.stats.put("CSE_active_total_size", ((CSEActive)object2).totallength);
            } else {
                object2 = new CSE();
                ((CSE)object2).flattenCSEs(this.m);
                this.m.simplify();
                CmdFlags.stats.put("CSE_number", ((CSE)object2).numcse);
                CmdFlags.stats.put("CSE_eliminated_expressions", ((CSE)object2).countcse);
                CmdFlags.stats.put("CSE_total_size", ((CSE)object2).totallength);
            }
        }
        if (CmdFlags.getVerbose()) {
            System.out.println("Model may have changed by CSE. Model after rule application:\n" + this.m.toString());
        }
        object2 = new TransformEqual(this.m, bl);
        this.m.transform((TreeTransformer)object2);
        object = new TransformEqualConst(bl);
        this.m.transform((TreeTransformer)object);
        if (CmdFlags.table_squash == 1 || CmdFlags.table_squash == 3) {
            treeTransformer2 = new TransformShortTableSquash(this.m);
            this.m.transform(treeTransformer2);
        }
        if (CmdFlags.table_squash == 2 || CmdFlags.table_squash == 3) {
            treeTransformer2 = new TransformTableToShortTable(this.m);
            this.m.transform(treeTransformer2);
        }
        treeTransformer2 = new TransformToFlat(this.m, bl);
        this.m.transform(treeTransformer2);
        if ((CmdFlags.getGecodetrans() || CmdFlags.getChuffedtrans()) && !bl) {
            treeTransformer = new TransformToFlatGecode(this.m);
            this.m.transform(treeTransformer);
        }
        if (CmdFlags.getExpandShortTab() || (CmdFlags.getGecodetrans() || CmdFlags.getChuffedtrans() || CmdFlags.getMinizinctrans()) && !bl) {
            treeTransformer = new TransformExpandShortTable(this.m);
            this.m.transform(treeTransformer);
        }
        if (CmdFlags.getChuffedtrans() && !bl) {
            treeTransformer = new TransformModToTable(this.m);
            this.m.transform(treeTransformer);
        }
        if ((CmdFlags.getChuffedtrans() || CmdFlags.getGecodetrans() || CmdFlags.getMinizinctrans()) && !bl) {
            treeTransformer = new TransformPowToTable(this.m);
            this.m.transform(treeTransformer);
        }
        treeTransformer = new TransformMappingToTable(this.m);
        this.m.transform(treeTransformer);
    }

    public ArrayList<ASTNode> postFlattening(int n, boolean bl) {
        block24: {
            Object object;
            Object object2;
            TreeTransformer treeTransformer;
            if ((CmdFlags.getGecodetrans() || CmdFlags.getChuffedtrans()) && !bl) {
                this.fznFlattening();
                System.exit(0);
            }
            if (CmdFlags.getMinizinctrans() && !bl) {
                this.minizincOutput();
                System.exit(0);
            }
            if (CmdFlags.getSattrans() && !bl) {
                Object object3;
                this.decomposeSatEncodingFlat();
                treeTransformer = new TransformToFlatGecode(this.m);
                this.m.transform(treeTransformer);
                this.m.simplify();
                if (CmdFlags.getTestSolutions()) {
                    CmdFlags.checkSolModel = this.m.copy();
                }
                object2 = new TransformCollectSATDirect(this.m);
                ((TreeTransformerBottomUpNoWrapper)object2).transform(this.m.constraints);
                CmdFlags.printlnIfVerbose("About to do m.setupSAT");
                boolean bl2 = this.m.setupSAT(((TransformCollectSATDirect)object2).getVarsInConstraints());
                if (!bl2) {
                    object3 = new Stats();
                    ((Stats)object3).putValue("SavileRowTotalTime", String.valueOf(((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0));
                    ((Stats)object3).putValue("SavileRowClauseOut", "1");
                    ((Stats)object3).makeInfoFiles();
                    CmdFlags.errorExit("Failed when writing SAT encoding to file.");
                }
                CmdFlags.printlnIfVerbose("Done m.setupSAT");
                object3 = new TransformSATEncoding(this.m);
                this.m.constraints = ((TreeTransformerBottomUpNoWrapper)object3).transform(this.m.constraints);
                if (CmdFlags.multistage) {
                    this.satOutputMining();
                } else {
                    this.satOutput();
                }
                System.exit(0);
            }
            treeTransformer = new TransformSumEq(bl);
            this.m.transform(treeTransformer);
            if (CmdFlags.getMakeTables() && !bl) {
                this.makeTables();
            }
            this.m.simplify();
            if (CmdFlags.getOptWarmStart() && this.m.objective != null && bl) {
                object2 = new MinionSolver();
                try {
                    Solution solution = ((MinionSolver)object2).optWarmStart(this.m);
                    if (solution != null) {
                        this.m.incumbentSolution = solution;
                        long l = solution.optval;
                        ASTNode aSTNode = this.m.objective.getChild(0);
                        Less less = this.m.objective instanceof Minimising ? new Less(aSTNode, NumberConstant.make(l)) : new Less((ASTNode)NumberConstant.make(l), aSTNode);
                        System.out.println("Adding warm start constraint: " + less);
                        this.m.constraints.getChild(0).setParent(null);
                        this.m.constraints.setChild(0, new And(this.m.constraints.getChild(0), less));
                        this.m.simplify();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            assert (CmdFlags.minionfile != null);
            object2 = CmdFlags.minionfile;
            if (n > -1) {
                object2 = (String)object2 + "." + n;
            }
            try {
                object = new FileOutputStream((String)object2);
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object));
                this.m.toMinion(bufferedWriter);
                bufferedWriter.flush();
                ((FileOutputStream)object).getFD().sync();
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                CmdFlags.errorExit("Could not open file for Minion output.");
            }
            CmdFlags.println("Created output file " + (bl ? "for domain filtering " : "") + (String)object2);
            if (bl) {
                object = new MinionSolver();
                try {
                    return ((MinionSolver)object).reduceDomains(CmdFlags.getMinion(), (String)object2, this.m);
                }
                catch (IOException iOException) {
                    CmdFlags.errorExit("Could not run Minion: " + iOException);
                    break block24;
                }
                catch (InterruptedException interruptedException) {
                    CmdFlags.errorExit("Could not run Minion: " + interruptedException);
                    break block24;
                }
            }
            if (CmdFlags.getRunSolver()) {
                object = new MinionSolver();
                try {
                    ((MinionSolver)object).findSolutions(CmdFlags.getMinion(), (String)object2, this.m);
                }
                catch (IOException iOException) {
                    CmdFlags.errorExit("Could not run Minion: " + iOException);
                }
                catch (InterruptedException interruptedException) {
                    CmdFlags.errorExit("Could not run Minion: " + interruptedException);
                }
            }
        }
        return null;
    }

    private void makeTables() {
        MinionSolver minionSolver = new MinionSolver();
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        ArrayList<Identifier> arrayList2 = new ArrayList<Identifier>();
        categoryentry categoryentry2 = this.m.global_symbols.category_first;
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3) {
                arrayList2.add(new Identifier(this.m, categoryentry2.name));
            }
            categoryentry2 = categoryentry2.next;
        }
        for (int i = 0; i < CmdFlags.make_tables_scope.size(); ++i) {
            arrayList.add((ASTNode)arrayList2.get(CmdFlags.make_tables_scope.get(i)));
        }
        ASTNode aSTNode = null;
        try {
            aSTNode = minionSolver.makeTable(this.m, arrayList);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace(System.out);
        }
        this.m.constraints.getChild(0).setParent(null);
        this.m.constraints = new Top(new And(this.m.constraints.getChild(0), aSTNode));
        this.m.simplify();
    }

    private void destroyMatrices() {
        boolean bl = true;
        block0: while (bl) {
            bl = false;
            HashMap<String, ASTNode> hashMap = this.m.global_symbols.getDomains();
            for (Map.Entry<String, ASTNode> entry : hashMap.entrySet()) {
                if (!(entry.getValue() instanceof MatrixDomain) || this.m.global_symbols.getCategory(entry.getKey()) != 3) continue;
                TransformMatrixToAtoms transformMatrixToAtoms = new TransformMatrixToAtoms(entry.getKey(), this.m);
                this.m.transform(transformMatrixToAtoms);
                bl = true;
                continue block0;
            }
        }
    }

    private void removeMatrixIndexedMatrices() {
        boolean bl = true;
        block0: while (bl) {
            bl = false;
            HashMap<String, ASTNode> hashMap = this.m.global_symbols.getDomains();
            for (Map.Entry<String, ASTNode> entry : hashMap.entrySet()) {
                if (!(entry.getValue() instanceof MatrixDomain) || this.m.global_symbols.getCategory(entry.getKey()) != 3) continue;
                boolean bl2 = false;
                for (int i = 3; i < entry.getValue().numChildren(); ++i) {
                    if (!(entry.getValue().getChild(i) instanceof MatrixDomain)) continue;
                    bl2 = true;
                }
                if (!bl2) continue;
                TransformMatrixIndexedMatrix transformMatrixIndexedMatrix = new TransformMatrixIndexedMatrix(entry.getKey(), this.m);
                this.m.transform(transformMatrixIndexedMatrix);
                bl = true;
                continue block0;
            }
        }
    }

    private void classLevelFlattening() {
        Map.Entry<String, ASTNode> entry3;
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper;
        Object object;
        Object object2;
        Object object3;
        Map.Entry<String, ASTNode> entry22;
        System.out.println(this.m.toString());
        CmdFlags.setAfterAggregate(true);
        HashMap<String, ASTNode> hashMap = this.m.global_symbols.getDomains();
        for (Map.Entry<String, ASTNode> entry22 : hashMap.entrySet()) {
            if (!(entry22.getValue() instanceof MatrixDomain)) continue;
            TransformMatrixIndicesClass transformMatrixIndicesClass = new TransformMatrixIndicesClass(0, this.m, (String)entry22.getKey());
            this.m.transform(transformMatrixIndicesClass);
            System.out.println(this.m.toString());
        }
        if (this.m.objective != null && !((ASTNode)((Object)(entry22 = this.m.objective.getChild(0)))).isConstant() && !(entry22 instanceof Identifier)) {
            boolean bl = true;
            if (entry22 instanceof MatrixDeref || entry22 instanceof SafeMatrixDeref) {
                bl = false;
                for (int i = 1; i < ((ASTNode)((Object)entry22)).numChildren(); ++i) {
                    if (((ASTNode)((Object)entry22)).getChild(i).getCategory() != 3) continue;
                    bl = true;
                }
            }
            if (bl) {
                PairASTNode pairASTNode = ((ASTNode)((Object)entry22)).getBoundsAST();
                object3 = this.m.global_symbols.newAuxiliaryVariable(pairASTNode.e1, pairASTNode.e2);
                object2 = new ToVariable((ASTNode)((Object)entry22), (ASTNode)object3);
                this.m.global_symbols.auxVarRepresentsConstraint(((ASTNode)object3).toString(), ((ASTNode)((Object)entry22)).toString());
                this.m.objective.setChild(0, (ASTNode)object3);
                this.m.constraints.getChild(0).setParent(null);
                this.m.constraints.setChild(0, new And((ASTNode)object2, this.m.constraints.getChild(0)));
            }
        }
        entry22 = new TransformForallAndToAndForall();
        this.m.transform((TreeTransformer)((Object)entry22));
        TransformMatrixDerefClass transformMatrixDerefClass = new TransformMatrixDerefClass(this.m);
        this.m.transform(transformMatrixDerefClass);
        TransformOccurrence transformOccurrence = new TransformOccurrence();
        this.m.transform(transformOccurrence);
        object3 = new TransformSumEqualSum(this.m);
        this.m.transform((TreeTransformer)object3);
        object2 = new TransformSumLess();
        this.m.transform((TreeTransformer)object2);
        TransformSumLeq transformSumLeq = new TransformSumLeq();
        this.m.transform(transformSumLeq);
        if (CmdFlags.getUseMappers()) {
            object = new TransformSumToShift(this.m);
            this.m.transform((TreeTransformer)object);
            treeTransformerBottomUpNoWrapper = new TransformProductToMult(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        if (CmdFlags.getUseMinionMappers()) {
            object = new TransformProductToMultInQSum(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (!CmdFlags.getUseMappers() && !CmdFlags.getUseMinionMappers()) {
            object = new TransformWSumToSum(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.getUseCSE()) {
            object = new CSEClassIdentical();
            ((CSEClassIdentical)object).flattenCSEs(this.m);
            this.m.simplify();
        }
        CmdFlags.setOutputReady(true);
        object = new TransformTimes(this.m);
        this.m.transform((TreeTransformer)object);
        treeTransformerBottomUpNoWrapper = new TransformEqualClass(this.m);
        this.m.transform(treeTransformerBottomUpNoWrapper);
        TransformEqualConstClass transformEqualConstClass = new TransformEqualConstClass();
        this.m.transform(transformEqualConstClass);
        TransformToFlatClass transformToFlatClass = new TransformToFlatClass(this.m);
        this.m.transform(transformToFlatClass);
        TransformConstMatrixClass transformConstMatrixClass = new TransformConstMatrixClass(this.m);
        this.m.transform(transformConstMatrixClass);
        System.out.println("**** Completed class-level flattening ****");
        System.out.println(this.m.toString());
        hashMap = this.m.global_symbols.getDomains();
        for (Map.Entry<String, ASTNode> entry3 : hashMap.entrySet()) {
            if (!(entry3.getValue() instanceof MatrixDomain)) continue;
            boolean bl = false;
            ArrayList<ASTNode> arrayList = ((MatrixDomain)entry3.getValue()).getMDIndexDomains();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get((int)i).getBoundsAST().e1.equals(NumberConstant.make(0L))) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            CmdFlags.println("About to normalise indices of matrix: " + entry3.getKey());
            TransformMatrixIndicesClass transformMatrixIndicesClass = new TransformMatrixIndicesClass(0, this.m, (String)entry3.getKey());
            this.m.transform(transformMatrixIndicesClass);
            System.out.println(this.m.toString());
        }
        this.m.simplify();
        System.out.println("************************");
        System.out.println("**** After Simplify ****");
        System.out.println("************************");
        System.out.println(this.m.toString());
        System.out.println("************************");
        System.out.println("**** Dominion output ***");
        System.out.println("************************");
        entry3 = new StringBuilder();
        this.m.toDominion((StringBuilder)((Object)entry3));
        System.out.println(((StringBuilder)((Object)entry3)).toString());
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(CmdFlags.dominionfile));
            bufferedWriter.append((CharSequence)((Object)entry3));
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("Could not open file for Dominion output.");
        }
    }

    private void fznFlattening() {
        Object object;
        TransformSumEqToSum transformSumEqToSum = new TransformSumEqToSum();
        this.m.transform(transformSumEqToSum);
        TransformReifyMin transformReifyMin = new TransformReifyMin(this.m);
        this.m.transform(transformReifyMin);
        TransformAbsReify transformAbsReify = new TransformAbsReify(this.m);
        this.m.transform(transformAbsReify);
        this.m.simplify();
        TransformCollectBool transformCollectBool = new TransformCollectBool(this.m);
        this.m.transform(transformCollectBool);
        try {
            object = new BufferedWriter(new FileWriter(CmdFlags.fznfile));
            this.m.toFlatzinc((BufferedWriter)object);
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("Could not open file for flatzinc output.");
        }
        CmdFlags.println("Created output file " + CmdFlags.fznfile);
        if (CmdFlags.getRunSolver()) {
            object = new FznSolver();
            try {
                String string = CmdFlags.getGecodetrans() ? CmdFlags.getGecode() : CmdFlags.getChuffed();
                ((FznSolver)object).findSolutions(string, CmdFlags.fznfile, this.m);
            }
            catch (IOException iOException) {
                CmdFlags.errorExit("Could not run flatzinc solver: " + iOException);
            }
            catch (InterruptedException interruptedException) {
                CmdFlags.errorExit("Could not run flatzinc solver: " + interruptedException);
            }
        }
    }

    private void minizincOutput() {
        TransformCollectBool transformCollectBool = new TransformCollectBool(this.m);
        this.m.transform(transformCollectBool);
        StringBuilder stringBuilder = new StringBuilder();
        this.m.toMinizinc(stringBuilder);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(CmdFlags.minizincfile));
            bufferedWriter.append(stringBuilder);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("Could not open file for minizinc output.");
        }
        CmdFlags.println("Created output file " + CmdFlags.minizincfile);
    }

    private void decomposeSatEncoding() {
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper = new TransformAlldiffToSums(this.m);
        this.m.transform(treeTransformerBottomUpNoWrapper);
        treeTransformerBottomUpNoWrapper = new TransformGCCToSums();
        this.m.transform(treeTransformerBottomUpNoWrapper);
        TransformCountToSum transformCountToSum = new TransformCountToSum();
        this.m.transform(transformCountToSum);
        TransformOccurrenceToSum transformOccurrenceToSum = new TransformOccurrenceToSum();
        this.m.transform(transformOccurrenceToSum);
        if (CmdFlags.getSatDecompCSE()) {
            TransformDecomposeLex2 transformDecomposeLex2 = new TransformDecomposeLex2(this.m);
            this.m.transform(transformDecomposeLex2);
        } else {
            TransformDecomposeLex transformDecomposeLex = new TransformDecomposeLex(this.m);
            this.m.transform(transformDecomposeLex);
        }
    }

    private void decomposeSatEncodingFlat() {
        TreeTransformer treeTransformer;
        TransformDecomposeMinMax transformDecomposeMinMax = new TransformDecomposeMinMax(this.m);
        this.m.transform(transformDecomposeMinMax);
        TransformElementForSAT2 transformElementForSAT2 = new TransformElementForSAT2(this.m);
        this.m.transform(transformElementForSAT2);
        if (CmdFlags.getSatAlt()) {
            treeTransformer = new TransformSortWeightedSum2();
            this.m.transform(treeTransformer);
            TransformBreakupSum transformBreakupSum = new TransformBreakupSum(this.m);
            this.m.constraints = transformBreakupSum.transform(this.m.constraints);
        } else {
            TreeTransformer treeTransformer2;
            TreeTransformer treeTransformer3;
            treeTransformer = new TransformSumForSAT();
            this.m.transform(treeTransformer);
            if (CmdFlags.getSatMDD()) {
                treeTransformer3 = new TransformSumEq(false);
                this.m.transform(treeTransformer3);
                treeTransformer2 = new TransformSumToAMOPB();
                this.m.transform(treeTransformer2);
            }
            treeTransformer3 = new TransformEncodeSumSpecial(this.m);
            this.m.simplify();
            treeTransformer2 = new TransformBreakupSum2(this.m);
            this.m.transform(treeTransformer2);
            treeTransformer3 = new TransformSumEq(false);
            this.m.transform(treeTransformer3);
            this.m.transform(treeTransformer);
            treeTransformer2 = new TransformWeightedSumForSAT();
            this.m.transform(treeTransformer2);
        }
        treeTransformer = new TransformToFlat(this.m, false);
        this.m.transform(treeTransformer);
    }

    private void satOutput() {
        Object object;
        boolean bl = this.m.toSAT();
        if (!bl) {
            object = new Stats();
            ((Stats)object).putValue("SavileRowTotalTime", String.valueOf(((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0));
            ((Stats)object).putValue("SavileRowClauseOut", "1");
            ((Stats)object).makeInfoFiles();
            CmdFlags.errorExit("Failed when writing SAT encoding to file.");
        }
        CmdFlags.println("Created output SAT file " + CmdFlags.satfile);
        if (CmdFlags.getRunSolver()) {
            if (CmdFlags.getMaxsattrans()) {
                object = new OpenWBOSATSolver(this.m);
            } else if (CmdFlags.getSatFamily().equals("minisat")) {
                object = new MinisatSATSolver(this.m);
            } else if (CmdFlags.getSatFamily().equals("glucose")) {
                object = new GlucoseSATSolver(this.m);
            } else if (CmdFlags.getSatFamily().equals("nbc_minisat_all") || CmdFlags.getSatFamily().equals("bc_minisat_all")) {
                object = new AllMinisatSATSolver(this.m);
            } else {
                assert (CmdFlags.getSatFamily().equals("lingeling"));
                object = new LingelingSATSolver(this.m);
            }
            try {
                ((SATSolver)object).findSolutions(CmdFlags.getSatSolver(), CmdFlags.satfile, this.m);
            }
            catch (Exception exception) {
                CmdFlags.errorExit("Could not run SAT solver: " + exception);
            }
            File file = new File(CmdFlags.satfile);
            if (file.exists()) {
                file.delete();
            }
        }
    }

    private void satOutputMining() {
        Object object;
        int n;
        ASTNode aSTNode = null;
        ASTNode aSTNode2 = null;
        ASTNode aSTNode3 = MultiStageOnSolution.incl;
        ASTNode aSTNode4 = this.m.constraints.getChild(0);
        if (aSTNode4 instanceof And) {
            for (n = 0; n < aSTNode4.numChildren() && (aSTNode == null || aSTNode3 == null); ++n) {
                if (!(aSTNode4.getChild(n) instanceof MultiStage)) continue;
                aSTNode = aSTNode4.getChild(n).getChild(0);
                aSTNode2 = aSTNode4.getChild(n).getChild(1);
                aSTNode4.setChild(n, new BooleanConstant(true));
            }
        } else if (aSTNode4 instanceof MultiStage) {
            aSTNode = aSTNode4.getChild(0);
            aSTNode2 = aSTNode4.getChild(1);
            this.m.constraints.setChild(0, new BooleanConstant(true));
        }
        if (aSTNode == null) {
            CmdFlags.errorExit("Could not find multiStage function.");
        }
        if (aSTNode3 == null) {
            CmdFlags.errorExit("Could not find multiStageOnSolution function.");
        }
        this.m.simplify();
        n = this.m.toSAT() ? 1 : 0;
        if (n == 0) {
            object = new Stats();
            ((Stats)object).putValue("SavileRowTotalTime", String.valueOf(((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0));
            ((Stats)object).putValue("SavileRowClauseOut", "1");
            ((Stats)object).makeInfoFiles();
            CmdFlags.errorExit("Failed when writing SAT encoding to file.");
        }
        CmdFlags.println("Created output SAT file " + CmdFlags.satfile);
        try {
            SATSolver sATSolver;
            this.m.satModel.BTMark();
            object = aSTNode.getIntervalSetExp();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(CmdFlags.infofile, false));
            bufferedWriter.close();
            if (CmdFlags.getMaxsattrans()) {
                sATSolver = new OpenWBOSATSolver(this.m);
            } else if (CmdFlags.getSatFamily().equals("minisat")) {
                sATSolver = new MinisatSATSolver(this.m);
            } else if (CmdFlags.getSatFamily().equals("glucose")) {
                sATSolver = new GlucoseSATSolver(this.m);
            } else if (CmdFlags.getSatFamily().equals("nbc_minisat_all") || CmdFlags.getSatFamily().equals("bc_minisat_all")) {
                sATSolver = new AllMinisatSATSolver(this.m);
            } else {
                assert (CmdFlags.getSatFamily().equals("lingeling"));
                sATSolver = new LingelingSATSolver(this.m);
            }
            for (int i = 1; i < aSTNode2.numChildren(); ++i) {
                long l = aSTNode2.getChild(i).getValue();
                if (!Intpair.contains((ArrayList<Intpair>)object, l)) continue;
                System.out.println("Looking for itemsets of size: " + l);
                bufferedWriter = new BufferedWriter(new FileWriter(CmdFlags.infofile, true));
                bufferedWriter.write("Cardinality:" + String.valueOf(l) + "\n");
                bufferedWriter.close();
                ASTNode aSTNode5 = new And((ASTNode)new LessEqual(aSTNode, NumberConstant.make(l)), new LessEqual((ASTNode)NumberConstant.make(l), aSTNode));
                this.m.satModel.reopenFile();
                TransformSATEncoding transformSATEncoding = new TransformSATEncoding(this.m);
                if (MultiStageOnSolution.sollist != null) {
                    TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(this.m);
                    TransformSimplify transformSimplify = new TransformSimplify();
                    HashMap<String, ASTNode> hashMap = new HashMap<String, ASTNode>();
                    for (int j = 0; j < MultiStageOnSolution.sollist.size(); ++j) {
                        ASTNode aSTNode6 = MultiStageOnSolution.sollist.get(j);
                        ASTNode aSTNode7 = aSTNode3.copy();
                        for (int k = 0; k < aSTNode6.numChildren(); ++k) {
                            hashMap.put(aSTNode6.getChild(k).getChild(0).toString(), aSTNode6.getChild(k).getChild(1));
                        }
                        TransformSubInSolution transformSubInSolution = new TransformSubInSolution(hashMap);
                        aSTNode7 = transformSubInSolution.transform(aSTNode7);
                        aSTNode7 = transformSimplify.transform(transformQuantifiedExpression.transform(transformSimplify.transform(aSTNode7)));
                        aSTNode7 = transformSATEncoding.transform(aSTNode7);
                        aSTNode7.toSAT(this.m.satModel);
                    }
                }
                this.m.satModel.finaliseOutput();
                this.m.satModel.BTMark();
                if (MultiStageOnSolution.sollist != null) {
                    MultiStageOnSolution.sollist.clear();
                }
                this.m.satModel.reopenFile();
                aSTNode5 = transformSATEncoding.transform(aSTNode5);
                aSTNode5.toSAT(this.m.satModel);
                this.m.satModel.finaliseOutput();
                try {
                    sATSolver.findSolutions(CmdFlags.getSatSolver(), CmdFlags.satfile, this.m);
                }
                catch (Exception exception) {
                    CmdFlags.errorExit("Could not run SAT solver: " + exception);
                }
                this.m.satModel.BTRestore();
            }
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("I/O error during multistage solving.");
        }
    }

    private void processGiven(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getChild(0);
        String string = ((Identifier)aSTNode2).getName();
        ASTNode aSTNode3 = aSTNode.getChild(1);
        if (this.m.global_symbols.hasVariable(string)) {
            CmdFlags.errorExit("Symbol " + string + " declared twice.");
        }
        this.m.global_symbols.newVariable(string, aSTNode3, 1);
        if (!CmdFlags.getDominiontrans()) {
            int n = 0;
            ASTNode aSTNode4 = null;
            for (ASTNode aSTNode5 : this.parameters) {
                if (!((Identifier)((Letting)aSTNode5).getChildren().get(0)).getName().equals(string)) continue;
                aSTNode4 = aSTNode5;
                ++n;
            }
            if (n != 1) {
                CmdFlags.errorExit("Parameter ('given') variable " + string + " is defined " + n + " times in parameter file.");
            }
            this.processLetting(aSTNode4);
            this.parameters.remove(aSTNode4);
        }
    }

    private void processLetting(ASTNode aSTNode) {
        Serializable serializable;
        ASTNode aSTNode2;
        assert (aSTNode instanceof Letting);
        ASTNode aSTNode3 = aSTNode.getChild(0);
        String string = aSTNode3.toString();
        if (this.m.global_symbols.hasVariable(string) && this.m.global_symbols.getCategory(string) != 1) {
            CmdFlags.errorExit("Symbol " + string + " declared more than once.");
        }
        if ((aSTNode2 = aSTNode.getChild(1)).getCategory() > 2) {
            CmdFlags.errorExit("In statement: " + aSTNode, "Right-hand side contains an identifier that is not a constant or parameter.");
        }
        if (this.m.global_symbols.getDomain(string) != null) {
            serializable = this.m.global_symbols.getDomain(string);
            if (((ASTNode)serializable).isSet()) {
                if (aSTNode2.getDimension() > 0 || ((ASTNode)serializable).isBooleanSet() != aSTNode2.isRelation()) {
                    CmdFlags.errorExit("For parameter " + string + ", type of value in parameter file does not match type in given statement.");
                }
            } else {
                assert (serializable instanceof MatrixDomain);
                if (aSTNode2.getDimension() == 0) {
                    CmdFlags.errorExit("For parameter " + string + ", type of value in parameter file does not match type in given statement.");
                }
            }
        }
        if (aSTNode2 instanceof CompoundMatrix || aSTNode2 instanceof EmptyMatrix) {
            this.m.cmstore.newConstantMatrix(string, aSTNode2);
            serializable = this.m.cmstore.makeLettingsConstantMatrix(string);
            Iterator iterator = ((ArrayList)serializable).iterator();
            while (iterator.hasNext()) {
                ASTNode aSTNode4 = (ASTNode)iterator.next();
                this.processLetting(aSTNode4);
            }
            this.m.cmstore.correctIndicesConstantMatrix(string, true);
        } else {
            this.m.substitute(aSTNode.getChild(0), aSTNode2.copy());
        }
    }

    private void processFind(ASTNode aSTNode) {
        assert (aSTNode instanceof Find);
        ASTNode aSTNode2 = aSTNode.getChild(0);
        String string = ((Identifier)aSTNode2).getName();
        if (this.m.global_symbols.hasVariable(string)) {
            CmdFlags.errorExit("Symbol " + string + " declared more than once.");
        }
        if (aSTNode.getChild(1).getCategory() > 2) {
            CmdFlags.errorExit("In statement : " + aSTNode, "Right-hand side contains an identifier that is not a constant or parameter.");
        }
        this.m.global_symbols.newVariable(string, aSTNode.getChild(1), 3);
    }

    private void processWhere(ASTNode aSTNode) {
        if (CmdFlags.getDominiontrans()) {
            return;
        }
        if ((aSTNode = aSTNode.getChild(0)).getCategory() > 2) {
            CmdFlags.errorExit("In statement: where " + aSTNode, "Contains an identifier that is not a constant or parameter.");
        }
        if (!aSTNode.equals(new BooleanConstant(true))) {
            CmdFlags.errorExit("In statement: where " + aSTNode, "Does not evaluate to true.");
        }
    }

    private ASTNode fixIndexDomainsLetting(ASTNode aSTNode) {
        ASTNode aSTNode2;
        if (aSTNode.numChildren() == 3 && ((aSTNode2 = aSTNode.getChild(1)) instanceof CompoundMatrix || aSTNode2 instanceof EmptyMatrix)) {
            Pair<ASTNode, Boolean> pair = ConstantMatrixStore.fixIndicesConstantMatrix(aSTNode.getChild(2), aSTNode2.copy());
            if (pair.getSecond().booleanValue()) {
                CmdFlags.warning("The index domains in the matrix literal do not match");
                CmdFlags.warning("the given matrix domain in the following letting statement:");
                CmdFlags.warning(String.valueOf(aSTNode));
            }
            return new Letting(aSTNode.getChild(0), pair.getFirst());
        }
        return aSTNode;
    }

    public ModelContainer copy() {
        Model model = this.m.copy();
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        TransformFixSTRef transformFixSTRef = new TransformFixSTRef(model);
        for (int i = 0; i < this.parameters.size(); ++i) {
            arrayList.add(transformFixSTRef.transform(this.parameters.get(i)));
        }
        return new ModelContainer(model, arrayList);
    }

    public void writeModelAsJSON(Model model) {
        SymmetryBreaker symmetryBreaker = new SymmetryBreaker();
        symmetryBreaker.detectAndBreakSymmetries(model);
        model.simplify();
    }
}

