/*
 * Decompiled with CFR 0.152.
 */
package savilerow.solver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.model.Model;
import savilerow.solver.LingelingStats;
import savilerow.solver.ReadProcessOutput;
import savilerow.solver.RunCommand;
import savilerow.solver.SATSolver;
import savilerow.solver.Stats;

public class LingelingSATSolver
extends SATSolver {
    public LingelingSATSolver(Model model) {
        super(model);
    }

    @Override
    public Pair<ArrayList<String>, Stats> runSatSolver(String string, String string2, Model model, Stats stats) throws IOException, InterruptedException {
        CmdFlags.runningSolver = true;
        try {
            Object object;
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            ArrayList<String> arrayList2 = new ArrayList<String>(CmdFlags.getSolverExtraFlags());
            if (stats != null && (n = arrayList2.indexOf("-t")) != -1) {
                int n2 = Integer.parseInt(arrayList2.get(n + 1));
                int n3 = n2 - (int)Math.floor(Double.valueOf(stats.getValue("SolverTotalTime"))) + 1;
                if (n3 > n2) {
                    n3 = n2;
                }
                if (n3 < 1) {
                    n3 = 1;
                }
                arrayList2.set(n + 1, String.valueOf(n3));
            }
            arrayList.addAll(arrayList2);
            arrayList.add(string2);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            ReadProcessOutput readProcessOutput = new ReadProcessOutput(arrayList4);
            double d = System.currentTimeMillis();
            int n4 = RunCommand.runCommand(false, arrayList, arrayList3, readProcessOutput);
            if (arrayList3.size() != 0 || n4 != 0 && n4 != 10 && n4 != 20) {
                CmdFlags.println("lingeling exited with error code:" + n4 + " and error message:");
                CmdFlags.println(arrayList3);
            }
            d = ((double)System.currentTimeMillis() - d) / 1000.0;
            LingelingStats lingelingStats = new LingelingStats(arrayList4);
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < arrayList4.size(); ++i) {
                String string3 = arrayList4.get(i);
                if (string3.indexOf("s ") == 0) {
                    object = string3.split(" ");
                    if (object[1].equals("SATISFIABLE")) {
                        bl2 = true;
                        bl = true;
                    } else if (((String)object[1]).equals("UNSATISFIABLE")) {
                        bl2 = false;
                        bl = true;
                    } else if (((String)object[1]).equals("UNKNOWN")) {
                        bl2 = false;
                        bl = false;
                    }
                }
                if (string3.indexOf("c s ") != 0) continue;
                object = string3.split(" ");
                if (object[2].equals("SATISFIABLE")) {
                    bl2 = true;
                    bl = true;
                    continue;
                }
                if (((String)object[2]).equals("UNSATISFIABLE")) {
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (!((String)object[2]).equals("UNKNOWN")) continue;
                bl2 = false;
                bl = false;
            }
            if (bl2) {
                ArrayList<String> arrayList5 = new ArrayList<String>();
                for (int i = 0; i < arrayList4.size(); ++i) {
                    object = arrayList4.get(i);
                    if (((String)object).indexOf("v ") != 0) continue;
                    String[] stringArray = ((String)object).trim().split(" ");
                    arrayList5.addAll(Arrays.asList(stringArray).subList(1, stringArray.length));
                }
                arrayList5.remove(arrayList5.size() - 1);
                return new Pair<ArrayList<String>, Stats>(arrayList5, lingelingStats);
            }
            return new Pair<Object, LingelingStats>(null, lingelingStats);
        }
        catch (Exception exception) {
            System.out.println("Exception." + exception);
            CmdFlags.rmTempFiles();
            return new Pair<Object, Object>(null, null);
        }
    }
}

