/*
 * Decompiled with CFR 0.152.
 */
package savilerow.solver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.model.Model;
import savilerow.solver.OpenWBOStats;
import savilerow.solver.ReadProcessOutput;
import savilerow.solver.RunCommand;
import savilerow.solver.SATSolver;
import savilerow.solver.Stats;

public class OpenWBOSATSolver
extends SATSolver {
    public OpenWBOSATSolver(Model model) {
        super(model);
    }

    @Override
    public Pair<ArrayList<String>, Stats> runSatSolver(String string, String string2, Model model, Stats stats) throws IOException, InterruptedException {
        CmdFlags.runningSolver = true;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            ArrayList<String> arrayList2 = new ArrayList<String>(CmdFlags.getSolverExtraFlags());
            assert (stats == null);
            arrayList.addAll(arrayList2);
            arrayList.add(string2);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            ReadProcessOutput readProcessOutput = new ReadProcessOutput(arrayList4);
            double d = System.currentTimeMillis();
            int n = RunCommand.runCommand(false, arrayList, arrayList3, readProcessOutput);
            if (n != 20 && n != 30) {
                CmdFlags.println("OpenWBO exited with error code:" + n + " and error message:");
                CmdFlags.println(arrayList3);
            }
            boolean bl = n == 20 || n == 30;
            boolean bl2 = n == 30;
            d = ((double)System.currentTimeMillis() - d) / 1000.0;
            OpenWBOStats openWBOStats = new OpenWBOStats(arrayList4);
            openWBOStats.putValue("SolverTotalTime", String.valueOf(d));
            if (bl2) {
                ArrayList<String> arrayList5 = new ArrayList<String>();
                for (int i = 0; i < arrayList4.size(); ++i) {
                    String string3 = arrayList4.get(i);
                    if (string3.indexOf("v ") != 0) continue;
                    String[] stringArray = string3.trim().split(" ");
                    arrayList5.addAll(Arrays.asList(stringArray).subList(1, stringArray.length));
                }
                return new Pair<ArrayList<String>, Stats>(arrayList5, openWBOStats);
            }
            return new Pair<Object, OpenWBOStats>(null, openWBOStats);
        }
        catch (Exception exception) {
            System.out.println("Exception." + exception);
            CmdFlags.rmTempFiles();
            return new Pair<Object, Object>(null, null);
        }
    }
}

