/*
 * Decompiled with CFR 0.152.
 */
package savilerow.treetransformer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import savilerow.CmdFlags;
import savilerow.PersistentCache;
import savilerow.eprimeparser.EPrimeReader;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.MakeTable;
import savilerow.expression.NegativeTable;
import savilerow.expression.NumberConstant;
import savilerow.expression.Or;
import savilerow.expression.Table;
import savilerow.expression.TableShort;
import savilerow.expression.Tag;
import savilerow.model.Model;
import savilerow.treetransformer.NodeReplacement;
import savilerow.treetransformer.ReplaceASTNode;
import savilerow.treetransformer.TransformNormaliseAlpha;
import savilerow.treetransformer.TransformQuantifiedExpression;
import savilerow.treetransformer.TransformShortTableSquash;
import savilerow.treetransformer.TransformSimplify;
import savilerow.treetransformer.TreeTransformerBottomUpNoWrapper;

public class TransformMakeTable
extends TreeTransformerBottomUpNoWrapper {
    public static boolean verbose = false;
    private static boolean twowatchedlits = false;
    private static boolean diskcache = false;
    PersistentCache pcache;
    HashSet<String> failCache;
    HashMap<String, ASTNode> memCache;
    boolean prop;
    long failcount = 0L;
    long impliedcount = 0L;
    private ArrayList<ArrayList<Long>> shortsups;
    private ArrayList<ArrayList<Integer>> var_to_watched_sup;
    ArrayList<boolean[]> current_domains;
    ArrayList<long[]> initial_domains;
    ArrayList<Integer> domsize;
    ArrayList<Integer> watch1;
    ArrayList<Integer> watch2;
    ArrayList<Integer> backtrack_var;
    ArrayList<Integer> backtrack_val;
    ArrayList<Integer> search_assignments;

    public TransformMakeTable(Model model, boolean bl) {
        super(model);
        if (diskcache) {
            this.pcache = new PersistentCache();
        }
        this.failCache = new HashSet();
        this.memCache = new HashMap();
        this.prop = bl;
    }

    public TransformMakeTable(Model model) {
        super(model);
        if (diskcache) {
            this.pcache = new PersistentCache();
        }
        this.failCache = new HashSet();
        this.memCache = new HashMap();
        this.prop = false;
    }

    public void saveToCache(String string, ASTNode aSTNode, ASTNode aSTNode2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("letting tab" + PersistentCache.getHash(string) + " = ");
        ASTNode aSTNode3 = aSTNode2.getChildConst(1);
        if (!aSTNode3.isMatrixLiteral()) {
            System.out.println(aSTNode3.toString());
            CmdFlags.errorExit("Confused ShortTable");
        }
        stringBuilder.append(aSTNode3.toString());
        if (diskcache) {
            this.pcache.addToCache(string, stringBuilder.toString());
        }
    }

    private String decorateExpressionString(ASTNode aSTNode, boolean bl, ArrayList<ASTNode> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl) {
            stringBuilder.append("Long|||");
        } else {
            stringBuilder.append("Short|||");
        }
        stringBuilder.append(aSTNode.toString());
        for (ASTNode aSTNode2 : arrayList) {
            stringBuilder.append("|||");
            stringBuilder.append(aSTNode2);
        }
        return stringBuilder.toString();
    }

    public RetPair tryCache(ASTNode aSTNode, boolean bl) {
        ArrayList<ASTNode> arrayList = this.getVariablesOrdered(aSTNode);
        ArrayList<ASTNode> arrayList2 = this.getDomains(arrayList);
        RetPair retPair = new RetPair();
        retPair.expstring = this.decorateExpressionString(aSTNode, bl, arrayList2);
        String string = null;
        if (diskcache) {
            string = this.pcache.findInCache(retPair.expstring);
        }
        if (string != null) {
            if (verbose) {
                System.out.println("Cache match!");
            }
            EPrimeReader ePrimeReader = new EPrimeReader(string, false);
            ArrayList<ASTNode> arrayList3 = ePrimeReader.readParameterFile(this.m);
            if (verbose) {
                System.out.println("Cache read!");
            }
            ASTNode aSTNode2 = arrayList3.get(0).getChild(1);
            TransformSimplify transformSimplify = new TransformSimplify();
            aSTNode2 = transformSimplify.transform(aSTNode2);
            aSTNode2 = this.m.cmstore.newConstantMatrixDedup(aSTNode2);
            if (!bl) {
                retPair.nodereplace = new NodeReplacement(new Table(this.m, CompoundMatrix.make(arrayList), aSTNode2));
                return retPair;
            }
            retPair.nodereplace = new NodeReplacement(new TableShort(this.m, CompoundMatrix.make(arrayList), aSTNode2));
            return retPair;
        }
        if (verbose) {
            System.out.println("Cache miss");
        }
        return retPair;
    }

    @Override
    protected NodeReplacement processNode(ASTNode aSTNode) {
        boolean bl;
        boolean bl2 = bl = CmdFlags.make_short_tab == 2 || CmdFlags.make_short_tab == 4;
        if (aSTNode instanceof MakeTable) {
            if (CmdFlags.make_short_tab == 0) {
                return new NodeReplacement(aSTNode.getChild(0));
            }
            RetPair retPair = this.tryCacheNormalised(aSTNode.getChild(0), bl);
            if (retPair.nodereplace != null) {
                return retPair.nodereplace;
            }
            ASTNode aSTNode2 = this.normalise(aSTNode.getChild(0));
            ASTNode aSTNode3 = !bl ? this.makeTableLong(aSTNode2, Long.MAX_VALUE, Long.MAX_VALUE) : this.makeTableShort(aSTNode2, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
            this.saveToCacheNormalised(retPair.expstring, aSTNode2, aSTNode3);
            return new NodeReplacement(aSTNode3);
        }
        if (!(this.prop || CmdFlags.make_short_tab != 3 && CmdFlags.make_short_tab != 4 || aSTNode instanceof And || aSTNode.getParent() == null || !aSTNode.getParent().inTopAnd() || aSTNode instanceof Tag || !aSTNode.isRelation() || aSTNode instanceof Table || aSTNode instanceof TableShort || aSTNode instanceof NegativeTable || aSTNode instanceof BooleanConstant || !this.heuristic(aSTNode))) {
            if (verbose) {
                System.out.println("Trying ct:" + aSTNode);
            }
            RetPair retPair = this.tryCacheNormalised(aSTNode, bl);
            if (retPair.nodereplace != null) {
                return retPair.nodereplace;
            }
            if (this.failCache.contains(retPair.expstring)) {
                return new NodeReplacement(new Tag(aSTNode));
            }
            ASTNode aSTNode4 = this.normalise(aSTNode);
            ASTNode aSTNode5 = CmdFlags.make_short_tab == 3 ? this.makeTableLong(aSTNode4, 10000L, 100000L) : this.makeTableShort(aSTNode4, 10000L, 100000L, 100000L);
            if (aSTNode5 == null) {
                this.failCache.add(retPair.expstring);
                if (verbose) {
                    System.out.println("Adding to failCache:" + retPair.expstring);
                }
                return new NodeReplacement(new Tag(aSTNode));
            }
            this.saveToCacheNormalised(retPair.expstring, aSTNode4, aSTNode5);
            return new NodeReplacement(aSTNode5);
        }
        return null;
    }

    private boolean heuristic(ASTNode aSTNode) {
        ASTNode aSTNode2;
        ArrayList<ASTNode> arrayList = this.getVariablesOrdered(aSTNode);
        ArrayList<ASTNode> arrayList2 = this.getVariablesDup(aSTNode);
        if (arrayList.size() < arrayList2.size() && arrayList.size() <= 10) {
            if (verbose) {
                System.out.println("H1");
            }
            return true;
        }
        if (aSTNode.treesize() > 5 * arrayList.size()) {
            if (verbose) {
                System.out.println("H2");
            }
            return true;
        }
        if (!aSTNode.strongProp() && arrayList.size() <= 10 && (aSTNode2 = this.m.constraints.getChild(0)) instanceof And) {
            for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                ASTNode aSTNode3 = aSTNode2.getChild(i);
                if (!aSTNode3.strongProp()) continue;
                for (int j = 0; j < arrayList.size(); ++j) {
                    if (!aSTNode3.contains(arrayList.get(j))) continue;
                    if (verbose) {
                        System.out.println("H3");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public ASTNode makeTableShort(ASTNode aSTNode, long l, long l2, long l3) {
        int n;
        ArrayList<ASTNode> arrayList;
        ArrayList<ASTNode> arrayList2;
        int n2;
        TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(this.m);
        aSTNode = transformQuantifiedExpression.transform(aSTNode);
        ArrayList<ASTNode> arrayList3 = this.getVariablesOrdered(aSTNode);
        if (verbose) {
            System.out.println("Expression:" + aSTNode);
        }
        if (verbose) {
            System.out.println("Variables:" + arrayList3);
        }
        ArrayList<ASTNode> arrayList4 = this.getDomains(arrayList3);
        if (twowatchedlits) {
            this.setupShortSupports2(arrayList3.size(), arrayList4);
        } else {
            this.setupShortSupports(arrayList3.size());
        }
        this.failcount = 0L;
        this.impliedcount = 0L;
        boolean bl = false;
        if (aSTNode instanceof Or) {
            bl = true;
            for (n2 = 0; n2 < aSTNode.numChildren(); ++n2) {
                arrayList2 = this.getVariablesOrdered(aSTNode.getChild(n2));
                if (arrayList2.size() != arrayList3.size()) continue;
                bl = false;
                break;
            }
        }
        if (bl = false) {
            if (verbose) {
                System.out.println("Decomposing disjunction!");
            }
            for (n2 = 0; n2 < aSTNode.numChildren(); ++n2) {
                if (verbose) {
                    System.out.println("Doing disjunct " + n2 + ":" + aSTNode.getChild(n2));
                }
                arrayList2 = this.getVariablesOrdered(aSTNode.getChild(n2));
                ArrayList<Long> arrayList5 = new ArrayList<Long>(Collections.nCopies(arrayList3.size(), Long.MIN_VALUE));
                arrayList = new ArrayList(arrayList3.size());
                for (n = 0; n < arrayList2.size(); ++n) {
                    arrayList.add((ASTNode)((Object)Integer.valueOf(arrayList3.indexOf(arrayList2.get(n)))));
                }
                for (n = 0; n < arrayList3.size(); ++n) {
                    if (arrayList.indexOf(n) != -1) continue;
                    arrayList.add((ASTNode)((Object)Integer.valueOf(n)));
                }
                n = this.DFS(arrayList3, arrayList4, aSTNode, aSTNode, arrayList5, arrayList, -1, l, l2, l3, arrayList2.size()) ? 1 : 0;
                if (verbose) {
                    System.out.println("Stats of one disjunct: " + this.failcount + " " + this.impliedcount + " " + this.shortsups.size() + " " + (n != 0));
                }
                if (n != 0) continue;
                return null;
            }
        } else {
            int n3;
            ArrayList<Long> arrayList6 = new ArrayList<Long>(Collections.nCopies(arrayList3.size(), Long.MIN_VALUE));
            arrayList2 = new ArrayList(arrayList3.size());
            for (n3 = 0; n3 < arrayList3.size(); n3 += 1) {
                arrayList2.add((ASTNode)((Object)Integer.valueOf(n3)));
            }
            n3 = this.DFS(arrayList3, arrayList4, aSTNode, aSTNode, arrayList6, arrayList2, -1, l, l2, l3, Integer.MAX_VALUE) ? 1 : 0;
            if (verbose) {
                System.out.println("Stats: " + this.failcount + " " + this.impliedcount + " " + this.shortsups.size() + " " + (n3 != 0));
            }
            if (!n3) {
                return null;
            }
        }
        ArrayList<ASTNode> arrayList7 = new ArrayList<ASTNode>();
        for (int i = 0; i < this.shortsups.size(); ++i) {
            ArrayList<Long> arrayList8 = this.shortsups.get(i);
            arrayList = new ArrayList<ASTNode>();
            for (n = 0; n < arrayList8.size(); ++n) {
                if (arrayList8.get(n) == Long.MIN_VALUE) continue;
                arrayList.add(CompoundMatrix.make(NumberConstant.make(n + 1), NumberConstant.make(arrayList8.get(n))));
            }
            arrayList7.add(CompoundMatrix.make(arrayList));
        }
        ASTNode aSTNode2 = CompoundMatrix.make(arrayList7);
        ArrayList<ArrayList<Intpair>> arrayList9 = new ArrayList<ArrayList<Intpair>>(arrayList4.size());
        for (int i = 0; i < arrayList4.size(); ++i) {
            arrayList9.add(arrayList4.get(i).getIntervalSet());
        }
        ASTNode aSTNode3 = TransformShortTableSquash.compressShortTab(aSTNode2, arrayList9);
        if (aSTNode3 != null) {
            CmdFlags.printlnIfVerbose("In: " + aSTNode2 + "\n\n" + arrayList9);
            CmdFlags.printlnIfVerbose("Out: " + aSTNode3.numChildren());
            aSTNode2 = aSTNode3;
        }
        aSTNode2 = this.m.cmstore.newConstantMatrixDedup(aSTNode2);
        return new TableShort(this.m, CompoundMatrix.make(arrayList3), aSTNode2);
    }

    public ASTNode makeTableLong(ASTNode aSTNode, long l, long l2) {
        TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(this.m);
        aSTNode = transformQuantifiedExpression.transform(aSTNode);
        ArrayList<ASTNode> arrayList = this.getVariablesOrdered(aSTNode);
        ArrayList<ASTNode> arrayList2 = this.getDomains(arrayList);
        this.setupShortSupports(arrayList.size());
        this.failcount = 0L;
        boolean bl = this.DFSfull(arrayList, arrayList2, aSTNode, new ArrayList<Long>(), l, l2);
        if (verbose && !bl) {
            System.out.println("DFS hit some limit.");
        }
        if (!bl) {
            return null;
        }
        ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
        for (int i = 0; i < this.shortsups.size(); ++i) {
            ArrayList<Long> arrayList4 = this.shortsups.get(i);
            ArrayList<ASTNode> arrayList5 = new ArrayList<ASTNode>(arrayList.size());
            for (int j = 0; j < arrayList4.size(); ++j) {
                arrayList5.add(NumberConstant.make(arrayList4.get(j)));
            }
            arrayList3.add(CompoundMatrix.make(arrayList5));
        }
        ASTNode aSTNode2 = CompoundMatrix.make(arrayList3);
        aSTNode2 = this.m.cmstore.newConstantMatrixDedup(aSTNode2);
        return new Table(this.m, CompoundMatrix.make(arrayList), aSTNode2);
    }

    public ArrayList<ASTNode> getVariablesDup(ASTNode aSTNode) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        this.getVariablesDupInner(aSTNode, arrayList);
        return arrayList;
    }

    private void getVariablesDupInner(ASTNode aSTNode, ArrayList<ASTNode> arrayList) {
        if (aSTNode instanceof Identifier && aSTNode.getCategory() > 0) {
            arrayList.add(aSTNode);
        } else {
            for (int i = 0; i < aSTNode.numChildren(); ++i) {
                this.getVariablesDupInner(aSTNode.getChild(i), arrayList);
            }
        }
    }

    public ArrayList<ASTNode> getVariablesOrdered(ASTNode aSTNode) {
        HashSet<ASTNode> hashSet = new HashSet<ASTNode>();
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        this.getVariablesOrderedInner(aSTNode, hashSet, arrayList);
        return arrayList;
    }

    private void getVariablesOrderedInner(ASTNode aSTNode, HashSet<ASTNode> hashSet, ArrayList<ASTNode> arrayList) {
        if (aSTNode instanceof Identifier && aSTNode.getCategory() > 0) {
            if (!hashSet.contains(aSTNode)) {
                hashSet.add(aSTNode);
                arrayList.add(aSTNode);
            }
        } else {
            for (int i = 0; i < aSTNode.numChildren(); ++i) {
                this.getVariablesOrderedInner(aSTNode.getChild(i), hashSet, arrayList);
            }
        }
    }

    public ArrayList<ASTNode> getDomains(ArrayList<ASTNode> arrayList) {
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        TransformSimplify transformSimplify = new TransformSimplify();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList2.add(transformSimplify.transform(this.m.global_symbols.getDomain(arrayList.get(i).toString())));
        }
        return arrayList2;
    }

    public ASTNode normalise(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.copy();
        TransformNormaliseAlpha transformNormaliseAlpha = new TransformNormaliseAlpha(this.m);
        aSTNode2 = transformNormaliseAlpha.transform(aSTNode2);
        return aSTNode2;
    }

    public RetPair tryCacheNormalised(ASTNode aSTNode, boolean bl) {
        Object object;
        ASTNode aSTNode2 = this.normalise(aSTNode);
        if (verbose) {
            CmdFlags.println("In tryCacheNormalised:" + aSTNode2);
        }
        ArrayList<ASTNode> arrayList = this.getVariablesOrdered(aSTNode2);
        ArrayList<ASTNode> arrayList2 = this.getDomains(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            object = new ReplaceASTNode(arrayList.get(i), new Identifier(this.m, "xxxx_" + i));
            aSTNode2 = ((TreeTransformerBottomUpNoWrapper)object).transform(aSTNode2);
        }
        RetPair retPair = new RetPair();
        retPair.expstring = this.decorateExpressionString(aSTNode2, bl, arrayList2);
        object = this.memCache.get(retPair.expstring);
        if (object != null) {
            assert (object instanceof Identifier);
            if (verbose) {
                System.out.println("Memory cache read!");
            }
            retPair.nodereplace = !bl ? new NodeReplacement(new Table(this.m, CompoundMatrix.make(arrayList), (ASTNode)object)) : new NodeReplacement(new TableShort(this.m, CompoundMatrix.make(arrayList), (ASTNode)object));
            return retPair;
        }
        String string = null;
        if (diskcache) {
            string = this.pcache.findInCache(retPair.expstring);
        }
        if (string != null) {
            if (verbose) {
                System.out.println("Cache match!");
            }
            EPrimeReader ePrimeReader = new EPrimeReader(string, false);
            ArrayList<ASTNode> arrayList3 = ePrimeReader.readParameterFile(this.m);
            if (verbose) {
                System.out.println("Cache read!");
            }
            ASTNode aSTNode3 = arrayList3.get(0).getChild(1);
            TransformSimplify transformSimplify = new TransformSimplify();
            aSTNode3 = transformSimplify.transform(aSTNode3);
            aSTNode3 = this.m.cmstore.newConstantMatrixDedup(aSTNode3);
            this.memCache.put(retPair.expstring, aSTNode3);
            retPair.nodereplace = !bl ? new NodeReplacement(new Table(this.m, CompoundMatrix.make(arrayList), aSTNode3)) : new NodeReplacement(new TableShort(this.m, CompoundMatrix.make(arrayList), aSTNode3));
            return retPair;
        }
        if (verbose) {
            System.out.println("Cache miss");
        }
        return retPair;
    }

    public void saveToCacheNormalised(String string, ASTNode aSTNode, ASTNode aSTNode2) {
        Object object;
        ArrayList<ASTNode> arrayList = this.getVariablesOrdered(aSTNode);
        ArrayList<ASTNode> arrayList2 = this.getDomains(arrayList);
        ASTNode aSTNode3 = aSTNode.copy();
        for (int i = 0; i < arrayList.size(); ++i) {
            object = new ReplaceASTNode(arrayList.get(i), new Identifier(this.m, "xxxx_" + i));
            aSTNode3 = ((TreeTransformerBottomUpNoWrapper)object).transform(aSTNode3);
        }
        if (string == null) {
            string = this.decorateExpressionString(aSTNode3, aSTNode2 instanceof TableShort, arrayList2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("letting tab" + PersistentCache.getHash(string) + " = ");
        object = aSTNode2.getChildConst(1);
        if (!((ASTNode)object).isMatrixLiteral()) {
            System.out.println(((ASTNode)object).toString());
            CmdFlags.errorExit("Confused ShortTable");
        }
        stringBuilder.append(((ASTNode)object).toString());
        if (diskcache) {
            this.pcache.addToCache(string, stringBuilder.toString());
        }
        assert (aSTNode2.getChild(1) instanceof Identifier);
        this.memCache.put(string, aSTNode2.getChild(1));
    }

    void promoteIdx(ArrayList<Integer> arrayList, int n) {
        if (n != -1) {
            int n2 = arrayList.indexOf(n);
            int n3 = arrayList.get(n2);
            for (int i = n2; i > 0; --i) {
                arrayList.set(i, arrayList.get(i - 1));
            }
            arrayList.set(0, n3);
        }
    }

    private boolean DFS(ArrayList<ASTNode> arrayList, ArrayList<ASTNode> arrayList2, ASTNode aSTNode, ASTNode aSTNode2, ArrayList<Long> arrayList3, ArrayList<Integer> arrayList4, int n, long l, long l2, long l3, int n2) {
        int n3;
        int n4;
        if (!twowatchedlits && this.checkShortSupports(arrayList3, n)) {
            ++this.impliedcount;
            return this.impliedcount < l3;
        }
        if (twowatchedlits && this.checkShortSupports2(arrayList3, n)) {
            ++this.impliedcount;
            return this.impliedcount < l3;
        }
        if (aSTNode2 instanceof BooleanConstant) {
            this.promoteIdx(arrayList4, n);
            if (aSTNode2.getValue() == 1L) {
                if (!twowatchedlits) {
                    this.addShortSupport(arrayList, aSTNode, arrayList3, n);
                } else {
                    this.addShortSupport2(arrayList, aSTNode, arrayList3, n);
                }
                return (long)this.shortsups.size() <= l;
            }
            ++this.failcount;
            return this.failcount < l2;
        }
        if (n2 < arrayList3.size()) {
            n4 = 0;
            for (n3 = 0; n3 < arrayList3.size(); ++n3) {
                if (arrayList3.get(n3) == Long.MIN_VALUE) continue;
                ++n4;
            }
            if (n4 >= n2) {
                return true;
            }
        }
        n4 = -1;
        for (n3 = 0; n3 < arrayList4.size(); ++n3) {
            if (arrayList3.get(arrayList4.get(n3)) != Long.MIN_VALUE) continue;
            n4 = arrayList4.get(n3);
            break;
        }
        ASTNode aSTNode3 = arrayList.get(n4);
        TransformSimplify transformSimplify = new TransformSimplify();
        if (!twowatchedlits) {
            ArrayList<Long> arrayList5 = arrayList2.get(n4).getValueSet();
            for (int i = 0; i < arrayList5.size(); ++i) {
                ASTNode aSTNode4 = aSTNode2.copy();
                aSTNode4 = this.assignValue(aSTNode4, aSTNode3, arrayList5.get(i));
                aSTNode4 = transformSimplify.transform(aSTNode4);
                arrayList3.set(n4, arrayList5.get(i));
                boolean bl = this.DFS(arrayList, arrayList2, aSTNode, aSTNode4, arrayList3, arrayList4, n4, l, l2, l3, n2);
                if (!bl) {
                    return false;
                }
                arrayList3.set(n4, Long.MIN_VALUE);
            }
        } else {
            long[] lArray = this.initial_domains.get(n4);
            boolean[] blArray = this.current_domains.get(n4);
            for (int i = 0; i < lArray.length; ++i) {
                if (!blArray[i]) continue;
                ASTNode aSTNode5 = aSTNode2.copy();
                aSTNode5 = this.assignValue(aSTNode5, aSTNode3, lArray[i]);
                aSTNode5 = transformSimplify.transform(aSTNode5);
                arrayList3.set(n4, lArray[i]);
                this.BTMark();
                this.assign(n4, i);
                boolean bl = this.DFS(arrayList, arrayList2, aSTNode, aSTNode5, arrayList3, arrayList4, n4, l, l2, l3, n2);
                arrayList3.set(n4, Long.MIN_VALUE);
                this.BTRevert();
                this.unassign(n4);
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    private void setupShortSupports(int n) {
        this.shortsups = new ArrayList();
        this.var_to_watched_sup = new ArrayList();
        for (int i = 0; i < n; ++i) {
            this.var_to_watched_sup.add(new ArrayList());
        }
    }

    private void addShortSupport(ArrayList<ASTNode> arrayList, ASTNode aSTNode, ArrayList<Long> arrayList2, int n) {
        int n2;
        ArrayList<Long> arrayList3 = new ArrayList<Long>(arrayList2);
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        for (n2 = 0; n2 < arrayList3.size(); ++n2) {
            if (arrayList3.get(n2) == Long.MIN_VALUE) continue;
            arrayList4.add(n2);
        }
        this.shortSupportMinDivideConquer(0, arrayList4.size(), arrayList4, arrayList, aSTNode, arrayList3, n);
        assert (arrayList3.get(n) != Long.MIN_VALUE);
        if (verbose) {
            System.out.print("Adding short support: ");
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                System.out.print((arrayList3.get(n2) != Long.MIN_VALUE ? String.valueOf(arrayList3.get(n2)) : "*") + " ");
            }
            System.out.println(" " + this.failcount + " " + this.impliedcount + " " + this.shortsups.size());
        }
        this.shortsups.add(arrayList3);
        this.var_to_watched_sup.get(n).add(this.shortsups.size() - 1);
    }

    private void shortSupportMinDivideConquer(int n, int n2, ArrayList<Integer> arrayList, ArrayList<ASTNode> arrayList2, ASTNode aSTNode, ArrayList<Long> arrayList3, int n3) {
        int n4;
        int n5;
        int n6;
        if (n2 == n + 1) {
            return;
        }
        TransformSimplify transformSimplify = new TransformSimplify();
        int n7 = (n2 - n) / 2 + n;
        ASTNode aSTNode2 = aSTNode.copy();
        for (n6 = n7; n6 < n2; ++n6) {
            n5 = arrayList.get(n6);
            if (arrayList3.get(n5) == Long.MIN_VALUE) continue;
            this.assignValue(aSTNode2, arrayList2.get(n5), arrayList3.get(n5));
        }
        if ((aSTNode2 = transformSimplify.transform(aSTNode2)) instanceof BooleanConstant) {
            assert (aSTNode2.getValue() == 1L);
            for (n6 = n; n6 < n7; ++n6) {
                n5 = arrayList.get(n6);
                arrayList3.set(n5, Long.MIN_VALUE);
            }
        } else {
            this.shortSupportMinDivideConquer(n, n7, arrayList, arrayList2, aSTNode2, arrayList3, n3);
        }
        ASTNode aSTNode3 = aSTNode.copy();
        for (n5 = n; n5 < n7; ++n5) {
            n4 = arrayList.get(n5);
            if (arrayList3.get(n4) == Long.MIN_VALUE) continue;
            this.assignValue(aSTNode3, arrayList2.get(n4), arrayList3.get(n4));
        }
        if ((aSTNode3 = transformSimplify.transform(aSTNode3)) instanceof BooleanConstant) {
            assert (aSTNode3.getValue() == 1L);
            for (n5 = n7; n5 < n2; ++n5) {
                n4 = arrayList.get(n5);
                arrayList3.set(n4, Long.MIN_VALUE);
            }
        } else {
            this.shortSupportMinDivideConquer(n7, n2, arrayList, arrayList2, aSTNode3, arrayList3, n3);
        }
    }

    private void shortSupportMinLinear(ArrayList<ASTNode> arrayList, ASTNode aSTNode, ArrayList<Long> arrayList2, int n) {
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (i == n || arrayList2.get(i) == Long.MIN_VALUE) continue;
            ASTNode aSTNode2 = aSTNode.copy();
            for (int j = 0; j < arrayList2.size(); ++j) {
                if (j == i || arrayList2.get(j) == Long.MIN_VALUE) continue;
                aSTNode2 = this.assignValue(aSTNode2, arrayList.get(j), arrayList2.get(j));
            }
            TransformSimplify transformSimplify = new TransformSimplify();
            if (!((aSTNode2 = transformSimplify.transform(aSTNode2)) instanceof BooleanConstant)) continue;
            assert (aSTNode2.getValue() == 1L);
            arrayList2.set(i, Long.MIN_VALUE);
        }
    }

    private ASTNode assignValue(ASTNode aSTNode, ASTNode aSTNode2, long l) {
        ReplaceASTNode replaceASTNode = aSTNode2.isRelation() ? new ReplaceASTNode(aSTNode2, new BooleanConstant(l == 1L)) : new ReplaceASTNode(aSTNode2, NumberConstant.make(l));
        return replaceASTNode.transform(aSTNode);
    }

    private boolean checkShortSupports(ArrayList<Long> arrayList, int n) {
        if (n == -1) {
            return false;
        }
        long l = arrayList.get(n);
        ArrayList<Integer> arrayList2 = this.var_to_watched_sup.get(n);
        for (int i = arrayList2.size() - 1; i >= 0; --i) {
            int n2;
            int n3 = arrayList2.get(i);
            ArrayList<Long> arrayList3 = this.shortsups.get(n3);
            assert (arrayList3.get(n) != Long.MIN_VALUE);
            if (arrayList3.get(n) != l) continue;
            boolean bl = false;
            for (n2 = n + 1; n2 < arrayList3.size() && !bl; ++n2) {
                if (arrayList3.get(n2) == Long.MIN_VALUE || arrayList.get(n2) != Long.MIN_VALUE && arrayList3.get(n2) == arrayList.get(n2)) continue;
                bl = true;
                arrayList2.set(i, arrayList2.get(arrayList2.size() - 1));
                arrayList2.remove(arrayList2.size() - 1);
                this.var_to_watched_sup.get(n2).add(n3);
            }
            for (n2 = 0; n2 < n && !bl; ++n2) {
                if (arrayList3.get(n2) == Long.MIN_VALUE || arrayList.get(n2) != Long.MIN_VALUE && arrayList3.get(n2) == arrayList.get(n2)) continue;
                bl = true;
                arrayList2.set(i, arrayList2.get(arrayList2.size() - 1));
                arrayList2.remove(arrayList2.size() - 1);
                this.var_to_watched_sup.get(n2).add(n3);
            }
            if (bl) continue;
            return true;
        }
        return false;
    }

    private void setupShortSupports2(int n, ArrayList<ASTNode> arrayList) {
        int n2;
        this.initial_domains = new ArrayList();
        this.current_domains = new ArrayList();
        this.backtrack_var = new ArrayList();
        this.backtrack_val = new ArrayList();
        this.search_assignments = new ArrayList();
        this.watch1 = new ArrayList();
        this.watch2 = new ArrayList();
        this.domsize = new ArrayList();
        for (n2 = 0; n2 < n; ++n2) {
            ArrayList<Intpair> arrayList2 = arrayList.get(n2).getIntervalSet();
            long[] lArray = new long[(int)Intpair.numValues(arrayList2)];
            boolean[] blArray = new boolean[lArray.length];
            int n3 = 0;
            for (int i = 0; i < arrayList2.size(); ++i) {
                long l = arrayList2.get((int)i).lower;
                while (l <= arrayList2.get((int)i).upper) {
                    lArray[n3] = l++;
                    blArray[n3] = true;
                    ++n3;
                }
            }
            this.initial_domains.add(lArray);
            this.current_domains.add(blArray);
            this.domsize.add(lArray.length);
        }
        this.shortsups = new ArrayList();
        this.var_to_watched_sup = new ArrayList();
        for (n2 = 0; n2 < n; ++n2) {
            this.var_to_watched_sup.add(new ArrayList());
        }
    }

    private void addShortSupport2(ArrayList<ASTNode> arrayList, ASTNode aSTNode, ArrayList<Long> arrayList2, int n) {
        int n2;
        ArrayList<Long> arrayList3 = new ArrayList<Long>(arrayList2);
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        for (n2 = 0; n2 < arrayList3.size(); ++n2) {
            if (arrayList3.get(n2) == Long.MIN_VALUE) continue;
            arrayList4.add(n2);
        }
        this.shortSupportMinDivideConquer(0, arrayList4.size(), arrayList4, arrayList, aSTNode, arrayList3, n);
        assert (arrayList3.get(n) != Long.MIN_VALUE);
        if (verbose) {
            System.out.print("Adding short support: ");
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                System.out.print((arrayList3.get(n2) != Long.MIN_VALUE ? String.valueOf(arrayList3.get(n2)) : "*") + " ");
            }
            System.out.println(" " + this.failcount + " " + this.impliedcount + " " + this.shortsups.size());
        }
        n2 = this.shortsups.size();
        this.shortsups.add(arrayList3);
        this.var_to_watched_sup.get(n).add(n2);
        this.watch1.add(n);
        for (int i = this.search_assignments.size() - 1; i >= 0; --i) {
            int n3 = this.search_assignments.get(i);
            if (n3 == n || arrayList3.size() <= n3 || arrayList3.get(n3) == Long.MIN_VALUE) continue;
            this.var_to_watched_sup.get(n3).add(n2);
            this.watch2.add(n3);
            return;
        }
        assert (arrayList3.size() == 1);
        this.var_to_watched_sup.get(n).add(n2);
        this.watch2.add(n);
    }

    private boolean checkShortSupports2(ArrayList<Long> arrayList, int n) {
        if (n == -1) {
            return false;
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        boolean[] blArray = new boolean[arrayList.size()];
        blArray[n] = true;
        arrayList2.add(n);
        while (arrayList2.size() > 0) {
            int n2 = (Integer)arrayList2.remove(arrayList2.size() - 1);
            blArray[n2] = false;
            ArrayList<Integer> arrayList3 = this.var_to_watched_sup.get(n2);
            for (int i = arrayList3.size() - 1; i >= 0; --i) {
                int n3;
                long l;
                int n4;
                boolean bl;
                int n5 = arrayList3.get(i);
                ArrayList<Long> arrayList4 = this.shortsups.get(n5);
                assert (arrayList4.get(n2) != Long.MIN_VALUE);
                int n6 = Arrays.binarySearch(this.initial_domains.get(n2), arrayList4.get(n2));
                if (!this.current_domains.get(n2)[n6] || this.domsize.get(n2) != 1) continue;
                int n7 = this.watch1.get(n5);
                int n8 = this.watch2.get(n5);
                if (n7 == n2) {
                    bl = false;
                    for (n4 = 0; n4 < arrayList4.size(); ++n4) {
                        if (n4 == n8 || arrayList4.get(n4) == Long.MIN_VALUE) continue;
                        l = arrayList4.get(n4);
                        n3 = Arrays.binarySearch(this.initial_domains.get(n4), l);
                        if (this.current_domains.get(n4)[n3] && this.domsize.get(n4) <= 1) continue;
                        n7 = n4;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        n4 = Arrays.binarySearch(this.initial_domains.get(n8), arrayList4.get(n8));
                        if (this.current_domains.get(n8)[n4]) {
                            this.pruneValidx(n8, n4);
                            if (this.domsize.get(n8) == 0) {
                                return true;
                            }
                            if (!blArray[n8]) {
                                blArray[n8] = true;
                                arrayList2.add(n8);
                            }
                        }
                    } else {
                        this.watch1.set(n5, n7);
                        arrayList3.set(i, arrayList3.get(arrayList3.size() - 1));
                        arrayList3.remove(arrayList3.size() - 1);
                        this.var_to_watched_sup.get(n7).add(n5);
                    }
                }
                if (n8 != n2) continue;
                bl = false;
                for (n4 = 0; n4 < arrayList4.size(); ++n4) {
                    if (n4 == n7 || arrayList4.get(n4) == Long.MIN_VALUE) continue;
                    l = arrayList4.get(n4);
                    n3 = Arrays.binarySearch(this.initial_domains.get(n4), l);
                    if (this.current_domains.get(n4)[n3] && this.domsize.get(n4) <= 1) continue;
                    n8 = n4;
                    bl = true;
                    break;
                }
                if (!bl) {
                    n4 = Arrays.binarySearch(this.initial_domains.get(n7), arrayList4.get(n7));
                    if (!this.current_domains.get(n7)[n4]) continue;
                    this.pruneValidx(n7, n4);
                    if (this.domsize.get(n7) == 0) {
                        return true;
                    }
                    if (blArray[n7]) continue;
                    blArray[n7] = true;
                    arrayList2.add(n7);
                    continue;
                }
                this.watch2.set(n5, n8);
                if (arrayList3.size() > i && arrayList3.get(i) == n5) {
                    arrayList3.set(i, arrayList3.get(arrayList3.size() - 1));
                    arrayList3.remove(arrayList3.size() - 1);
                }
                this.var_to_watched_sup.get(n8).add(n5);
            }
        }
        return false;
    }

    private void BTMark() {
        this.backtrack_var.add(null);
        this.backtrack_val.add(null);
    }

    private void BTRevert() {
        while (this.backtrack_var.size() > 0) {
            Integer n = this.backtrack_var.remove(this.backtrack_var.size() - 1);
            Integer n2 = this.backtrack_val.remove(this.backtrack_val.size() - 1);
            if (n == null) {
                return;
            }
            this.current_domains.get((int)n.intValue())[n2.intValue()] = true;
            this.domsize.set(n, this.domsize.get(n) + 1);
        }
    }

    private boolean prune(int n, long l) {
        int n2 = Arrays.binarySearch(this.initial_domains.get(n), l);
        return this.pruneValidx(n, n2);
    }

    private boolean pruneValidx(int n, int n2) {
        if (this.current_domains.get(n)[n2]) {
            this.current_domains.get((int)n)[n2] = false;
            this.backtrack_var.add(n);
            this.backtrack_val.add(n2);
            this.domsize.set(n, this.domsize.get(n) - 1);
            return this.domsize.get(n) > 0;
        }
        return true;
    }

    private void assign(int n, int n2) {
        boolean[] blArray = this.current_domains.get(n);
        assert (blArray[n2]);
        for (int i = 0; i < blArray.length; ++i) {
            if (i != n2 && blArray[i]) assert (this.pruneValidx(n, i));
        }
        assert (this.domsize.get(n) == 1);
        this.search_assignments.add(n);
    }

    private void unassign(int n) {
        int n2 = this.search_assignments.remove(this.search_assignments.size() - 1);
        assert (n == n2);
    }

    private boolean DFSfull(ArrayList<ASTNode> arrayList, ArrayList<ASTNode> arrayList2, ASTNode aSTNode, ArrayList<Long> arrayList3, long l, long l2) {
        int n = arrayList3.size();
        if (aSTNode instanceof BooleanConstant) {
            if (n == arrayList.size() && aSTNode.getValue() == 1L) {
                this.shortsups.add(new ArrayList<Long>(arrayList3));
                if (verbose && (long)this.shortsups.size() > l) {
                    System.out.println("DFS hit supports limit");
                }
                return (long)this.shortsups.size() <= l;
            }
            if (aSTNode.getValue() == 0L) {
                ++this.failcount;
                if (verbose && this.failcount > l2) {
                    System.out.println("DFS hit fail limit");
                }
                return this.failcount <= l2;
            }
        }
        ASTNode aSTNode2 = arrayList.get(n);
        ArrayList<Long> arrayList4 = arrayList2.get(n).getValueSet();
        TransformSimplify transformSimplify = new TransformSimplify();
        for (int i = 0; i < arrayList4.size(); ++i) {
            ASTNode aSTNode3 = aSTNode.copy();
            aSTNode3 = this.assignValue(aSTNode3, aSTNode2, arrayList4.get(i));
            aSTNode3 = transformSimplify.transform(aSTNode3);
            arrayList3.add(arrayList4.get(i));
            boolean bl = this.DFSfull(arrayList, arrayList2, aSTNode3, arrayList3, l, l2);
            if (!bl) {
                return false;
            }
            arrayList3.remove(arrayList3.size() - 1);
        }
        return true;
    }

    public class RetPair {
        public String expstring;
        public NodeReplacement nodereplace;
    }
}

