/*
 * Decompiled with CFR 0.152.
 */
package savilerow.treetransformer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.NegativeTable;
import savilerow.expression.Table;
import savilerow.expression.TableShort;
import savilerow.expression.Tag;
import savilerow.model.Model;
import savilerow.treetransformer.NodeReplacement;
import savilerow.treetransformer.TransformMakeTable;
import savilerow.treetransformer.TreeTransformerBottomUpNoWrapper;

public class TransformMakeTableScopes
extends TreeTransformerBottomUpNoWrapper {
    TransformMakeTable tmt;
    HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> scopeslist;

    public TransformMakeTableScopes(Model model, TransformMakeTable transformMakeTable) {
        super(model);
        this.tmt = transformMakeTable;
        this.scopeslist = new HashMap();
    }

    @Override
    protected NodeReplacement processNode(ASTNode aSTNode) {
        if (!(aSTNode instanceof And || aSTNode.getParent() == null || !aSTNode.getParent().inTopAnd() || aSTNode instanceof Tag || !aSTNode.isRelation() || aSTNode instanceof Table || aSTNode instanceof TableShort || aSTNode instanceof NegativeTable)) {
            ArrayList<ASTNode> arrayList = this.tmt.getVariablesOrdered(aSTNode);
            ASTNode.sortByAlpha(arrayList);
            if (!this.scopeslist.containsKey(arrayList)) {
                this.scopeslist.put(arrayList, new ArrayList());
            }
            this.scopeslist.get(arrayList).add(aSTNode);
        }
        return null;
    }

    public void doIt() {
        boolean bl = CmdFlags.make_short_tab == 2 || CmdFlags.make_short_tab == 4;
        for (Map.Entry<ArrayList<ASTNode>, ArrayList<ASTNode>> entry : this.scopeslist.entrySet()) {
            ArrayList<ASTNode> arrayList = entry.getValue();
            if (arrayList.size() <= 1) continue;
            And and = new And(arrayList);
            if (TransformMakeTable.verbose) {
                System.out.println("H4");
                System.out.println("Trying ct:" + and);
            }
            TransformMakeTable.RetPair retPair = this.tmt.tryCacheNormalised(and, bl);
            if (retPair.nodereplace != null) {
                this.replaceConstraintSet(arrayList, retPair.nodereplace.current_node);
                continue;
            }
            if (this.tmt.failCache.contains(retPair.expstring)) continue;
            ASTNode aSTNode = this.tmt.normalise(and);
            ASTNode aSTNode2 = CmdFlags.make_short_tab == 3 ? this.tmt.makeTableLong(aSTNode, 10000L, 100000L) : this.tmt.makeTableShort(aSTNode, 10000L, 100000L, 100000L);
            if (aSTNode2 == null) {
                this.tmt.failCache.add(retPair.expstring);
                if (!TransformMakeTable.verbose) continue;
                System.out.println("Adding to failCache:" + retPair.expstring);
                continue;
            }
            this.tmt.saveToCacheNormalised(retPair.expstring, aSTNode, aSTNode2);
            this.replaceConstraintSet(arrayList, aSTNode2);
        }
    }

    private void replaceConstraintSet(ArrayList<ASTNode> arrayList, ASTNode aSTNode) {
        ASTNode aSTNode2 = arrayList.get(0);
        aSTNode2.getParent().setChild(aSTNode2.getChildNo(), aSTNode);
        for (int i = 1; i < arrayList.size(); ++i) {
            aSTNode2 = arrayList.get(i);
            aSTNode2.getParent().setChild(aSTNode2.getChildNo(), new BooleanConstant(true));
        }
    }
}

