/*
 * Decompiled with CFR 0.152.
 */
package savilerow.treetransformer;

import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanDomain;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.EmptyRange;
import savilerow.expression.Identifier;
import savilerow.expression.IntegerDomain;
import savilerow.expression.MatrixDeref;
import savilerow.expression.MatrixDomain;
import savilerow.expression.MatrixSlice;
import savilerow.expression.SafeMatrixDeref;
import savilerow.expression.SimpleDomain;
import savilerow.model.Model;
import savilerow.treetransformer.NodeReplacement;
import savilerow.treetransformer.TreeTransformerBottomUpNoWrapper;

public class TransformMatrixToAtoms
extends TreeTransformerBottomUpNoWrapper {
    ASTNode matid;
    ArrayList<ASTNode> indexdoms;
    ASTNode matrixdomain;
    ASTNode matrixliteral;

    public TransformMatrixToAtoms(String string, Model model) {
        super(model);
        this.matid = new Identifier(this.m, string);
        this.matrixdomain = this.m.global_symbols.getDomain(string);
        this.indexdoms = this.matrixdomain.getChildren(3);
        this.enumerateMatrix(new ArrayList<ASTNode>(this.indexdoms), string, this.matrixdomain.getChild(0), this.matid, new ArrayList<Long>());
        this.m.global_symbols.deleteMatrix(string);
        this.matrixliteral = TransformMatrixToAtoms.enumerateMatrixLiteral(this.indexdoms, string, this.m, this.matrixdomain.getChild(0).isBooleanSet());
    }

    private static final String fmtstr(long l) {
        if (l >= 0L) {
            return String.format("%05d", l);
        }
        return "n" + String.format("%05d", -l);
    }

    private void enumerateMatrix(ArrayList<ASTNode> arrayList, String string, ASTNode aSTNode, ASTNode aSTNode2, ArrayList<Long> arrayList2) {
        if (arrayList.size() == 0) {
            this.m.global_symbols.newVariable(string, aSTNode.copy(), 3, aSTNode2, arrayList2);
        } else {
            ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>(arrayList);
            ASTNode aSTNode3 = arrayList3.remove(0);
            ArrayList<Long> arrayList4 = aSTNode3.getValueSet();
            for (int i = 0; i < arrayList4.size(); ++i) {
                String string2 = TransformMatrixToAtoms.fmtstr(arrayList4.get(i));
                String string3 = string + "_" + string2;
                arrayList2.add(arrayList4.get(i));
                this.enumerateMatrix(arrayList3, string3, aSTNode, aSTNode2, arrayList2);
                arrayList2.remove(arrayList2.size() - 1);
            }
        }
    }

    public static ASTNode enumerateMatrixLiteral(ArrayList<ASTNode> arrayList, String string, Model model, boolean bl) {
        if (arrayList.size() == 0) {
            return new Identifier(model, string);
        }
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>(arrayList);
        ASTNode aSTNode = arrayList2.remove(0);
        ArrayList<Long> arrayList3 = aSTNode.getValueSet();
        ArrayList<ASTNode> arrayList4 = new ArrayList<ASTNode>();
        for (int i = 0; i < arrayList3.size(); ++i) {
            String string2 = TransformMatrixToAtoms.fmtstr(arrayList3.get(i));
            String string3 = string + "_" + string2;
            arrayList4.add(TransformMatrixToAtoms.enumerateMatrixLiteral(arrayList2, string3, model, bl));
        }
        if (arrayList4.size() > 0) {
            return new CompoundMatrix(aSTNode, arrayList4);
        }
        SimpleDomain simpleDomain = bl ? new BooleanDomain(new EmptyRange()) : new IntegerDomain(new EmptyRange());
        return new EmptyMatrix(new MatrixDomain((ASTNode)simpleDomain, new ArrayList<ASTNode>(arrayList)));
    }

    @Override
    protected NodeReplacement processNode(ASTNode aSTNode) {
        if (aSTNode instanceof MatrixSlice && aSTNode.getChild(0).equals(this.matid)) {
            ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
            ASTNode aSTNode2 = MatrixSlice.evaluateSlice(this.matrixliteral, arrayList);
            if (aSTNode2 == null) {
                return new NodeReplacement(new MatrixSlice(this.m, this.matrixliteral, arrayList));
            }
            return new NodeReplacement(aSTNode2);
        }
        if ((aSTNode instanceof MatrixDeref || aSTNode instanceof SafeMatrixDeref) && aSTNode.getChild(0).equals(this.matid)) {
            ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
            ASTNode aSTNode3 = null;
            boolean bl = true;
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                if (aSTNode.getChild(i).isConstant()) continue;
                bl = false;
                break;
            }
            if (bl) {
                aSTNode3 = aSTNode instanceof MatrixDeref ? MatrixDeref.derefCompoundMatrix(this.matrixliteral, arrayList) : SafeMatrixDeref.derefCompoundMatrix(this.matrixliteral, arrayList);
            }
            if (aSTNode3 == null) {
                if (aSTNode instanceof MatrixDeref) {
                    return new NodeReplacement(new MatrixDeref(this.matrixliteral, arrayList));
                }
                return new NodeReplacement(new SafeMatrixDeref(this.matrixliteral, arrayList));
            }
            return new NodeReplacement(aSTNode3);
        }
        if (aSTNode instanceof Identifier && aSTNode.equals(this.matid) && !(aSTNode.getParent() instanceof MatrixDeref) && !(aSTNode.getParent() instanceof SafeMatrixDeref) && !(aSTNode.getParent() instanceof MatrixSlice)) {
            return new NodeReplacement(this.matrixliteral);
        }
        return null;
    }
}

