/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.CompoundMatrix;
import savilerow.EmptyMatrix;
import savilerow.EmptyRange;
import savilerow.IntegerDomain;
import savilerow.Intpair;
import savilerow.MatrixDomain;
import savilerow.NumberConstant;
import savilerow.PairASTNode;
import savilerow.Range;
import savilerow.SymbolTable;
import savilerow.Unary;

public class Flatten
extends Unary {
    public static final long serialVersionUID = 1L;

    public Flatten(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new Flatten(this.getChild(0));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() < 1) {
            System.out.println("ERROR: Expected matrix inside flatten function: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof Flatten) {
            this.getChild(0).setParent(null);
            return this.getChild(0);
        }
        ASTNode aSTNode = this.getChildConst(0);
        if (aSTNode instanceof EmptyMatrix) {
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            arrayList.add(new IntegerDomain(new EmptyRange()));
            return new EmptyMatrix(new MatrixDomain(aSTNode.getChild(0).getChild(0), arrayList));
        }
        if (aSTNode instanceof CompoundMatrix && this.canFlatten(aSTNode)) {
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            this.flatten_compound_matrix(arrayList, aSTNode, aSTNode == this.getChild(0));
            return CompoundMatrix.make(arrayList);
        }
        return null;
    }

    private void flatten_compound_matrix(ArrayList<ASTNode> arrayList, ASTNode aSTNode, boolean bl) {
        assert (aSTNode instanceof CompoundMatrix);
        for (int i = 1; i < aSTNode.numChildren(); ++i) {
            boolean bl2;
            ASTNode aSTNode2 = aSTNode.getChildConst(i);
            boolean bl3 = bl2 = aSTNode2 == aSTNode.getChild(i) && bl;
            if (aSTNode2 instanceof CompoundMatrix) {
                this.flatten_compound_matrix(arrayList, aSTNode2, bl2);
                continue;
            }
            if (aSTNode2 instanceof EmptyMatrix) continue;
            if (bl2) {
                aSTNode2.setParent(null);
            }
            arrayList.add(aSTNode2);
        }
    }

    private boolean canFlatten(ASTNode aSTNode) {
        assert (aSTNode instanceof CompoundMatrix);
        for (int i = 1; i < aSTNode.numChildren(); ++i) {
            boolean bl;
            ASTNode aSTNode2 = aSTNode.getChildConst(i);
            if (!(aSTNode2 instanceof CompoundMatrix ? !(bl = this.canFlatten(aSTNode2)) : !(aSTNode2 instanceof EmptyMatrix) && aSTNode2.getDimension() > 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Intpair getBounds() {
        return this.getChild(0).getBounds();
    }

    @Override
    public PairASTNode getBoundsAST() {
        return this.getChild(0).getBoundsAST();
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        return this.getChild(0).getIntervalSetExp();
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public boolean isRelation() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean isNumerical() {
        return this.getChild(0).isNumerical();
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public ArrayList<ASTNode> getIndexDomains() {
        ArrayList<ASTNode> arrayList = this.getChild(0).getIndexDomains();
        if (arrayList == null) {
            return null;
        }
        long l = 1L;
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList<Intpair> arrayList2 = arrayList.get(i).getIntervalSet();
            long l2 = 0L;
            for (int j = 0; j < arrayList2.size(); ++j) {
                if (arrayList2.get(j).isEmpty()) continue;
                l2 += arrayList2.get((int)j).upper - arrayList2.get((int)j).lower + 1L;
            }
            l *= l2;
        }
        arrayList.clear();
        arrayList.add(new IntegerDomain(new Range((ASTNode)NumberConstant.make(1L), NumberConstant.make(l))));
        return arrayList;
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("flatten(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("flatten(");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (!bl);
        this.getChild(0).toMinion(bufferedWriter, false);
    }

    @Override
    public String toString() {
        return "flatten(" + this.getChild(0) + ")";
    }
}

