/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.CmdFlags;
import savilerow.Intpair;
import savilerow.Letting;
import savilerow.MatrixDomain;
import savilerow.Model;
import savilerow.PairASTNode;
import savilerow.Sat;
import savilerow.SimpleDomain;
import savilerow.SymbolTable;

public class Identifier
extends ASTNode {
    public static final long serialVersionUID = 1L;
    protected transient Model m;
    private String name;

    public Identifier(Model model, String string) {
        this.name = string;
        this.m = model;
    }

    @Override
    public boolean hasModel() {
        return true;
    }

    @Override
    public Model getModel() {
        return this.m;
    }

    @Override
    public void setModel(Model model) {
        this.m = model;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public ASTNode copy() {
        return new Identifier(this.m, this.name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Identifier)) {
            return false;
        }
        return ((Identifier)object).name.equals(this.name);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean isRelation() {
        ASTNode aSTNode = this.getDomain();
        if (aSTNode.isBooleanSet()) {
            return true;
        }
        return aSTNode instanceof MatrixDomain && aSTNode.getChild(0).isBooleanSet();
    }

    @Override
    public boolean strongProp() {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return !this.isRelation() && !this.isSet();
    }

    @Override
    public boolean isSet() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>(this.m.global_symbols.lettings_givens);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!(arrayList.get(i) instanceof Letting) || !arrayList.get(i).getChild(0).equals(this) || !arrayList.get(i).getChild(1).isSet()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCategory() {
        if (this.m.global_symbols.hasVariable(this.name)) {
            return this.m.global_symbols.getCategory(this.name);
        }
        if (this.getDomainForId(this) != null) {
            return 2;
        }
        return 20;
    }

    public boolean isAuxiliary() {
        return this.m.global_symbols.isAuxiliary(this.name);
    }

    public ASTNode getCM() {
        if (this.getCategory() == 0) {
            return this.m.cmstore.getConstantMatrix(this.name);
        }
        return this;
    }

    @Override
    public int getDimension() {
        ASTNode aSTNode = this.getDomainForId(this);
        if (aSTNode == null) {
            aSTNode = this.m.global_symbols.getDomain(this.name);
        }
        if (aSTNode instanceof MatrixDomain) {
            return aSTNode.numChildren() - 3;
        }
        return 0;
    }

    @Override
    public ArrayList<ASTNode> getIndexDomains() {
        if (this.getDimension() == 0) {
            return null;
        }
        ASTNode aSTNode = this.getDomainForId(this);
        if (aSTNode == null) {
            aSTNode = this.m.global_symbols.getDomain(this.name);
        }
        if (aSTNode instanceof MatrixDomain) {
            ArrayList<ASTNode> arrayList = aSTNode.getChildren(3);
            return arrayList;
        }
        assert (false);
        return null;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        boolean bl;
        assert (symbolTable.m == this.m);
        boolean bl2 = this.m.global_symbols.hasVariable(this.name);
        boolean bl3 = bl = this.getDomainForId(this) != null;
        if (!bl2 && !bl) {
            CmdFlags.println("ERROR: Identifier not defined: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.m.global_symbols.replacements.get(this);
        if (aSTNode != null) {
            return aSTNode.copy();
        }
        return null;
    }

    public ASTNode getDomain() {
        ASTNode aSTNode = this.m.global_symbols.getDomain(this.name);
        if (aSTNode == null) {
            aSTNode = this.getDomainForId(this);
        }
        assert (aSTNode != null);
        return aSTNode;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ASTNode aSTNode = this.getDomain();
        if (aSTNode instanceof MatrixDomain) {
            aSTNode = aSTNode.getChild(0);
        }
        return aSTNode.getIntervalSet();
    }

    @Override
    public Intpair getBounds() {
        ASTNode aSTNode = this.getDomain();
        if (aSTNode instanceof MatrixDomain) {
            aSTNode = aSTNode.getChild(0);
        }
        return aSTNode.getBounds();
    }

    @Override
    public PairASTNode getBoundsAST() {
        int n = this.getCategory();
        if (n == 20) {
            System.out.println(this);
        }
        assert (n != 20);
        if (n == 1 || n == 0) {
            ASTNode aSTNode = this.m.global_symbols.getDomain(this.name);
            if (aSTNode instanceof SimpleDomain) {
                return new PairASTNode(this, this);
            }
            if (aSTNode instanceof MatrixDomain) {
                return aSTNode.getChild(0).getBoundsAST();
            }
            System.out.println("Strange parameter type in Identifier.java");
            assert (false);
            return new PairASTNode(this, this);
        }
        if (n == 2) {
            ASTNode aSTNode = this.getDomainForId(this);
            assert (aSTNode != null);
            if (aSTNode instanceof MatrixDomain) {
                aSTNode = aSTNode.getChild(0);
            }
            PairASTNode pairASTNode = aSTNode.getBoundsAST();
            while (pairASTNode.e1.getCategory() > 1) {
                pairASTNode.e1 = pairASTNode.e1.getBoundsAST().e1;
            }
            while (pairASTNode.e2.getCategory() > 1) {
                pairASTNode.e2 = pairASTNode.e2.getBoundsAST().e2;
            }
            return pairASTNode;
        }
        assert (n == 3);
        ASTNode aSTNode = this.m.global_symbols.getDomain(this.name);
        if (aSTNode instanceof MatrixDomain) {
            aSTNode = aSTNode.getChild(0);
        }
        return aSTNode.getBoundsAST();
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (bl) {
            if (CmdFlags.getUseBoundVars() && this.exceedsBoundThreshold()) {
                bufferedWriter.append("eq(");
            } else {
                bufferedWriter.append("w-literal(");
            }
            bufferedWriter.append(this.name);
            bufferedWriter.append(",1)");
        } else {
            bufferedWriter.append(this.name);
        }
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append("literal(");
            stringBuilder.append(this.name);
            stringBuilder.append(",1)");
        } else {
            stringBuilder.append(this.name);
        }
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append(this.name);
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        ASTNode aSTNode = this.m.global_symbols.getDomain(this.name);
        if (this.m.global_symbols.hasVariable(this.name) && (aSTNode.isBooleanSet() || aSTNode.isIntegerSet() && aSTNode.getBounds().equals(new Intpair(0L, 1L)))) {
            if (bl) {
                bufferedWriter.append(this.name + "_BOOL");
            } else {
                bufferedWriter.append(this.name + "_INTEGER");
            }
        } else {
            bufferedWriter.append(this.name);
        }
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        ASTNode aSTNode = this.m.global_symbols.getDomain(this.name);
        if (this.m.global_symbols.hasVariable(this.name) && (aSTNode.isBooleanSet() || aSTNode.isIntegerSet() && aSTNode.getBounds().equals(new Intpair(0L, 1L)))) {
            if (bl) {
                stringBuilder.append(this.name + "_BOOL");
            } else {
                stringBuilder.append(this.name + "_INTEGER");
            }
        } else {
            stringBuilder.append(this.name);
        }
    }

    @Override
    public long directEncode(Sat sat, long l) {
        return sat.getDirectVariable(this.name, l);
    }

    @Override
    public long orderEncode(Sat sat, long l) {
        return sat.getOrderVariable(this.name, l);
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        if (this.isRelation()) {
            return sat.getDirectVariable(this.name, 1L);
        }
        return null;
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        long l2 = sat.getDirectVariable(this.name, 1L);
        sat.addClause(-l, l2);
        sat.addClause(l, -l2);
    }

    @Override
    public void toJSON(StringBuilder stringBuilder) {
        stringBuilder.append("\"$" + this.name + "\"\n");
    }
}

