/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.util.ArrayList;
import java.util.Arrays;
import savilerow.ASTNode;
import savilerow.IntegerDomainConcrete;
import savilerow.Intpair;
import savilerow.NumberConstant;
import savilerow.PairASTNode;
import savilerow.SimpleDomain;

public class IntegerDomainConcreteArray
extends SimpleDomain {
    public static final long serialVersionUID = 1L;
    private long[] intervals;

    public IntegerDomainConcreteArray(long[] lArray) {
        assert (lArray.length >= 2);
        assert (lArray.length % 2 == 0);
        this.intervals = lArray;
    }

    public IntegerDomainConcreteArray(ArrayList<Intpair> arrayList) {
        assert (arrayList.size() >= 1);
        this.intervals = new long[arrayList.size() * 2];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.intervals[i * 2] = arrayList.get((int)i).lower;
            this.intervals[i * 2 + 1] = arrayList.get((int)i).upper;
        }
    }

    @Override
    public ASTNode copy() {
        return new IntegerDomainConcreteArray(this.intervals);
    }

    @Override
    public ASTNode simplify() {
        if (this.intervals.length == 2 && this.intervals[0] >= Integer.MIN_VALUE && this.intervals[1] <= Integer.MAX_VALUE) {
            return new IntegerDomainConcrete((int)this.intervals[0], (int)this.intervals[1]);
        }
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof IntegerDomainConcreteArray)) {
            return false;
        }
        IntegerDomainConcreteArray integerDomainConcreteArray = (IntegerDomainConcreteArray)object;
        return Arrays.equals(this.intervals, integerDomainConcreteArray.intervals);
    }

    @Override
    public int hashCode() {
        if (this.hashCache == Integer.MIN_VALUE) {
            int n;
            this.hashCache = n = 5651 + Arrays.hashCode(this.intervals);
            return n;
        }
        return this.hashCache;
    }

    @Override
    public Intpair getBounds() {
        return new Intpair(this.intervals[0], this.intervals[this.intervals.length - 1]);
    }

    @Override
    public PairASTNode getBoundsAST() {
        return new PairASTNode(NumberConstant.make(this.intervals[0]), NumberConstant.make(this.intervals[this.intervals.length - 1]));
    }

    @Override
    public ArrayList<Intpair> getIntervalSet() {
        ArrayList<Intpair> arrayList = new ArrayList<Intpair>(this.intervals.length / 2);
        for (int i = 0; i < this.intervals.length; i += 2) {
            arrayList.add(new Intpair(this.intervals[i], this.intervals[i + 1]));
        }
        return arrayList;
    }

    @Override
    public boolean isFiniteSetUpper() {
        return true;
    }

    @Override
    public boolean isFiniteSetLower() {
        return true;
    }

    @Override
    public boolean isFiniteSet() {
        return true;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("int(");
        for (int i = 0; i < this.intervals.length; i += 2) {
            if (this.intervals[i] == this.intervals[i + 1]) {
                stringBuilder.append(this.intervals[i]);
            } else {
                stringBuilder.append(this.intervals[i]);
                stringBuilder.append("..");
                stringBuilder.append(this.intervals[i + 1]);
            }
            if (i >= this.intervals.length - 2) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public ASTNode applyShift(int n) {
        long[] lArray = new long[this.intervals.length];
        for (int i = 0; i < this.intervals.length; ++i) {
            lArray[i] = this.intervals[i] + (long)n;
        }
        return new IntegerDomainConcreteArray(lArray);
    }

    @Override
    public boolean containsValue(long l) {
        for (int i = 0; i < this.intervals.length; i += 2) {
            if (l < this.intervals[i] || l > this.intervals[i + 1]) continue;
            return true;
        }
        return false;
    }
}

