/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.Identifier;
import savilerow.Intpair;
import savilerow.MaxSATObjective;
import savilerow.Sat;
import savilerow.SymbolTable;

public class Maximising
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Maximising(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        assert (this.numChildren() == 1);
        return new Maximising(this.getChild(0));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() > 1) {
            CmdFlags.println("ERROR: Expected numerical expression or one-dimensional matrix in maximising, found a matrix: " + this);
            return false;
        }
        if (this.getChild(0).getDimension() == 1 && !(this.getChild(0) instanceof CompoundMatrix)) {
            CmdFlags.println("ERROR: Expected numerical expression or one-dimensional literal matrix in minimising, found a matrix: " + this);
            return false;
        }
        return true;
    }

    @Override
    public int polarity(int n) {
        return 1;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("MAXIMISING ");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append("\n");
    }

    @Override
    public String toString() {
        return "maximising " + this.getChild(0) + "\n";
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("maximising ");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("\n");
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (!this.getChild(0).isConstant()) {
            bufferedWriter.append("maximize ");
            this.getChild(0).toFlatzinc(bufferedWriter, false);
            bufferedWriter.append(";\n");
        } else {
            bufferedWriter.append("satisfy;\n");
        }
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("maximize ");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(";\n");
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        if (this.getChild(0) instanceof Identifier) {
            ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
            for (int i = 0; i < arrayList.size(); ++i) {
                Intpair intpair = arrayList.get(i);
                for (long j = intpair.lower; j <= intpair.upper; ++j) {
                    if (i >= arrayList.size() - 1 && j >= intpair.upper) continue;
                    sat.addSoftClause(-this.getChild(0).orderEncode(sat, j));
                }
            }
        } else {
            assert (this.getChild(0) instanceof MaxSATObjective);
            this.getChild(0).toSAT(sat);
        }
    }
}

