/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.BinOp;
import savilerow.Divide;
import savilerow.Intpair;
import savilerow.Max;
import savilerow.Min;
import savilerow.NumberConstant;
import savilerow.PairASTNode;
import savilerow.Sat;
import savilerow.Times;
import savilerow.TransformSimplify;

public class MultiplyMapper
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public MultiplyMapper(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new MultiplyMapper(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp();
    }

    @Override
    public ASTNode simplify() {
        assert (this.getChild(0).getCategory() <= 3 || this.getChild(0).getCategory() == 20);
        assert (this.getChild(1).getCategory() <= 2 || this.getChild(1).getCategory() == 20);
        if (this.getChild(0).isConstant()) {
            this.detachChildren();
            return new Times(this.getChild(0), this.getChild(1));
        }
        if (this.getChild(1).equals(NumberConstant.make(1L))) {
            this.getChild(0).setParent(null);
            return this.getChild(0);
        }
        if (this.getChild(1).equals(NumberConstant.make(0L))) {
            return NumberConstant.make(0L);
        }
        if (this.getChild(0) instanceof MultiplyMapper) {
            this.getChild(0).detachChildren();
            this.getChild(1).setParent(null);
            ASTNode aSTNode = BinOp.makeBinOp("*", this.getChild(1), this.getChild(0).getChild(1));
            return new MultiplyMapper(this.getChild(0).getChild(0), aSTNode);
        }
        return null;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        for (int i = 1; i < this.numChildren(); ++i) {
            Intpair intpair2 = this.getChild(i).getBounds();
            long l = Times.multiply(intpair.lower, intpair2.lower);
            long l2 = Times.multiply(intpair.upper, intpair2.lower);
            long l3 = Times.multiply(intpair.lower, intpair2.upper);
            long l4 = Times.multiply(intpair.upper, intpair2.upper);
            intpair.lower = Math.min(l, Math.min(l2, Math.min(l3, l4)));
            intpair.upper = Math.max(l, Math.max(l2, Math.max(l3, l4)));
        }
        return intpair;
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(0).getBoundsAST();
        for (int i = 1; i < this.numChildren(); ++i) {
            PairASTNode pairASTNode2 = this.getChild(i).getBoundsAST();
            Times times = new Times(pairASTNode.e1, pairASTNode2.e1);
            Times times2 = new Times(pairASTNode.e2, pairASTNode2.e1);
            Times times3 = new Times(pairASTNode.e1, pairASTNode2.e2);
            Times times4 = new Times(pairASTNode.e2, pairASTNode2.e2);
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            arrayList.add(times);
            arrayList.add(times2);
            arrayList.add(times3);
            arrayList.add(times4);
            pairASTNode.e1 = new Min(arrayList);
            pairASTNode.e2 = new Max(arrayList);
        }
        return pairASTNode;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
        long l = this.getChild(1).getValue();
        return Intpair.multIntervalSet(arrayList, l);
    }

    @Override
    public String toString() {
        return "mult(" + this.getChild(0) + ", " + this.getChild(1) + ")";
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        if (this.getChild(1).equals(NumberConstant.make(-1L))) {
            stringBuilder.append("neg(");
            this.getChild(0).toDominion(stringBuilder, false);
            stringBuilder.append(")");
            return;
        }
        PairASTNode pairASTNode = this.getChild(1).getBoundsAST();
        TransformSimplify transformSimplify = new TransformSimplify();
        pairASTNode.e1 = transformSimplify.transform(pairASTNode.e1);
        if (pairASTNode.e1.isConstant() && pairASTNode.e1.getValue() >= 0L) {
            stringBuilder.append("posmult(");
            this.getChild(0).toDominion(stringBuilder, false);
            stringBuilder.append(",");
            this.getChild(1).toDominion(stringBuilder, false);
            stringBuilder.append(")");
            return;
        }
        stringBuilder.append("mult(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public long directEncode(Sat sat, long l) {
        long l2 = this.getChild(1).getValue();
        if (l % l2 != 0L) {
            return -sat.getTrue();
        }
        return this.getChild(0).directEncode(sat, l / l2);
    }

    @Override
    public long orderEncode(Sat sat, long l) {
        long l2 = this.getChild(1).getValue();
        if (l2 > 0L) {
            return this.getChild(0).orderEncode(sat, Divide.div(l, l2));
        }
        long l3 = Divide.divceil(l, l2);
        return -this.getChild(0).orderEncode(sat, l3 - 1L);
    }
}

