/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import savilerow.ASTNode;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.Identifier;
import savilerow.Implies;
import savilerow.SATLiteral;
import savilerow.Sat;
import savilerow.SymbolTable;
import savilerow.Unary;

public class Negate
extends Unary {
    public static final long serialVersionUID = 1L;

    public Negate(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new Negate(this.getChild(0));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp();
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).isConstant()) {
            if (this.getChild(0).getValue() == 0L) {
                return new BooleanConstant(true);
            }
            return new BooleanConstant(false);
        }
        if (this.getChild(0).isNegatable()) {
            return this.getChild(0).negation();
        }
        return null;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        return this.getChild(0);
    }

    @Override
    public boolean toFlatten(boolean bl) {
        if ((CmdFlags.getMiniontrans() || CmdFlags.getSattrans()) && this.getChild(0) instanceof Identifier) {
            return false;
        }
        if ((CmdFlags.getGecodetrans() || CmdFlags.getChuffedtrans() || CmdFlags.getMinizinctrans()) && this.getParent() instanceof Implies) {
            return false;
        }
        return super.toFlatten(bl);
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (!this.getChild(0).isRelation()) {
            System.out.println("ERROR: Boolean negation contains numerical expression:" + this);
            return false;
        }
        return true;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (bl) {
            bufferedWriter.append("w-literal(");
            this.getChild(0).toMinion(bufferedWriter, false);
            bufferedWriter.append(",0)");
        } else {
            bufferedWriter.append("!");
            this.getChild(0).toMinion(bufferedWriter, false);
        }
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("constraint bool_eq(");
        this.getChild(0).toFlatzinc(bufferedWriter, true);
        bufferedWriter.append(",false);");
    }

    @Override
    public String toString() {
        return "(!" + this.getChild(0) + ")";
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("not(");
        this.getChild(0).toDominion(stringBuilder, true);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("(!");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(not ");
        this.getChild(0).toMinizinc(stringBuilder, true);
        stringBuilder.append(")");
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        if (this.getChild(0) instanceof SATLiteral) {
            return -((SATLiteral)this.getChild(0)).getLit();
        }
        return null;
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        this.getChild(0).toSATWithAuxVar(sat, -sat.getTrue());
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        this.getChild(0).toSATWithAuxVar(sat, -l);
    }
}

