/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.BooleanConstant;
import savilerow.Intpair;
import savilerow.Model;
import savilerow.Sat;

public class SATLiteral
extends ASTNodeC {
    public static final long serialVersionUID = 1L;
    private long lit;
    protected transient Model m;

    public SATLiteral(long l, Model model) {
        this.lit = l;
        this.m = model;
    }

    @Override
    public boolean hasModel() {
        return true;
    }

    @Override
    public Model getModel() {
        return this.m;
    }

    @Override
    public void setModel(Model model) {
        this.m = model;
    }

    @Override
    public String toString() {
        return "SATLiteral(" + String.valueOf(this.lit) + ")";
    }

    public long getLit() {
        return this.lit;
    }

    @Override
    public ASTNode copy() {
        return new SATLiteral(this.lit, this.getModel());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SATLiteral)) {
            return false;
        }
        return ((SATLiteral)object).lit == this.lit;
    }

    @Override
    public int hashCode() {
        return 12799 + (int)(this.lit ^ this.lit >>> 32);
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public boolean isSet() {
        return false;
    }

    @Override
    public int getCategory() {
        return 3;
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public ASTNode simplify() {
        if (this.lit == this.getModel().satModel.getTrue()) {
            return new BooleanConstant(true);
        }
        if (this.lit == -this.getModel().satModel.getTrue()) {
            return new BooleanConstant(false);
        }
        return null;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = new ArrayList<Intpair>();
        arrayList.add(new Intpair(0L, 1L));
        return arrayList;
    }

    @Override
    public long directEncode(Sat sat, long l) {
        if (l == 0L) {
            return -this.lit;
        }
        if (l == 1L) {
            return this.lit;
        }
        return -sat.getTrue();
    }

    @Override
    public long orderEncode(Sat sat, long l) {
        if (l == 0L) {
            return -this.lit;
        }
        if (l >= 1L) {
            return sat.getTrue();
        }
        return -sat.getTrue();
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        return new SATLiteral(-this.lit, this.getModel());
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        sat.addClause(this.lit);
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        sat.addClause(-l, this.lit);
        sat.addClause(l, -this.lit);
    }
}

