/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.CmdFlags;
import savilerow.Intpair;
import savilerow.Max;
import savilerow.Min;
import savilerow.NumberConstant;
import savilerow.PairASTNode;
import savilerow.Sat;
import savilerow.SymbolTable;
import savilerow.Times;
import savilerow.Unary;
import savilerow.WeightedSum;

public class UnaryMinus
extends Unary {
    public static final long serialVersionUID = 1L;

    public UnaryMinus(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new UnaryMinus(this.getChild(0));
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof UnaryMinus) {
            this.getChild(0).getChild(0).setParent(null);
            return this.getChild(0).getChild(0);
        }
        if (this.getChild(0).isConstant()) {
            return NumberConstant.make(-this.getChild(0).getValue());
        }
        if (this.getChild(0) instanceof WeightedSum) {
            long[] lArray = ((WeightedSum)this.getChild(0)).getWeightsArray();
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = -lArray[i];
            }
            this.getChild(0).detachChildren();
            return new WeightedSum(this.getChild(0).getChildrenArray(), lArray);
        }
        if (this.getChild(0) instanceof Times) {
            this.getChild(0).detachChildren();
            ASTNode[] aSTNodeArray = this.getChild(0).getChildrenArray();
            aSTNodeArray[0] = new UnaryMinus(aSTNodeArray[0]);
            return new Times(aSTNodeArray);
        }
        if (this.getChild(0) instanceof Max || this.getChild(0) instanceof Min) {
            this.getChild(0).detachChildren();
            ASTNode[] aSTNodeArray = this.getChild(0).getChildrenArray();
            for (int i = 0; i < aSTNodeArray.length; ++i) {
                aSTNodeArray[i] = new UnaryMinus(aSTNodeArray[i]);
            }
            if (this.getChild(0) instanceof Max) {
                return new Min(aSTNodeArray);
            }
            return new Max(aSTNodeArray);
        }
        return null;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() > 0) {
            CmdFlags.println("ERROR: Unexpected matrix in unary minus: " + this);
            return false;
        }
        if (this.getChild(0).isSet()) {
            CmdFlags.println("ERROR: Unexpected set in unary minus: " + this);
            return false;
        }
        return true;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return !CmdFlags.getDominiontrans();
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public void toMinionWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        bufferedWriter.append("minuseq(");
        aSTNode.toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    @Override
    public void toFlatzincWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        bufferedWriter.append("constraint int_negate(");
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",");
        aSTNode.toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(-");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public String toString() {
        return "(-" + this.getChild(0) + ")";
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("neg(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("(-");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        long l = intpair.lower == Long.MIN_VALUE ? Long.MAX_VALUE : -intpair.lower;
        intpair.lower = intpair.upper == Long.MAX_VALUE ? Long.MIN_VALUE : -intpair.upper;
        intpair.upper = l;
        return intpair;
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(0).getBoundsAST();
        UnaryMinus unaryMinus = new UnaryMinus(pairASTNode.e2);
        UnaryMinus unaryMinus2 = new UnaryMinus(pairASTNode.e1);
        pairASTNode.e1 = unaryMinus;
        pairASTNode.e2 = unaryMinus2;
        return pairASTNode;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        return Intpair.multIntervalSet(this.getChild(0).getIntervalSetExp(), -1L);
    }

    @Override
    public void toSATWithAuxVar(Sat sat, ASTNode aSTNode) throws IOException {
        sat.supportEncodingBinary(this, this.getChild(0), aSTNode);
    }

    @Override
    public boolean test(long l, long l2) {
        return l == -l2;
    }
}

