/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.CompoundMatrix;
import savilerow.Concatenate;
import savilerow.EmptyMatrix;
import savilerow.Identifier;
import savilerow.SymbolTable;

public class ConcatenateMatrix
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public ConcatenateMatrix(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new ConcatenateMatrix(this.getChild(0));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() < 2) {
            System.out.println("ERROR: Expected 2-dimensional or greater matrix inside concatenate (flatten) function: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof CompoundMatrix || this.getChild(0) instanceof EmptyMatrix) {
            this.getChild(0).detachChildren();
            ASTNode[] aSTNodeArray = this.getChild(0).getChildrenArray(1);
            return new Concatenate(aSTNodeArray);
        }
        if (this.getChild(0) instanceof Identifier && this.getChild(0).getCategory() == 0) {
            ASTNode[] aSTNodeArray = ((Identifier)this.getChild(0)).getCM().getChildrenArray(1);
            return new Concatenate(aSTNodeArray);
        }
        return null;
    }

    @Override
    public int getDimension() {
        return this.getChild(0).getDimension() - 1;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("flatten(");
        stringBuilder.append(this.getChild(0));
        stringBuilder.append(",1)");
        return stringBuilder.toString();
    }
}

