/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.BinOp;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.Intpair;
import savilerow.NumberConstant;
import savilerow.PairASTNode;
import savilerow.SymbolTable;

public class Element
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Element(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Element(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp() && this.getChild(1).strongProp();
    }

    @Override
    public boolean isNumerical() {
        return this.getChild(0).isNumerical();
    }

    @Override
    public boolean toFlatten(boolean bl) {
        if (this.isNumerical()) {
            return true;
        }
        return super.toFlatten(bl);
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < 2; ++i) {
            if (this.getChild(i).typecheck(symbolTable)) continue;
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix for first argument of element constraint: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        if (aSTNode instanceof CompoundMatrix) {
            if (this.getChild(1).isConstant()) {
                long l = this.getChild(1).getValue();
                if (l < 0L || l >= (long)(aSTNode.numChildren() - 1)) {
                    return null;
                }
                ASTNode aSTNode2 = aSTNode.getChild((int)l + 1);
                if (aSTNode == this.getChild(0)) {
                    aSTNode2.setParent(null);
                }
                return aSTNode2;
            }
            Intpair intpair = this.getChild(1).getBounds();
            int n = aSTNode.numChildren() - 1;
            if (intpair.upper < (long)(n - 1)) {
                ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>((int)(intpair.upper + 1L));
                if (aSTNode == this.getChild(0)) {
                    aSTNode.detachChildren();
                }
                this.getChild(1).setParent(null);
                int n2 = 1;
                while ((long)n2 <= intpair.upper + 1L) {
                    arrayList.add(aSTNode.getChild(n2));
                    ++n2;
                }
                return new Element(CompoundMatrix.make(arrayList), this.getChild(1));
            }
            if (this.getChild(1).toFlatten(false) && (intpair.lower > 0L || intpair.upper < (long)(n - 1))) {
                ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>((int)(intpair.upper - intpair.lower + 1L));
                if (intpair.lower < 0L) {
                    intpair.lower = 0L;
                }
                if (intpair.upper > (long)(n - 1)) {
                    intpair.upper = n - 1;
                }
                if (aSTNode == this.getChild(0)) {
                    aSTNode.detachChildren();
                }
                this.getChild(1).setParent(null);
                int n3 = (int)intpair.lower;
                while ((long)n3 <= intpair.upper) {
                    arrayList.add(aSTNode.getChild(n3 + 1));
                    ++n3;
                }
                return new Element(CompoundMatrix.make(arrayList), BinOp.makeBinOp("-", this.getChild(1), NumberConstant.make(intpair.lower)));
            }
        }
        return null;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        return intpair;
    }

    @Override
    public PairASTNode getBoundsAST() {
        return this.getChild(0).getBoundsAST();
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        return this.getChild(0).getIntervalSetExp();
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        assert (this.isRelation());
        this.toMinionWithAuxVar(bufferedWriter, new BooleanConstant(true));
    }

    @Override
    public void toMinionWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        if (CmdFlags.getUseBoundVars() && (aSTNode.exceedsBoundThreshold() || this.getChild(0).exceedsBoundThreshold() || this.getChild(1).exceedsBoundThreshold())) {
            bufferedWriter.append("element(");
        } else {
            bufferedWriter.append("watchelement(");
        }
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        aSTNode.toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    @Override
    public void toDominionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("element(flatten(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("), ");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        aSTNode.toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }
}

